/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler;

import java.io.File;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;
import ovh.corail.recycler.ModBlocks;
import ovh.corail.recycler.ModItems;
import ovh.corail.recycler.core.IProxy;
import ovh.corail.recycler.core.RecyclingManager;
import ovh.corail.recycler.handler.CommandHandler;
import ovh.corail.recycler.handler.GuiHandler;
import ovh.corail.recycler.handler.PacketHandler;
import ovh.corail.recycler.handler.SoundHandler;
import ovh.corail.recycler.tileentity.TileEntityRecycler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Mod(modid="recycler", name="Corail Recycler", version="3.2.4", acceptedMinecraftVersions="[1.12,1.13)", updateJSON="https://raw.githubusercontent.com/Corail31/recycler/master/update.json")
public class ModRecycler {
    @Mod.Instance(value="recycler")
    public static ModRecycler instance;
    @SidedProxy(clientSide="ovh.corail.recycler.core.ClientProxy", serverSide="ovh.corail.recycler.core.CommonProxy")
    public static IProxy proxy;
    public static Logger logger;
    public static final CreativeTabs tabRecycler;
    public static File configDir;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        configDir = new File(event.getModConfigurationDirectory(), "recycler");
        if (!configDir.exists() && !configDir.mkdir()) {
            logger.warn("Impossible to create the config folder");
        }
        SoundHandler.registerSounds();
        GameRegistry.registerTileEntity(TileEntityRecycler.class, (String)"recycler:recycler");
        PacketHandler.init();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        OreDictionary.registerOre((String)"nuggetDiamond", (Item)ModItems.diamond_shard);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
        RecyclingManager.getInstance().loadRecipes();
    }

    static {
        tabRecycler = new CreativeTabs("recycler"){

            public ItemStack func_78016_d() {
                return new ItemStack(Item.func_150898_a((Block)ModBlocks.recycler));
            }

            public String func_78024_c() {
                return "Corail Recycler";
            }
        };
    }
}

