/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.core;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.recycler.core.Helper;
import ovh.corail.recycler.handler.PacketHandler;
import ovh.corail.recycler.packet.ClientLoginMessage;

@Config(modid="recycler", name="recycler", category="config")
@Mod.EventBusSubscriber(modid="recycler")
public class ModConfig {
    @Config.Name(value="unbalanced_recipes")
    @Config.LangKey(value="recycler.config.unbalanced_recipes")
    public static boolean unbalanced_recipes = false;
    @Config.Name(value="only_user_recipes")
    @Config.LangKey(value="recycler.config.only_user_recipes")
    public static boolean only_user_recipes = false;
    @Config.Name(value="recycle_magic_item")
    @Config.LangKey(value="recycler.config.recycle_magic_item")
    public static boolean recycle_magic_item = true;
    @Config.Name(value="recycle_enchanted_book")
    @Config.LangKey(value="recycler.config.recycle_enchanted_book")
    public static boolean recycle_enchanted_book = true;
    @Config.Name(value="chance_loss")
    @Config.LangKey(value="recycler.config.chance_loss")
    @Config.RangeInt(min=0, max=100)
    public static int chance_loss = 0;
    @Config.Name(value="allow_sound")
    @Config.LangKey(value="recycler.config.allow_sound")
    public static boolean allow_sound = true;
    @Config.Name(value="time_to_recycle")
    @Config.LangKey(value="recycler.config.time_to_recycle")
    @Config.RangeInt(min=5, max=1000)
    public static int time_to_recycle = 100;
    @Config.Name(value="recycle_round_down")
    @Config.LangKey(value="recycler.config.recycle_round_down")
    public static boolean recycle_round_down = false;
    @Config.Name(value="allow_automation")
    @Config.LangKey(value="recycler.config.allow_automation")
    public static boolean allow_automation = true;

    @SubscribeEvent(priority=EventPriority.LOW)
    @SideOnly(value=Side.CLIENT)
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("recycler")) {
            ConfigManager.sync((String)"recycler", (Config.Type)Config.Type.INSTANCE);
            if (Minecraft.func_71410_x().func_71356_B()) {
                ServerDatas.serverAllowAutomation = allow_automation;
                PacketHandler.INSTANCE.sendToAll((IMessage)new ClientLoginMessage(allow_automation));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerLogued(PlayerEvent.PlayerLoggedInEvent event) {
        if (Helper.isValidPlayerMP((EntityLivingBase)event.player)) {
            PacketHandler.INSTANCE.sendTo((IMessage)new ClientLoginMessage(allow_automation), (EntityPlayerMP)event.player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ServerDatas {
        public static boolean serverAllowAutomation;
    }
}

