/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import ovh.corail.recycler.core.TranslationHelper;
import ovh.corail.recycler.gui.ButtonRecyclingBook;
import ovh.corail.recycler.gui.ContainerRecyclingBook;
import ovh.corail.recycler.handler.PacketHandler;
import ovh.corail.recycler.packet.ServerRecyclerMessage;
import ovh.corail.recycler.tileentity.TileEntityRecycler;

@SideOnly(value=Side.CLIENT)
public class GuiRecyclingBook
extends GuiContainer {
    private final TileEntityRecycler recycler;
    private GuiTextField searchBox;
    private static final ResourceLocation textureVanillaRecycler = new ResourceLocation("recycler:textures/gui/vanilla_recycler.png");
    private static final ResourceLocation textureRecyclingBook = new ResourceLocation("recycler:textures/gui/book.png");

    public GuiRecyclingBook(TileEntityRecycler recycler) {
        super((Container)new ContainerRecyclingBook(recycler));
        this.recycler = recycler;
        this.field_146999_f = 250;
        this.field_147000_g = 150;
    }

    private void updateButton(int buttonNum, boolean state) {
        if (buttonNum < 0 || buttonNum >= this.field_146292_n.size()) {
            return;
        }
        ((GuiButton)this.field_146292_n.get((int)buttonNum)).field_146124_l = state;
        ((GuiButton)this.field_146292_n.get((int)buttonNum)).field_146125_m = state;
    }

    private void updateButtons() {
        if (this.recycler.getRecyclingBookPageNum() <= 0) {
            this.recycler.setRecyclingBookPageNum(0);
            this.updateButton(0, false);
            this.updateButton(1, this.recycler.getRecyclingBookPageMax() > 0);
        } else if (this.recycler.getRecyclingBookPageNum() + 1 >= this.recycler.getRecyclingBookPageMax()) {
            this.recycler.setRecyclingBookPageNum(this.recycler.getRecyclingBookPageMax() - 1);
            this.updateButton(0, true);
            this.updateButton(1, false);
        } else {
            this.updateButton(0, true);
            this.updateButton(1, true);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchBox.func_146201_a(typedChar, keyCode)) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new ServerRecyclerMessage(ServerRecyclerMessage.MessageAction.SEARCH_TEXT, this.recycler.func_174877_v(), this.searchBox.func_146179_b()));
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.loadSearchBox();
        this.field_146292_n.clear();
        this.field_146292_n.add(new ButtonRecyclingBook(0, this.field_147003_i + 20, this.field_147009_r + 135));
        this.field_146292_n.add(new ButtonRecyclingBook(1, this.field_147003_i + 208, this.field_147009_r + 135));
    }

    private void loadSearchBox() {
        this.searchBox = new GuiTextField(2, this.field_146289_q, this.field_146999_f / 2 - 32, 139, 64, 12);
        this.searchBox.func_146185_a(true);
        this.searchBox.func_146195_b(true);
        this.searchBox.func_146203_f(20);
        this.searchBox.func_146180_a("");
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                if (this.recycler.getRecyclingBookPageNum() <= 0) break;
                PacketHandler.INSTANCE.sendToServer((IMessage)new ServerRecyclerMessage(ServerRecyclerMessage.MessageAction.CHANGE_PAGE, this.recycler.func_174877_v(), this.recycler.getRecyclingBookPageNum() - 1));
                break;
            }
            case 1: {
                if (this.recycler.getRecyclingBookPageNum() + 1 >= this.recycler.getRecyclingBookPageMax()) break;
                PacketHandler.INSTANCE.sendToServer((IMessage)new ServerRecyclerMessage(ServerRecyclerMessage.MessageAction.CHANGE_PAGE, this.recycler.func_174877_v(), this.recycler.getRecyclingBookPageNum() + 1));
                break;
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.updateButtons();
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(textureRecyclingBook);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(textureVanillaRecycler);
        for (Slot slot : this.field_147002_h.field_75151_b) {
            this.func_73729_b(this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, 112, 222, 16, 16);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        this.field_147002_h.field_75151_b.stream().filter(p -> p.getSlotIndex() % 10 == 0 && !p.func_75211_c().func_190926_b()).forEach(c -> this.func_73731_b(this.field_146289_q, c.func_75211_c().func_82833_r(), (c.field_75223_e - 2) * 2, (c.field_75221_f - 22) * 2, 13938487));
        this.field_146289_q.func_175063_a(this.recycler.getRecyclingBookPageNum() + 1 + "/" + this.recycler.getRecyclingBookPageMax(), 428.0f, 240.0f, 13938487);
        GlStateManager.func_179121_F();
        String title = TextFormatting.BOLD + TranslationHelper.getLocaleTranslation(TranslationHelper.LangKey.MESSAGE_RECYCLING_BOOK, new Object[0]);
        this.field_146289_q.func_175063_a(title, (float)(this.field_146999_f - this.field_146289_q.func_78256_a(title)) / 2.0f, -10.0f, 13938487);
        this.searchBox.func_146194_f();
    }
}

