/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.recycler.ModRecycler;
import ovh.corail.recycler.capability.RecyclerDefaultStackHandler;
import ovh.corail.recycler.core.Helper;
import ovh.corail.recycler.core.RecyclingManager;
import ovh.corail.recycler.core.TranslationHelper;
import ovh.corail.recycler.tileentity.TileEntityRecycler;

public class ServerRecyclerMessage
implements IMessage {
    private MessageAction action;
    private BlockPos pos;
    private boolean isWorking;
    private int pageNum;
    private String searchText;

    public ServerRecyclerMessage() {
    }

    public ServerRecyclerMessage(BlockPos pos) {
        this.pos = pos;
    }

    public ServerRecyclerMessage(MessageAction action, BlockPos pos, Object ... params) {
        this.action = action;
        this.pos = pos;
        if (action == MessageAction.SWITCH_AUTO) {
            this.isWorking = params.length == 1 && (Boolean)params[0] != false;
        } else if (action == MessageAction.CHANGE_PAGE) {
            this.pageNum = params.length == 1 ? (Integer)params[0] : 0;
        } else if (action == MessageAction.SEARCH_TEXT) {
            this.searchText = params.length == 1 ? String.valueOf(params[0]) : "";
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.action = MessageAction.values()[buf.readShort()];
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        if (this.action == MessageAction.SWITCH_AUTO) {
            this.isWorking = buf.readBoolean();
        } else if (this.action == MessageAction.CHANGE_PAGE) {
            this.pageNum = buf.readInt();
        } else if (this.action == MessageAction.SEARCH_TEXT) {
            this.searchText = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.action.ordinal());
        buf.writeLong(this.pos.func_177986_g());
        if (this.action == MessageAction.SWITCH_AUTO) {
            buf.writeBoolean(this.isWorking);
        } else if (this.action == MessageAction.CHANGE_PAGE) {
            buf.writeInt(this.pageNum);
        } else if (this.action == MessageAction.SEARCH_TEXT) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.searchText);
        }
    }

    public static class Handler
    implements IMessageHandler<ServerRecyclerMessage, IMessage> {
        public IMessage onMessage(ServerRecyclerMessage message, MessageContext ctx) {
            IThreadListener mainThread = (IThreadListener)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                TileEntity tile = player.field_70170_p.func_175625_s(message.pos);
                if (!(tile instanceof TileEntityRecycler)) {
                    return;
                }
                TileEntityRecycler recycler = (TileEntityRecycler)tile;
                switch (message.action) {
                    case RECYCLE: {
                        if (!recycler.recycle((EntityPlayer)player)) break;
                        Helper.grantAdvancement((EntityPlayer)player, "tutorial/first_recycle");
                        break;
                    }
                    case SWITCH_AUTO: {
                        recycler.updateWorking(message.isWorking);
                        break;
                    }
                    case TAKE_ALL: {
                        IItemHandler playerInvent = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                        if (playerInvent == null) {
                            return;
                        }
                        RecyclerDefaultStackHandler inventOutput = recycler.getInventoryOutput();
                        for (int slot = 0; slot < inventOutput.getSlots(); ++slot) {
                            if (inventOutput.getStackInSlot(slot).func_190926_b()) continue;
                            inventOutput.setStackInSlot(slot, ItemHandlerHelper.insertItemStacked((IItemHandler)playerInvent, (ItemStack)inventOutput.getStackInSlot(slot), (boolean)false));
                        }
                        break;
                    }
                    case DISCOVER_RECIPE: {
                        try {
                            RecyclingManager.getInstance().discoverRecipe((EntityPlayer)player, recycler.getInventoryWorking().getStackInSlot(0));
                            recycler.updateRecyclingRecipe();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case REMOVE_RECIPE: {
                        boolean success = RecyclingManager.getInstance().removeRecipe(recycler.getInventoryWorking().getStackInSlot(0));
                        TranslationHelper.sendMessage((ICommandSender)player, success ? TranslationHelper.LangKey.MESSAGE_REMOVE_RECIPE_SUCCESS : TranslationHelper.LangKey.MESSAGE_REMOVE_RECIPE_FAILED, new Object[0]);
                        recycler.updateRecyclingRecipe();
                        break;
                    }
                    case RECYCLING_BOOK: {
                        Helper.grantAdvancement((EntityPlayer)player, "tutorial/read_recycling_book");
                        recycler.initRecyclingBook();
                        player.openGui((Object)ModRecycler.instance, 1, recycler.func_145831_w(), recycler.func_174877_v().func_177958_n(), recycler.func_174877_v().func_177956_o(), recycler.func_174877_v().func_177952_p());
                        break;
                    }
                    case CHANGE_PAGE: {
                        recycler.updateRecyclingBook(message.pageNum);
                        break;
                    }
                    case SEARCH_TEXT: {
                        recycler.updateRecyclingBook(message.searchText);
                        break;
                    }
                }
            });
            return null;
        }
    }

    public static enum MessageAction {
        RECYCLE,
        SWITCH_AUTO,
        TAKE_ALL,
        DISCOVER_RECIPE,
        REMOVE_RECIPE,
        RECYCLING_BOOK,
        CHANGE_PAGE,
        SEARCH_TEXT;

    }
}

