/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.common.util.NNList;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class NullHelper {
    private NullHelper() {
    }

    @Nonnull
    public static final <P> P notnull(@Nullable P o, @Nonnull String message) {
        return NullHelper.notnull(o, new Object[]{message});
    }

    @Nonnull
    public static final <P> P notnullJ(@Nullable P o, @Nonnull String message) {
        return NullHelper.notnullJ(o, new Object[]{message});
    }

    @Nonnull
    public static final <P> P notnullM(@Nullable P o, @Nonnull String message) {
        return NullHelper.notnullM(o, new Object[]{message});
    }

    @Nonnull
    public static final <P> P notnullF(@Nullable P o, @Nonnull String message) {
        return NullHelper.notnullF(o, new Object[]{message});
    }

    @Nonnull
    public static final <P> P untrusted(@Nonnull P o, @Nonnull String message) {
        return NullHelper.untrusted(o, new Object[]{message});
    }

    @Nonnull
    public static final <P> P notnull(@Nullable P o, Object ... message) {
        if (o == null) {
            throw new NullPointerException("Houston we have a problem: '" + NullHelper.join(message) + "'. Please report that on our bugtracker unless you are using some old version. Thank you.");
        }
        return o;
    }

    @Nonnull
    public static final <P> P notnullJ(@Nullable P o, Object ... message) {
        if (o == null) {
            throw new NullPointerException("There was a problem with Java: The call '" + NullHelper.join(message) + "' returned null even though it should not be able to do that. Is your Java broken?");
        }
        return o;
    }

    @Nonnull
    public static final <P> P notnullM(@Nullable P o, Object ... message) {
        if (o == null) {
            throw new NullPointerException("There was a problem with Minecraft: The call '" + NullHelper.join(message) + "' returned null even though it should not be able to do that. Is your Minecraft broken? Did some other mod break it?");
        }
        return o;
    }

    @Nonnull
    public static final <P> P notnullF(@Nullable P o, Object ... message) {
        if (o == null) {
            throw new NullPointerException("There was a problem with Forge: The call '" + NullHelper.join(message) + "' returned null even though it should not be able to do that. Is your Forge broken? Did some other mod break it?");
        }
        return o;
    }

    @Nonnull
    public static final <P> P untrusted(@Nonnull P o, Object ... message) {
        if (o == null) {
            throw new NullPointerException("There was a problem with Minecraft: The call '" + NullHelper.join(message) + "' returned null even though it says it is not be able to do that. Your Minecraft is broken. This mod is NOT(!) the cause of this crash!");
        }
        return o;
    }

    @Nullable
    public static final <P> P untrust(@Nonnull P o) {
        return o;
    }

    @SafeVarargs
    @Nonnull
    public static final <P> P first(P ... o) {
        for (P on : NullHelper.notnull(o, new Object[]{"... param is null"})) {
            if (on == null) continue;
            return on;
        }
        throw new NullPointerException("Houston we have a problem. Please report that on our bugtracker unless you are using some old version. Thank you.");
    }

    @SafeVarargs
    @Nonnull
    public static final <P> P first(Supplier<P> ... o) {
        for (Supplier<P> on : NullHelper.notnull(o, new Object[]{"... param is null"})) {
            P p = NullHelper.notnull(on, new Object[]{"... param value is null"}).get();
            if (p == null) continue;
            return p;
        }
        throw new NullPointerException("Houston we have a problem. Please report that on our bugtracker unless you are using some old version. Thank you.");
    }

    @SafeVarargs
    @Nullable
    public static final <P> P firstOrNull(Supplier<P> ... o) {
        for (Supplier<P> on : NullHelper.notnull(o, new Object[]{"... param is null"})) {
            P p = NullHelper.notnull(on, new Object[]{"... param value is null"}).get();
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @Nullable
    public static final <P> P firstWithDefault(@Nonnull NNList<Supplier<P>> o, @Nullable P d) {
        Iterator iterator = o.iterator();
        while (iterator.hasNext()) {
            Supplier on = (Supplier)iterator.next();
            Object p = NullHelper.notnull(on, new Object[]{"NNList.get() is null"}).get();
            if (p == null) continue;
            return (P)p;
        }
        return d;
    }

    @SafeVarargs
    @Nonnull
    public static final <P> P first(@Nullable P value, Supplier<P> ... o) {
        if (value != null) {
            return value;
        }
        for (Supplier<P> on : NullHelper.notnull(o, new Object[]{"... param is null"})) {
            P p = NullHelper.notnull(on, new Object[]{"... param value is null"}).get();
            if (p == null) continue;
            return p;
        }
        throw new NullPointerException("Houston we have a problem. Please report that on our bugtracker unless you are using some old version. Thank you.");
    }

    @Nullable
    public static final <P> P firstWithDefault(@Nullable P value, @Nonnull Supplier<P> on, @Nullable P d) {
        if (value != null) {
            return value;
        }
        P p = NullHelper.notnull(on, new Object[]{"... param value is null"}).get();
        if (p != null) {
            return p;
        }
        return d;
    }

    @SafeVarargs
    @Nullable
    public static final <P> P firstWithDefault(@Nullable P d, Supplier<P> ... o) {
        for (Supplier<P> on : NullHelper.notnull(o, new Object[]{"... param is null"})) {
            P p = NullHelper.notnull(on, new Object[]{"... param value is null"}).get();
            if (p == null) continue;
            return p;
        }
        return d;
    }

    private static String join(Object ... data) {
        StringBuilder b = new StringBuilder();
        for (Object object : data) {
            b.append(object);
        }
        return b.toString();
    }
}

