/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.creativeonly;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.rftools.items.creativeonly.DelightingInfoHelper;
import mcjty.rftools.items.creativeonly.GuiDevelopersDelight;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketDelightingInfoReady
implements IMessage {
    private List<String> blockClasses;
    private List<String> teClasses;
    private Map<String, DelightingInfoHelper.NBTDescription> nbtData;
    private int metadata;

    public void fromBytes(ByteBuf buf) {
        int i;
        int size = buf.readInt();
        this.blockClasses = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.blockClasses.add(NetworkTools.readString((ByteBuf)buf));
        }
        size = buf.readInt();
        this.teClasses = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.teClasses.add(NetworkTools.readString((ByteBuf)buf));
        }
        size = buf.readInt();
        this.nbtData = new HashMap<String, DelightingInfoHelper.NBTDescription>(size);
        for (i = 0; i < size; ++i) {
            String key = NetworkTools.readString((ByteBuf)buf);
            String type = NetworkTools.readString((ByteBuf)buf);
            String value = NetworkTools.readString((ByteBuf)buf);
            this.nbtData.put(key, new DelightingInfoHelper.NBTDescription(type, value));
        }
        this.metadata = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.blockClasses.size());
        for (String string : this.blockClasses) {
            NetworkTools.writeString((ByteBuf)buf, (String)string);
        }
        buf.writeInt(this.teClasses.size());
        for (String string : this.teClasses) {
            NetworkTools.writeString((ByteBuf)buf, (String)string);
        }
        buf.writeInt(this.nbtData.size());
        for (Map.Entry entry : this.nbtData.entrySet()) {
            String key = (String)entry.getKey();
            DelightingInfoHelper.NBTDescription value = (DelightingInfoHelper.NBTDescription)entry.getValue();
            NetworkTools.writeString((ByteBuf)buf, (String)key);
            NetworkTools.writeString((ByteBuf)buf, (String)value.getType());
            NetworkTools.writeString((ByteBuf)buf, (String)value.getValue());
        }
        buf.writeInt(this.metadata);
    }

    public PacketDelightingInfoReady() {
    }

    public PacketDelightingInfoReady(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketDelightingInfoReady(List<String> blockClasses, List<String> teClasses, Map<String, DelightingInfoHelper.NBTDescription> nbtData, int metadata) {
        this.blockClasses = new ArrayList<String>(blockClasses);
        this.teClasses = new ArrayList<String>(teClasses);
        this.nbtData = new HashMap<String, DelightingInfoHelper.NBTDescription>(nbtData);
        this.metadata = metadata;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            GuiDevelopersDelight.setServerBlockClasses(this.blockClasses);
            GuiDevelopersDelight.setServerTEClasses(this.teClasses);
            GuiDevelopersDelight.setServerNBTData(this.nbtData);
            GuiDevelopersDelight.setMetadata(this.metadata);
        });
        ctx.setPacketHandled(true);
    }
}

