/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.lib.LibLog;

public final class BlockNameUtil {
    private static final Pattern pattern = Pattern.compile("([\\w\\-]+:[\\w\\.\\-/]+)\\[?((?:\\w+=\\w+)?(?:,\\w+=\\w+)*)\\]?\\+?(\\w+)?");

    private BlockNameUtil() {
    }

    @Nullable
    public static NameResult parseBlockName(@Nonnull String blockName) {
        try {
            Matcher matcher = pattern.matcher(blockName);
            return matcher.matches() ? new NameResult(matcher) : null;
        }
        catch (Exception ex) {
            LibLog.log().error(String.format("Unable to parse '%s'", blockName), ex);
            return null;
        }
    }

    public static final class NameResult {
        protected String blockName;
        protected Block block;
        protected Map<String, String> properties;
        protected String extras;

        NameResult() {
        }

        NameResult(Matcher matcher) throws NBTException {
            this.blockName = matcher.group(1);
            Block proposed = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(this.blockName));
            this.block = proposed == Blocks.field_150350_a ? null : proposed;
            String temp = matcher.group(2);
            if (!StringUtils.isEmpty((CharSequence)temp)) {
                this.properties = Arrays.stream(temp.split(",")).map(elem -> elem.split("=")).collect(Collectors.toMap(e -> e[0], e -> e[1]));
            }
            this.extras = matcher.group(3);
        }

        @Nonnull
        public String getBlockName() {
            return this.blockName;
        }

        @Nullable
        public Block getBlock() {
            return this.block;
        }

        public boolean hasProperties() {
            return this.properties != null;
        }

        @Nullable
        public Map<String, String> getProperties() {
            return this.properties;
        }

        public boolean hasExtras() {
            return this.extras != null;
        }

        @Nullable
        public String getExtras() {
            return this.extras;
        }

        @Nonnull
        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.getBlock() == null) {
                builder.append("*INVALID* ");
            }
            builder.append(this.getBlockName());
            if (this.hasProperties()) {
                builder.append('[');
                String props = this.properties.entrySet().stream().map(e -> (String)e.getKey() + '=' + (String)e.getValue()).collect(Collectors.joining(","));
                builder.append(props);
                builder.append(']');
            }
            return builder.toString();
        }
    }
}

