/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.render.entity;

import java.util.HashSet;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.entity.EntityBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderBlock
extends Render<EntityBlock> {
    public HashSet<Class<? extends TileEntity>> classesNotToRender = new HashSet();

    public RenderBlock(RenderManager renderManager) {
        super(renderManager);
    }

    protected ResourceLocation getEntityTexture(EntityBlock entity) {
        return TextureMap.field_110575_b;
    }

    public void doRender(EntityBlock entBlock, double x, double y, double z, float entityYaw, float partialTicks) {
        if (!entBlock.setup) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (entBlock.getCanRotate()) {
            GlStateManager.func_179137_b((double)0.0, (double)((double)entBlock.field_70131_O / 2.0), (double)0.0);
            GlStateManager.func_179114_b((float)EntityHelper.interpolateRotation(entBlock.prevRotYaw, entBlock.rotYaw, partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)EntityHelper.interpolateRotation(entBlock.prevRotPitch, entBlock.rotPitch, partialTicks), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)0.0, (double)(-((double)entBlock.field_70131_O / 2.0)), (double)0.0);
        }
        GlStateManager.func_179137_b((double)(0.5 * (double)(entBlock.blocks.length - 1)), (double)(1.0 * (double)(entBlock.blocks[0].length - 1)), (double)(0.5 * (double)(entBlock.blocks[0][0].length - 1)));
        GlStateManager.func_179140_f();
        BlockPos blockpos = new BlockPos((Entity)entBlock);
        BlockPos blockposMaxY = new BlockPos(entBlock.field_70165_t, entBlock.func_174813_aQ().field_72337_e, entBlock.field_70161_v);
        World world = entBlock.field_70170_p;
        for (int ii = 0; ii < entBlock.blocks.length; ++ii) {
            for (int jj = 0; jj < entBlock.blocks[ii].length; ++jj) {
                for (int kk = 0; kk < entBlock.blocks[ii][jj].length; ++kk) {
                    if (entBlock.blocks[ii][jj][kk] == null) continue;
                    IBlockState iblockstate = entBlock.blocks[ii][jj][kk];
                    Block block = iblockstate.func_177230_c();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(-ii), (float)(-jj), (float)(-kk));
                    if (iblockstate.func_185901_i() == EnumBlockRenderType.MODEL && iblockstate != world.func_180495_p(blockpos) && iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
                        this.func_110776_a(TextureMap.field_110575_b);
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179140_f();
                        Tessellator tessellator = Tessellator.func_178181_a();
                        BufferBuilder bufferbuilder = tessellator.func_178180_c();
                        if (this.field_188301_f) {
                            GlStateManager.func_179142_g();
                            GlStateManager.func_187431_e((int)this.func_188298_c(entBlock));
                        }
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                        GlStateManager.func_179109_b((float)((float)(-((double)blockposMaxY.func_177958_n()) - 0.5)), (float)((float)(-((double)blockposMaxY.func_177956_o()))), (float)((float)(-((double)blockposMaxY.func_177952_p()) - 0.5)));
                        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                        blockrendererdispatcher.func_175019_b().func_187493_a((IBlockAccess)world, blockrendererdispatcher.func_184389_a(iblockstate), iblockstate, blockposMaxY, bufferbuilder, false, MathHelper.func_180186_a((Vec3i)entBlock.getOrigin().func_177982_a(ii, jj, kk)));
                        tessellator.func_78381_a();
                        if (this.field_188301_f) {
                            GlStateManager.func_187417_n();
                            GlStateManager.func_179119_h();
                        }
                        GlStateManager.func_179145_e();
                        GlStateManager.func_179121_F();
                    }
                    if (entBlock.tileEntityNBTs[ii][jj][kk] != null && block.hasTileEntity(iblockstate)) {
                        TileEntity te;
                        if (entBlock.renderingTileEntities == null) {
                            entBlock.renderingTileEntities = new TileEntity[entBlock.blocks.length][entBlock.blocks[ii].length][entBlock.blocks[ii][jj].length];
                        }
                        if (entBlock.renderingTileEntities[ii][jj][kk] == null && (te = block.createTileEntity(entBlock.field_70170_p, iblockstate)) != null) {
                            te.func_145834_a(entBlock.field_70170_p);
                            te.func_145839_a(entBlock.tileEntityNBTs[ii][jj][kk].func_74737_b());
                            entBlock.renderingTileEntities[ii][jj][kk] = te;
                        }
                        if (!this.classesNotToRender.contains(entBlock.renderingTileEntities[ii][jj][kk].getClass())) {
                            try {
                                TileEntityRendererDispatcher.field_147556_a.func_147549_a(entBlock.renderingTileEntities[ii][jj][kk], -0.5, 0.0, -0.5, partialTicks);
                            }
                            catch (ReportedException e) {
                                this.classesNotToRender.add(entBlock.renderingTileEntities[ii][jj][kk].getClass());
                            }
                        }
                    }
                    GlStateManager.func_179121_F();
                }
            }
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public static class RenderFactory
    implements IRenderFactory<EntityBlock> {
        public Render<EntityBlock> createRenderFor(RenderManager manager) {
            return new RenderBlock(manager);
        }
    }
}

