/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei.barrel.fluidtransform;

import com.google.common.collect.ImmutableList;
import exnihilocreatio.ModBlocks;
import exnihilocreatio.compatibility.jei.barrel.fluidtransform.FluidTransformRecipe;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FluidTransformRecipeCategory
implements IRecipeCategory<FluidTransformRecipe> {
    public static final String UID = "exnihilocreatio:fluid_transform";
    private static final ResourceLocation texture = new ResourceLocation("exnihilocreatio", "textures/gui/jei_fluid_transform.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;
    private boolean hasHighlight;
    private int highlightX;
    private int highlightY;

    public FluidTransformRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(texture, 0, 0, 166, 63);
        this.slotHighlight = helper.createDrawable(texture, 166, 0, 18, 18);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return "Fluid Transform";
    }

    @Nonnull
    public String getModName() {
        return "exnihilocreatio";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.hasHighlight) {
            this.slotHighlight.draw(minecraft, this.highlightX, this.highlightY);
        }
    }

    private void setRecipe(IRecipeLayout recipeLayout, FluidTransformRecipe recipeWrapper) {
        recipeLayout.getItemStacks().init(0, true, 74, 9);
        recipeLayout.getItemStacks().init(1, true, 47, 9);
        recipeLayout.getItemStacks().init(2, true, 74, 36);
        recipeLayout.getItemStacks().init(3, false, 101, 9);
        boolean noCycle = false;
        ImmutableList focusStack = null;
        IFocus focus = recipeLayout.getFocus();
        if (focus != null && focus.getMode() == IFocus.Mode.INPUT && focus.getValue() instanceof ItemStack) {
            ItemStack stack = (ItemStack)focus.getValue();
            for (ItemStack inputStack : recipeWrapper.getInputs().subList(1, recipeWrapper.getInputs().size())) {
                if (!stack.func_77969_a(inputStack)) continue;
                noCycle = true;
                focusStack = ImmutableList.of((Object)inputStack);
            }
        }
        recipeLayout.getItemStacks().set(0, new ItemStack((Block)ModBlocks.barrelStone, 1, 0));
        recipeLayout.getItemStacks().set(1, recipeWrapper.getInputs().get(0));
        recipeLayout.getItemStacks().set(2, noCycle ? focusStack : ImmutableList.copyOf(recipeWrapper.getInputs().subList(1, recipeWrapper.getInputs().size())));
        recipeLayout.getItemStacks().set(3, recipeWrapper.getOutputs().get(0));
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull FluidTransformRecipe recipeWrapper, @Nonnull IIngredients ingredients) {
        this.setRecipe(recipeLayout, recipeWrapper);
    }

    public IDrawable getIcon() {
        return null;
    }
}

