/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.api.registries.IFluidTransformRegistry;
import exnihilocreatio.compatibility.jei.barrel.fluidtransform.FluidTransformRecipe;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomItemInfoJson;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.FluidTransformer;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemInfo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class FluidTransformRegistry
extends BaseRegistryMap<String, List<FluidTransformer>>
implements IFluidTransformRegistry {
    public FluidTransformRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)CustomItemInfoJson.INSTANCE).registerTypeAdapter(BlockInfo.class, (Object)CustomBlockInfoJson.INSTANCE).create(), new TypeToken<Map<String, List<FluidTransformer>>>(){}.getType(), ExNihiloRegistryManager.FLUID_TRANSFORM_DEFAULT_REGISTRY_PROVIDERS);
    }

    @Override
    public void register(@NotNull String inputFluid, @NotNull String outputFluid, int duration, @NotNull BlockInfo[] transformingBlocks, @NotNull BlockInfo[] blocksToSpawn) {
        this.register(new FluidTransformer(inputFluid, outputFluid, duration, transformingBlocks, blocksToSpawn));
    }

    @Override
    public void register(@NotNull FluidTransformer transformer) {
        ArrayList<FluidTransformer> list = (ArrayList<FluidTransformer>)((Map)this.registry).get(transformer.getInputFluid());
        if (list == null) {
            list = new ArrayList<FluidTransformer>();
        }
        list.add(transformer);
        ((Map)this.registry).put(transformer.getInputFluid(), list);
    }

    @Override
    public boolean containsKey(@NotNull String inputFluid) {
        return ((Map)this.registry).containsKey(inputFluid);
    }

    @Override
    public FluidTransformer getFluidTransformer(@NotNull String inputFluid, @NotNull String outputFluid) {
        if (((Map)this.registry).containsKey(inputFluid)) {
            for (FluidTransformer transformer : (List)((Map)this.registry).get(inputFluid)) {
                if (!transformer.getInputFluid().equals(inputFluid) || !transformer.getOutputFluid().equals(outputFluid)) continue;
                return transformer;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<FluidTransformer> getFluidTransformers(@NotNull String inputFluid) {
        return (List)((Map)this.registry).get(inputFluid);
    }

    @Override
    protected void registerEntriesFromJSON(FileReader fr) {
        List gsonInput = (List)this.gson.fromJson((Reader)fr, new TypeToken<List<FluidTransformer>>(){}.getType());
        for (FluidTransformer transformer : gsonInput) {
            this.register(transformer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveJson(File file) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            this.gson.toJson(this.getFluidTransformers(), (Appendable)fw);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fw);
        }
        IOUtils.closeQuietly((Writer)fw);
    }

    public List<FluidTransformer> getFluidTransformers() {
        ArrayList<FluidTransformer> fluidTransformers = new ArrayList<FluidTransformer>();
        for (List transformers : ((Map)this.registry).values()) {
            fluidTransformers.addAll(transformers);
        }
        return fluidTransformers;
    }

    @Override
    public List<FluidTransformRecipe> getRecipeList() {
        LinkedList fluidTransformRecipes = Lists.newLinkedList();
        this.getFluidTransformers().forEach(transformer -> {
            FluidTransformRecipe recipe;
            if (FluidRegistry.isFluidRegistered((String)transformer.getInputFluid()) && FluidRegistry.isFluidRegistered((String)transformer.getOutputFluid()) && (recipe = new FluidTransformRecipe((FluidTransformer)transformer)).isValid()) {
                fluidTransformRecipes.add(new FluidTransformRecipe((FluidTransformer)transformer));
            }
        });
        return fluidTransformRecipes;
    }
}

