/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.tiles;

import exnihilocreatio.blocks.BlockInfestingLeaves;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.networking.PacketHandler;
import exnihilocreatio.tiles.BaseTileEntity;
import exnihilocreatio.tiles.ITileLeafBlock;
import exnihilocreatio.util.BlockInfo;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileInfestingLeaves
extends BaseTileEntity
implements ITickable,
ITileLeafBlock {
    private int progress = 0;
    private IBlockState leafBlock = Blocks.field_150362_t.func_176223_P();
    private int doProgress;
    private int spreadCounter;

    public TileInfestingLeaves() {
        this.doProgress = (int)((double)ModConfig.infested_leaves.ticksToTransform / 100.0);
        this.spreadCounter = 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.doProgress <= 0) {
                ++this.progress;
                ++this.spreadCounter;
                if (this.progress >= 100) {
                    BlockInfestingLeaves.setInfested(this.field_145850_b, this.field_174879_c, this.leafBlock);
                    this.markDirtyClient();
                }
                if (this.spreadCounter >= ModConfig.infested_leaves.leavesUpdateFrequency) {
                    BlockInfestingLeaves.spread(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.field_73012_v);
                    this.spreadCounter = 0;
                }
                this.doProgress = (int)((double)ModConfig.infested_leaves.ticksToTransform / 100.0);
                PacketHandler.sendNBTUpdate(this);
            } else {
                --this.doProgress;
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void setProgress(int newProgress) {
        this.progress = newProgress;
        PacketHandler.sendNBTUpdate(this);
    }

    @Override
    public void setLeafBlock(IBlockState block) {
        this.leafBlock = block;
        PacketHandler.sendNBTUpdate(this);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("progress", this.progress);
        tag.func_74778_a("leafBlock", this.leafBlock.func_177230_c().getRegistryName() == null ? "" : this.leafBlock.func_177230_c().getRegistryName().toString());
        tag.func_74768_a("leafBlockMeta", this.leafBlock.func_177230_c().func_176201_c(this.leafBlock));
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        BlockInfo leaves;
        super.func_145839_a(tag);
        this.progress = tag.func_74762_e("progress");
        this.leafBlock = tag.func_74764_b("leafBlock") && tag.func_74764_b("leafBlockMeta") ? ((leaves = new BlockInfo(Block.func_149684_b((String)tag.func_74779_i("leafBlock")), tag.func_74762_e("leafBlockMeta"))).isValid() ? leaves.getBlockState() : Blocks.field_150362_t.func_176223_P()) : Blocks.field_150362_t.func_176223_P();
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public IBlockState getLeafBlock() {
        return this.leafBlock;
    }
}

