/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.misc.IConfig;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.impl.client.PregenInfo;
import pregenerator.impl.client.TrackerInfo;
import pregenerator.impl.client.gui.GuiChunkInfo;
import pregenerator.impl.client.gui.GuiOptifine;
import pregenerator.impl.client.gui.GuiPregenMenu;
import pregenerator.impl.client.gui.GuiWorldView;
import pregenerator.impl.client.infos.InfoEntry;
import pregenerator.impl.client.preview.GuiSeedPreview;
import pregenerator.impl.client.trackerInfo.TrackerEntry;

@SideOnly(value=Side.CLIENT)
public class ClientHandler {
    public static KeyBinding uiKey;
    public static ClientHandler INSTANCE;
    public PregenInfo info;
    public TrackerInfo tracker;
    IConfig clientConfig;
    IRenderHelper helper;
    boolean state = false;
    boolean did = false;

    public void init() {
        ChunkPregenerator.pregenBase.registerTickEvent(this);
        this.clientConfig = ChunkPregenerator.pregenBase.getConfig(new File(ChunkPregenerator.pregeneratorFolder, "ClientConfig.cfg"));
        uiKey = new KeyBinding("Options Gui", 23, "Chunk-Pregenerator");
        ClientRegistry.registerKeyBinding((KeyBinding)uiKey);
        this.info = new PregenInfo(this.clientConfig);
        this.tracker = new TrackerInfo(this.clientConfig);
        try {
            for (InfoEntry infoEntry : InfoEntry.getRegistry()) {
                infoEntry.readFromConfig(this.clientConfig);
            }
            this.info.loadConfig();
            for (TrackerEntry trackerEntry : TrackerEntry.getRegistry()) {
                trackerEntry.readFromConfig(this.clientConfig);
            }
            this.tracker.loadConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.clientConfig.saveConfig();
        }
        this.info.updateList();
        this.tracker.updateList();
        this.helper = ChunkPregenerator.pregenBase.createRenderHelper();
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMainMenu && !this.did && this.isOptifineNotReleased()) {
            this.did = true;
            event.setCanceled(true);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiOptifine());
        }
    }

    @SubscribeEvent
    public void onGuiOpened(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiCreateWorld) {
            int width = event.getGui().field_146294_l / 2;
            event.getButtonList().add(new GuiButton(-100, width - 155, 187, 72, 20, "Preview"));
        }
    }

    private boolean isOptifineNotReleased() {
        if (!FMLClientHandler.instance().hasOptifine()) {
            return false;
        }
        String version = (String)FMLClientHandler.instance().getAdditionalBrandingInformation().get(0);
        return version.contains("pre") && (version.contains("F3") || version.contains("F4")) || version.contains("E3");
    }

    @SubscribeEvent
    public void onButtonPressed(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.getGui() instanceof GuiCreateWorld && event.getButton().field_146127_k == -100) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSeedPreview((GuiCreateWorld)event.getGui()));
        }
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (uiKey.func_151470_d() && mc.field_71462_r == null) {
            mc.func_147108_a((GuiScreen)new GuiPregenMenu());
        }
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post evt) {
        if (evt.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        this.info.render(this.helper, evt.getResolution());
        this.tracker.render(this.helper, evt.getResolution());
    }

    @SubscribeEvent
    public void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            if (this.state) {
                this.state = false;
                GuiChunkInfo.INSTANCE.onCleared();
                GuiWorldView.ENTITIES.onCleared();
                GuiWorldView.TILE_ENTITIES.onCleared();
            }
            return;
        }
        this.state = true;
        this.info.update();
        this.tracker.update();
    }

    static {
        INSTANCE = new ClientHandler();
    }
}

