/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.misc.IConfig;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.impl.client.ScreenPosition;
import pregenerator.impl.client.trackerInfo.TrackerEntry;
import pregenerator.impl.network.packets.TrackerRequestPacket;

public class TrackerInfo {
    List<TrackerEntry> toRender = new ArrayList<TrackerEntry>();
    public boolean running = false;
    public boolean shouldShow = false;
    public boolean big = false;
    public int updateFrequency = 20;
    public ScreenPosition xPos = ScreenPosition.NEGATIVE;
    public ScreenPosition yPos = ScreenPosition.POSITIVE;
    int ticker = 0;
    IConfig config;
    public boolean showDetailed = false;
    public int targetDim = 0;

    public TrackerInfo(IConfig config) {
        this.config = config;
    }

    public void loadConfig() {
        this.xPos = ScreenPosition.byXName(this.config.getString("tracking", "XPos", ScreenPosition.NEGATIVE.getXName()));
        this.yPos = ScreenPosition.byYName(this.config.getString("tracking", "YPos", ScreenPosition.POSITIVE.getYName()));
        this.updateFrequency = this.config.getInt("tracking", "Update Frequency", 20);
        this.shouldShow = this.config.getBoolean("tracking", "Show UI", false);
        this.showDetailed = this.config.getBoolean("tracking", "Show Detailed", false);
        this.targetDim = this.config.getInt("tracking", "Detailed Dimension", this.targetDim);
        this.big = this.config.getBoolean("tracking", "BigUI", false);
        this.showDetailed = this.config.getBoolean("tracking", "ShowDetailed", false);
    }

    public void setDetailed(boolean detailed) {
        this.showDetailed = detailed;
        this.config.setBoolean("tracking", "ShowDetailed", detailed);
    }

    public void setBig(boolean big) {
        this.big = big;
        this.config.setBoolean("tracking", "BigUI", big);
    }

    public void setShow(boolean show) {
        this.shouldShow = show;
        this.config.setBoolean("tracking", "Show UI", show);
    }

    public void setUpdateFrequency(int freq) {
        this.updateFrequency = freq;
        this.config.setInt("tracking", "Update Frequency", freq);
    }

    public void setXPos(ScreenPosition newPos) {
        this.xPos = newPos;
        this.config.setString("tracking", "XPos", this.xPos.getXName());
    }

    public void setYPos(ScreenPosition newPos) {
        this.yPos = newPos;
        this.config.setString("tracking", "YPos", this.yPos.getYName());
    }

    public void saveEntry(TrackerEntry entry) {
        this.config.setBoolean("tracking", entry.getName(), entry.isActive());
    }

    public void updateList() {
        this.toRender.clear();
        for (TrackerEntry entry : TrackerEntry.getRegistry()) {
            if (!entry.isActive()) continue;
            this.toRender.add(entry);
        }
    }

    public void update() {
        if (!this.shouldShow) {
            return;
        }
        ++this.ticker;
        if (this.ticker % (21 - this.updateFrequency) == 0) {
            ChunkPregenerator.networking.sendPacketToServer(new TrackerRequestPacket(this.toRender));
        }
    }

    public void render(IRenderHelper helper, ScaledResolution res) {
        if (!this.shouldShow || !this.running) {
            return;
        }
        int width = 100;
        int screensize = -6;
        for (TrackerEntry entry : this.toRender) {
            if (!entry.shouldRender()) continue;
            screensize += entry.getYOffset();
        }
        int x = this.xPos.getXPosition(res, width, this.big);
        int y = this.yPos.getYPosition(res, screensize, this.xPos, this.big);
        int center = width / 2;
        GL11.glPushMatrix();
        if (this.big) {
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            GL11.glTranslatef((float)(-(x / 2 + width)), (float)(-(y / 2 + screensize)), (float)0.0f);
        }
        helper.renderArea(x - center - 12, y, width - 10, screensize);
        helper.renderCenterText(x - center, y - 12, width, "Server Stats");
        y -= 6;
        for (TrackerEntry entry : this.toRender) {
            if (!entry.shouldRender()) continue;
            float progress = this.clamp(0.0f, 1.0f, (float)entry.currentValue() / (float)entry.maxValue());
            entry.render(x, y, progress, width, helper);
            y += entry.getYOffset();
        }
        GL11.glPopMatrix();
    }

    private float clamp(float min, float max, float current) {
        return current < min ? min : (current > max ? max : current);
    }
}

