/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.redstone;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.redstone.ConnectivityTool;
import crazypants.enderio.base.conduit.redstone.signals.BundledSignal;
import crazypants.enderio.base.conduit.redstone.signals.CombinedSignal;
import crazypants.enderio.base.conduit.redstone.signals.Signal;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.capability.CapabilityFilterHolder;
import crazypants.enderio.base.filter.capability.IFilterHolder;
import crazypants.enderio.base.filter.redstone.DefaultInputSignalFilter;
import crazypants.enderio.base.filter.redstone.DefaultOutputSignalFilter;
import crazypants.enderio.base.filter.redstone.IInputSignalFilter;
import crazypants.enderio.base.filter.redstone.IOutputSignalFilter;
import crazypants.enderio.base.filter.redstone.IRedstoneSignalFilter;
import crazypants.enderio.base.filter.redstone.items.IItemInputSignalFilterUpgrade;
import crazypants.enderio.base.filter.redstone.items.IItemOutputSignalFilterUpgrade;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.conduit.AbstractConduit;
import crazypants.enderio.conduits.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduits.conduit.redstone.RedstoneConduitNetwork;
import crazypants.enderio.conduits.config.ConduitConfig;
import crazypants.enderio.conduits.gui.RedstoneSettings;
import crazypants.enderio.conduits.init.ConduitObject;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.conduits.render.ConduitTexture;
import crazypants.enderio.powertools.lang.Lang;
import crazypants.enderio.util.EnumReader;
import crazypants.enderio.util.FuncUtil;
import crazypants.enderio.util.Prep;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InsulatedRedstoneConduit
extends AbstractConduit
implements IRedstoneConduit,
IFilterHolder<IRedstoneSignalFilter> {
    static final Map<String, IConduitTexture> ICONS = new HashMap<String, IConduitTexture>();
    private final EnumMap<EnumFacing, IRedstoneSignalFilter> outputFilters = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, IRedstoneSignalFilter> inputFilters = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, ItemStack> outputFilterUpgrades = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, ItemStack> inputFilterUpgrades = new EnumMap(EnumFacing.class);
    private Map<EnumFacing, ConnectionMode> forcedConnections = new EnumMap<EnumFacing, ConnectionMode>(EnumFacing.class);
    private Map<EnumFacing, DyeColor> inputSignalColors = new EnumMap<EnumFacing, DyeColor>(EnumFacing.class);
    private Map<EnumFacing, DyeColor> outputSignalColors = new EnumMap<EnumFacing, DyeColor>(EnumFacing.class);
    private Map<EnumFacing, Boolean> signalStrengths = new EnumMap<EnumFacing, Boolean>(EnumFacing.class);
    private RedstoneConduitNetwork network;
    private int activeUpdateCooldown = 0;
    private boolean activeDirty = false;
    private boolean connectionsDirty = false;
    private int signalIdBase = 0;

    @Override
    @Nullable
    public RedstoneConduitNetwork getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        this.network = (RedstoneConduitNetwork)network;
        return super.setNetwork(network);
    }

    public void clearNetwork() {
        this.network = null;
    }

    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return IRedstoneConduit.class;
    }

    @Override
    public void updateNetwork() {
        FuncUtil.doIf((Object)this.getBundle().getEntity().func_145831_w(), world -> this.updateNetwork((World)world));
    }

    @Override
    public void updateEntity(@Nonnull World world) {
        super.updateEntity(world);
        if (!world.field_72995_K) {
            if (this.activeUpdateCooldown > 0) {
                --this.activeUpdateCooldown;
                Prof.start((IBlockAccess)world, (String)"updateActiveState");
                this.updateActiveState();
                Prof.stop((IBlockAccess)world);
            }
            if (this.connectionsDirty) {
                Prof.start((IBlockAccess)world, (String)"updateDirtyConnections");
                if (this.hasExternalConnections()) {
                    this.network.updateInputsFromConduit(this, false);
                }
                this.connectionsDirty = false;
                Prof.stop((IBlockAccess)world);
            }
        }
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.active) {
            this.activeDirty = true;
            this.active = active;
            this.updateActiveState();
        }
    }

    private void updateActiveState() {
        if (((Boolean)ConduitConfig.showState.get()).booleanValue() && this.activeDirty && this.activeUpdateCooldown == 0) {
            this.setClientStateDirty();
            this.activeDirty = false;
            this.activeUpdateCooldown = 4;
        }
    }

    @Override
    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        World world = this.getBundle().getEntity().func_145831_w();
        DyeColor col = DyeColor.getColorFromDye((ItemStack)player.func_184586_b(hand));
        CollidableComponent component = res.component;
        if (col != null && component != null && component.isDirectional()) {
            if (!world.field_72995_K) {
                if (this.getConnectionMode(component.getDirection()).acceptsInput()) {
                    this.setOutputSignalColor(component.getDirection(), col);
                } else {
                    this.setInputSignalColor(component.getDirection(), col);
                }
            }
            return true;
        }
        if (ToolUtil.isToolEquipped((EntityPlayer)player, (EnumHand)hand)) {
            if (world.field_72995_K) {
                return true;
            }
            if (component != null) {
                EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
                if (component.isCore()) {
                    BlockPos pos = this.getBundle().getLocation().func_177972_a(faceHit);
                    Block id = world.func_180495_p(pos).func_177230_c();
                    if (id == ConduitRegistry.getConduitModObjectNN().getBlock()) {
                        IRedstoneConduit neighbour = (IRedstoneConduit)ConduitUtil.getConduit((World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p(), IRedstoneConduit.class);
                        if (neighbour != null && neighbour.getConnectionMode(faceHit.func_176734_d()) == ConnectionMode.DISABLED) {
                            neighbour.setConnectionMode(faceHit.func_176734_d(), ConnectionMode.NOT_SET);
                        }
                        this.setConnectionMode(faceHit, ConnectionMode.NOT_SET);
                        return ConduitUtil.connectConduits((IServerConduit)this, (EnumFacing)faceHit);
                    }
                    this.forceConnectionMode(faceHit, ConnectionMode.IN_OUT);
                    return true;
                }
                EnumFacing connDir = component.getDirection();
                if (this.externalConnections.contains(connDir)) {
                    if (this.network != null) {
                        this.network.destroyNetwork();
                    }
                    this.externalConnectionRemoved(connDir);
                    this.forceConnectionMode(connDir, ConnectionMode.getNext((ConnectionMode)this.getConnectionMode(connDir)));
                    return true;
                }
                if (this.containsConduitConnection(connDir)) {
                    BlockPos pos = this.getBundle().getLocation().func_177972_a(connDir);
                    IRedstoneConduit neighbour = (IRedstoneConduit)ConduitUtil.getConduit((World)this.getBundle().getEntity().func_145831_w(), (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p(), IRedstoneConduit.class);
                    if (neighbour != null) {
                        RedstoneConduitNetwork neighbourNetwork;
                        if (this.network != null) {
                            this.network.destroyNetwork();
                        }
                        if ((neighbourNetwork = neighbour.getNetwork()) != null) {
                            neighbourNetwork.destroyNetwork();
                        }
                        neighbour.conduitConnectionRemoved(connDir.func_176734_d());
                        this.conduitConnectionRemoved(connDir);
                        neighbour.connectionsChanged();
                        this.connectionsChanged();
                        this.updateNetwork();
                        neighbour.updateNetwork();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void forceConnectionMode(@Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        this.setConnectionMode(dir, mode);
        this.forcedConnections.put(dir, mode);
        this.onAddedToBundle();
        if (this.network != null) {
            this.network.updateInputsFromConduit(this, false);
        }
    }

    @Nonnull
    public ItemStack createItem() {
        return new ItemStack(ConduitObject.item_redstone_conduit.getItemNN(), 1, 0);
    }

    @Override
    public void onInputsChanged(@Nonnull EnumFacing side, int[] inputValues) {
    }

    @Override
    public void onInputChanged(@Nonnull EnumFacing side, int inputValue) {
    }

    @Override
    @Nonnull
    public DyeColor getInputSignalColor(@Nonnull EnumFacing dir) {
        return (DyeColor)NullHelper.first((Object[])new DyeColor[]{this.inputSignalColors.get(dir), DyeColor.RED});
    }

    @Override
    public void setInputSignalColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.inputSignalColors.put(dir, col);
        FuncUtil.doIf((Object)this.getNetwork(), net -> net.updateInputsFromConduit(this, false));
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    @Override
    @Nonnull
    public DyeColor getOutputSignalColor(@Nonnull EnumFacing dir) {
        return (DyeColor)NullHelper.first((Object[])new DyeColor[]{this.outputSignalColors.get(dir), DyeColor.GREEN});
    }

    @Override
    public void setOutputSignalColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.outputSignalColors.put(dir, col);
        FuncUtil.doIf((Object)this.getNetwork(), net -> net.updateInputsFromConduit(this, false));
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    @Override
    public boolean isOutputStrong(@Nonnull EnumFacing dir) {
        return (Boolean)NullHelper.first((Object[])new Boolean[]{this.signalStrengths.get(dir), Boolean.FALSE});
    }

    @Override
    public void setOutputStrength(@Nonnull EnumFacing dir, boolean isStrong) {
        if (this.isOutputStrong(dir) != isStrong) {
            if (isStrong) {
                this.signalStrengths.put(dir, isStrong);
            } else {
                this.signalStrengths.remove(dir);
            }
            FuncUtil.doIf((Object)this.getNetwork(), net -> net.notifyNeigborsOfSignalUpdate());
        }
    }

    @Override
    public boolean canConnectToExternal(@Nonnull EnumFacing direction, boolean ignoreConnectionState) {
        BlockPos pos;
        if (ignoreConnectionState) {
            return true;
        }
        ConnectionMode forcedConnection = this.forcedConnections.get(direction);
        if (forcedConnection == ConnectionMode.DISABLED) {
            return false;
        }
        if (forcedConnection == ConnectionMode.IN_OUT || forcedConnection == ConnectionMode.OUTPUT || forcedConnection == ConnectionMode.INPUT) {
            return true;
        }
        World world = this.getBundle().getBundleworld();
        IBlockState bs = world.func_180495_p(pos = this.getBundle().getLocation().func_177972_a(direction));
        if (bs.func_177230_c() == ConduitRegistry.getConduitModObjectNN().getBlock()) {
            return false;
        }
        return ConnectivityTool.shouldAutoConnectRedstone((World)world, (IBlockState)bs, (BlockPos)pos, (EnumFacing)direction.func_176734_d());
    }

    @Override
    public int isProvidingWeakPower(@Nonnull EnumFacing toDirection) {
        if (!this.getConnectionMode(toDirection = toDirection.func_176734_d()).acceptsInput()) {
            return 0;
        }
        if (this.network == null || !this.network.isNetworkEnabled()) {
            return 0;
        }
        int result = 0;
        CombinedSignal signal = this.getNetworkOutput(toDirection);
        result = Math.max(result, signal.getStrength());
        return result;
    }

    @Override
    public int isProvidingStrongPower(@Nonnull EnumFacing toDirection) {
        if (this.isOutputStrong(toDirection.func_176734_d())) {
            return this.isProvidingWeakPower(toDirection);
        }
        return 0;
    }

    @Override
    @Nonnull
    public CombinedSignal getNetworkOutput(@Nonnull EnumFacing side) {
        ConnectionMode mode = this.getConnectionMode(side);
        if (this.network == null || !mode.acceptsInput()) {
            return CombinedSignal.NONE;
        }
        DyeColor col = this.getOutputSignalColor(side);
        BundledSignal bundledSignal = this.network.getBundledSignal();
        return bundledSignal.getFilteredSignal(col, (IOutputSignalFilter)this.getSignalFilter(side, true));
    }

    @Override
    @Nonnull
    public Signal getNetworkInput(@Nonnull EnumFacing side) {
        if (this.network != null) {
            this.network.setNetworkEnabled(false);
        }
        CombinedSignal result = CombinedSignal.NONE;
        if (this.acceptSignalsForDir(side)) {
            int input = this.getExternalPowerLevel(side);
            result = new CombinedSignal(input);
            IInputSignalFilter filter = (IInputSignalFilter)this.getSignalFilter(side, false);
            result = filter.apply(result, this.getBundle().getBundleworld(), this.getBundle().getLocation().func_177972_a(side));
        }
        if (this.network != null) {
            this.network.setNetworkEnabled(true);
        }
        return new Signal(result, this.signalIdBase + side.ordinal());
    }

    protected int getExternalPowerLevelProtected(@Nonnull EnumFacing side) {
        if (this.network != null) {
            this.network.setNetworkEnabled(false);
        }
        int input = this.getExternalPowerLevel(side);
        if (this.network != null) {
            this.network.setNetworkEnabled(true);
        }
        return input;
    }

    protected int getExternalPowerLevel(@Nonnull EnumFacing dir) {
        World world = this.getBundle().getBundleworld();
        BlockPos loc = this.getBundle().getLocation().func_177972_a(dir);
        int res = 0;
        if (world.func_175667_e(loc)) {
            int strong = world.func_175627_a(loc, dir);
            if (strong > 0) {
                return strong;
            }
            res = world.func_175651_c(loc, dir);
            IBlockState bs = world.func_180495_p(loc);
            Block block = bs.func_177230_c();
            if (res <= 15 && block == Blocks.field_150488_af) {
                int wireIn = (Integer)bs.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
                res = Math.max(res, wireIn);
            }
        }
        return res;
    }

    @Override
    @Nonnull
    public ConnectionMode getConnectionMode(@Nonnull EnumFacing dir) {
        ConnectionMode res = this.forcedConnections.get(dir);
        if (res == null) {
            return this.getDefaultConnectionMode();
        }
        return res;
    }

    @Override
    @Nonnull
    public ConnectionMode getDefaultConnectionMode() {
        return ConnectionMode.OUTPUT;
    }

    @Nonnull
    public NNList<ItemStack> getDrops() {
        NNList res = super.getDrops();
        for (ItemStack stack : this.inputFilterUpgrades.values()) {
            if (stack == null || !Prep.isValid((ItemStack)stack)) continue;
            res.add((Object)stack);
        }
        for (ItemStack stack : this.outputFilterUpgrades.values()) {
            if (stack == null || !Prep.isValid((ItemStack)stack)) continue;
            res.add((Object)stack);
        }
        return res;
    }

    @Override
    public boolean onNeighborBlockChange(@Nonnull Block blockId) {
        World world = this.getBundle().getBundleworld();
        if (world.field_72995_K) {
            return false;
        }
        boolean res = super.onNeighborBlockChange(blockId);
        if (this.network == null || !this.network.isNetworkEnabled()) {
            return false;
        }
        if (blockId != ConduitRegistry.getConduitModObjectNN().getBlock()) {
            this.connectionsDirty = true;
        }
        return res;
    }

    private boolean acceptSignalsForDir(@Nonnull EnumFacing dir) {
        if (!this.containsExternalConnection(dir) || !this.getConnectionMode(dir).acceptsOutput()) {
            return false;
        }
        BlockPos loc = this.getBundle().getLocation().func_177972_a(dir);
        return ConduitUtil.getConduit((World)this.getBundle().getEntity().func_145831_w(), (int)loc.func_177958_n(), (int)loc.func_177956_o(), (int)loc.func_177952_p(), IRedstoneConduit.class) == null;
    }

    @Nonnull
    public IConduitTexture getTextureForState(@Nonnull CollidableComponent component) {
        if (component.isCore()) {
            return (Boolean)ConduitConfig.showState.get() != false && this.isActive() ? ICONS.get("e") : ICONS.get("d");
        }
        return ICONS.get("a");
    }

    @Nonnull
    public IConduitTexture getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        return (Boolean)ConduitConfig.showState.get() != false && this.isActive() ? ICONS.get("b") : ICONS.get("c");
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    protected void readTypeSettings(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        this.forceConnectionMode(dir, (ConnectionMode)EnumReader.get(ConnectionMode.class, (int)dataRoot.func_74765_d("connectionMode")));
        this.setInputSignalColor(dir, (DyeColor)EnumReader.get(DyeColor.class, (int)dataRoot.func_74765_d("inputSignalColor")));
        this.setOutputSignalColor(dir, (DyeColor)EnumReader.get(DyeColor.class, (int)dataRoot.func_74765_d("outputSignalColor")));
        this.setOutputStrength(dir, dataRoot.func_74767_n("signalStrong"));
    }

    @Override
    protected void writeTypeSettingsToNbt(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("connectionMode", (short)this.forcedConnections.get(dir).ordinal());
        dataRoot.func_74777_a("inputSignalColor", (short)this.getInputSignalColor(dir).ordinal());
        dataRoot.func_74777_a("outputSignalColor", (short)this.getOutputSignalColor(dir).ordinal());
        dataRoot.func_74757_a("signalStrong", this.isOutputStrong(dir));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        ItemStack up;
        IRedstoneSignalFilter f;
        DyeColor col;
        byte[] modes;
        super.writeToNBT(nbtRoot);
        if (!this.forcedConnections.isEmpty()) {
            modes = new byte[6];
            boolean bl = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                void var3_4;
                ConnectionMode mode = this.forcedConnections.get(dir);
                modes[var3_4] = mode != null ? (int)mode.ordinal() : -1;
                ++var3_4;
            }
            nbtRoot.func_74773_a("forcedConnections", modes);
        }
        if (!this.inputSignalColors.isEmpty()) {
            modes = new byte[6];
            boolean bl = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                void var3_6;
                col = this.inputSignalColors.get(dir);
                modes[var3_6] = col != null ? (int)col.ordinal() : -1;
                ++var3_6;
            }
            nbtRoot.func_74773_a("signalColors", modes);
        }
        if (!this.outputSignalColors.isEmpty()) {
            modes = new byte[6];
            boolean bl = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                void var3_8;
                col = this.outputSignalColors.get(dir);
                modes[var3_8] = col != null ? (int)col.ordinal() : -1;
                ++var3_8;
            }
            nbtRoot.func_74773_a("outputSignalColors", modes);
        }
        if (!this.signalStrengths.isEmpty()) {
            modes = new byte[6];
            boolean bl = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                void var3_10;
                boolean isStrong = dir != null && this.isOutputStrong(dir);
                modes[var3_10] = isStrong ? (byte)1 : 0;
                ++var3_10;
            }
            nbtRoot.func_74773_a("signalStrengths", modes);
        }
        for (Map.Entry<EnumFacing, IRedstoneSignalFilter> entry : this.inputFilters.entrySet()) {
            if (entry.getValue() == null) continue;
            f = entry.getValue();
            NBTTagCompound itemRoot = new NBTTagCompound();
            FilterRegistry.writeFilterToNbt((IFilter)f, (NBTTagCompound)itemRoot);
            nbtRoot.func_74782_a("inSignalFilts." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, IRedstoneSignalFilter> entry : this.outputFilters.entrySet()) {
            if (entry.getValue() == null) continue;
            f = entry.getValue();
            NBTTagCompound itemRoot = new NBTTagCompound();
            FilterRegistry.writeFilterToNbt((IFilter)f, (NBTTagCompound)itemRoot);
            nbtRoot.func_74782_a("outSignalFilts." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, IRedstoneSignalFilter> entry : this.inputFilterUpgrades.entrySet()) {
            up = (ItemStack)entry.getValue();
            if (up == null || !Prep.isValid((ItemStack)up)) continue;
            IRedstoneSignalFilter filter = this.getSignalFilter(entry.getKey(), true);
            FilterRegistry.writeFilterToStack((IFilter)filter, (ItemStack)up);
            NBTTagCompound itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("inputSignalFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, IRedstoneSignalFilter> entry : this.outputFilterUpgrades.entrySet()) {
            up = (ItemStack)entry.getValue();
            if (up == null || !Prep.isValid((ItemStack)up)) continue;
            IRedstoneSignalFilter filter = this.getSignalFilter(entry.getKey(), false);
            FilterRegistry.writeFilterToStack((IFilter)filter, (ItemStack)up);
            NBTTagCompound itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("outputSignalFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.forcedConnections.clear();
        byte[] modes = nbtRoot.func_74770_j("forcedConnections");
        if (modes.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (modes[i] >= 0) {
                    this.forcedConnections.put(dir, ConnectionMode.values()[modes[i]]);
                }
                ++i;
            }
        }
        this.inputSignalColors.clear();
        byte[] cols = nbtRoot.func_74770_j("signalColors");
        if (cols.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (cols[i] >= 0) {
                    this.inputSignalColors.put(dir, DyeColor.values()[cols[i]]);
                }
                ++i;
            }
        }
        this.outputSignalColors.clear();
        byte[] outCols = nbtRoot.func_74770_j("outputSignalColors");
        if (outCols.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (outCols[i] >= 0) {
                    this.outputSignalColors.put(dir, DyeColor.values()[outCols[i]]);
                }
                ++i;
            }
        }
        this.signalStrengths.clear();
        byte[] strengths = nbtRoot.func_74770_j("signalStrengths");
        if (strengths.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (strengths[i] > 0) {
                    this.signalStrengths.put(dir, true);
                }
                ++i;
            }
        }
        this.inputFilters.clear();
        this.outputFilters.clear();
        this.inputFilterUpgrades.clear();
        this.outputFilterUpgrades.clear();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            ItemStack ups;
            NBTTagCompound upTag;
            IRedstoneSignalFilter filter;
            NBTTagCompound filterTag;
            String key = "inSignalFilts." + dir.name();
            if (nbtRoot.func_74764_b(key)) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                filter = (IRedstoneSignalFilter)FilterRegistry.loadFilterFromNbt((NBTTagCompound)filterTag);
                this.inputFilters.put(dir, filter);
            }
            if (nbtRoot.func_74764_b(key = "inputSignalFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.inputFilterUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "outputSignalFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.outputFilterUpgrades.put(dir, ups);
            }
            if (!nbtRoot.func_74764_b(key = "outSignalFilts." + dir.name())) continue;
            filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
            filter = (IRedstoneSignalFilter)FilterRegistry.loadFilterFromNbt((NBTTagCompound)filterTag);
            this.outputFilters.put(dir, filter);
        }
    }

    @Override
    public String toString() {
        return "RedstoneConduit [network=" + this.network + " connections=" + this.conduitConnections + " active=" + this.active + "]";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(hashCodes);
        hashCodes.addEnum(this.inputSignalColors);
        hashCodes.addEnum(this.outputSignalColors);
        if (((Boolean)ConduitConfig.showState.get()).booleanValue() && this.isActive()) {
            hashCodes.add(1);
        }
    }

    @Nonnull
    public RedstoneConduitNetwork createNetworkForType() {
        return new RedstoneConduitNetwork();
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ITabPanel createGuiPanel(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        return new RedstoneSettings(gui, con);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean updateGuiPanel(@Nonnull ITabPanel panel) {
        if (panel instanceof RedstoneSettings) {
            return ((RedstoneSettings)panel).updateConduit(this);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getGuiPanelTabOrder() {
        return 2;
    }

    public boolean hasInternalCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY) {
            return true;
        }
        return super.hasInternalCapability(capability, facing);
    }

    @Nullable
    public <T> T getInternalCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY) {
            return (T)CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getInternalCapability(capability, facing);
    }

    @Override
    public void setSignalIdBase(int id) {
        this.signalIdBase = id;
    }

    @Override
    @Nonnull
    public IRedstoneSignalFilter getSignalFilter(@Nonnull EnumFacing dir, boolean isOutput) {
        if (!isOutput) {
            return (IRedstoneSignalFilter)NullHelper.first((Object[])new IRedstoneSignalFilter[]{this.inputFilters.get(dir), DefaultInputSignalFilter.instance});
        }
        return (IRedstoneSignalFilter)NullHelper.first((Object[])new IRedstoneSignalFilter[]{this.outputFilters.get(dir), DefaultOutputSignalFilter.instance});
    }

    public void setSignalFilter(@Nonnull EnumFacing dir, boolean isInput, @Nonnull IRedstoneSignalFilter filter) {
        if (!isInput) {
            this.inputFilters.put(dir, filter);
        } else {
            this.outputFilters.put(dir, filter);
        }
        this.setClientStateDirty();
        this.connectionsDirty = true;
        FuncUtil.doIf((Object)this.getNetwork(), net -> net.updateInputsFromConduit(this, false));
    }

    @Nonnull
    public IRedstoneSignalFilter getFilter(int filterIndex, int param1) {
        return this.getSignalFilter(EnumFacing.func_82600_a((int)param1), filterIndex == this.getInputFilterIndex() ? true : filterIndex != this.getOutputFilterIndex());
    }

    public void setFilter(int filterIndex, int param1, @Nonnull IRedstoneSignalFilter filter) {
        this.setSignalFilter(EnumFacing.func_82600_a((int)param1), filterIndex == this.getInputFilterIndex() ? true : filterIndex != this.getOutputFilterIndex(), filter);
    }

    @Nonnull
    public ItemStack getFilterStack(int filterIndex, int param1) {
        if (filterIndex == this.getInputFilterIndex()) {
            return (ItemStack)NullHelper.first((Object[])new ItemStack[]{this.inputFilterUpgrades.get(EnumFacing.func_82600_a((int)param1)), Prep.getEmpty()});
        }
        if (filterIndex == this.getOutputFilterIndex()) {
            return (ItemStack)NullHelper.first((Object[])new ItemStack[]{this.outputFilterUpgrades.get(EnumFacing.func_82600_a((int)param1)), Prep.getEmpty()});
        }
        return Prep.getEmpty();
    }

    public void setFilterStack(int filterIndex, int param1, @Nonnull ItemStack stack) {
        if (filterIndex == this.getInputFilterIndex()) {
            if (Prep.isValid((ItemStack)stack)) {
                this.inputFilterUpgrades.put(EnumFacing.func_82600_a((int)param1), stack);
            } else {
                this.inputFilterUpgrades.remove(EnumFacing.func_82600_a((int)param1));
            }
        } else if (filterIndex == this.getOutputFilterIndex()) {
            if (Prep.isValid((ItemStack)stack)) {
                this.outputFilterUpgrades.put(EnumFacing.func_82600_a((int)param1), stack);
            } else {
                this.outputFilterUpgrades.remove(EnumFacing.func_82600_a((int)param1));
            }
        }
        IRedstoneSignalFilter filterForUpgrade = (IRedstoneSignalFilter)FilterRegistry.getFilterForUpgrade((ItemStack)stack);
        if (filterForUpgrade != null) {
            this.setFilter(filterIndex, param1, filterForUpgrade);
        }
    }

    public int getInputFilterIndex() {
        return 5;
    }

    public int getOutputFilterIndex() {
        return 6;
    }

    public boolean isFilterUpgradeAccepted(@Nonnull ItemStack stack, boolean isInput) {
        if (!isInput) {
            return stack.func_77973_b() instanceof IItemInputSignalFilterUpgrade;
        }
        return stack.func_77973_b() instanceof IItemOutputSignalFilterUpgrade;
    }

    @Override
    @Nonnull
    public NNList<ITextComponent> getConduitProbeInformation(@Nonnull EntityPlayer player) {
        NNList<ITextComponent> result = super.getConduitProbeInformation(player);
        if (this.getExternalConnections().isEmpty()) {
            TextComponentTranslation elem = Lang.GUI_CONDUIT_PROBE_REDSTONE_HEADING_NO_CONNECTIONS.toChatServer();
            elem.func_150256_b().func_150238_a(TextFormatting.GOLD);
            result.add((Object)elem);
        } else {
            for (EnumFacing dir : this.getExternalConnections()) {
                if (dir == null) continue;
                TextComponentTranslation elem = Lang.GUI_CONDUIT_PROBE_REDSTONE_HEADING.toChatServer(new Object[]{new TextComponentTranslation(EnderIO.lang.addPrefix("facing." + dir), new Object[0])});
                elem.func_150256_b().func_150238_a(TextFormatting.GREEN);
                result.add((Object)elem);
                ConnectionMode mode = this.getConnectionMode(dir);
                if (mode.acceptsInput()) {
                    elem = Lang.GUI_CONDUIT_PROBE_REDSTONE_STRONG.toChatServer(new Object[]{this.isProvidingStrongPower(dir)});
                    elem.func_150256_b().func_150238_a(TextFormatting.BLUE);
                    result.add((Object)elem);
                    elem = Lang.GUI_CONDUIT_PROBE_REDSTONE_WEAK.toChatServer(new Object[]{this.isProvidingWeakPower(dir)});
                    elem.func_150256_b().func_150238_a(TextFormatting.BLUE);
                    result.add((Object)elem);
                }
                if (!mode.acceptsOutput()) continue;
                elem = Lang.GUI_CONDUIT_PROBE_REDSTONE_EXTERNAL.toChatServer(new Object[]{this.getExternalPowerLevelProtected(dir)});
                elem.func_150256_b().func_150238_a(TextFormatting.BLUE);
                result.add((Object)elem);
            }
        }
        return result;
    }

    static {
        ICONS.put("d", new ConduitTexture(TextureRegistry.registerTexture((String)"blocks/conduit_core_1"), ConduitTexture.core(3)));
        ICONS.put("e", new ConduitTexture(TextureRegistry.registerTexture((String)"blocks/conduit_core_0"), ConduitTexture.core(3)));
        ICONS.put("a", new ConduitTexture(TextureRegistry.registerTexture((String)"blocks/conduit"), ConduitTexture.arm(1)));
        ICONS.put("c", new ConduitTexture(TextureRegistry.registerTexture((String)"blocks/conduit"), ConduitTexture.arm(3)));
        ICONS.put("b", new ConduitTexture(TextureRegistry.registerTexture((String)"blocks/conduit"), ConduitTexture.arm(2)));
    }
}

