/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.network;

import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.capability.CapabilityFilterHolder;
import crazypants.enderio.base.filter.capability.IFilterHolder;
import crazypants.enderio.conduits.network.AbstractConduitPacket;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketConduitFilter<T extends IConduit>
extends AbstractConduitPacket.Sided<T> {
    protected IFilter inputFilter;
    protected IFilter outputFilter;

    public PacketConduitFilter() {
    }

    public PacketConduitFilter(@Nonnull T con, @Nonnull EnumFacing dir) {
        super(con, dir);
        IFilterHolder filterHolder;
        if (con.hasInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, dir) && (filterHolder = (IFilterHolder)con.getInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, dir)) != null) {
            this.inputFilter = filterHolder.getFilter(filterHolder.getInputFilterIndex(), dir.ordinal());
            this.outputFilter = filterHolder.getFilter(filterHolder.getOutputFilterIndex(), dir.ordinal());
        }
    }

    @Override
    public void write(@Nonnull ByteBuf buf) {
        super.write(buf);
        FilterRegistry.writeFilter((ByteBuf)buf, (IFilter)this.inputFilter);
        FilterRegistry.writeFilter((ByteBuf)buf, (IFilter)this.outputFilter);
    }

    @Override
    public void read(@Nonnull ByteBuf buf) {
        super.read(buf);
        this.inputFilter = FilterRegistry.readFilter((ByteBuf)buf);
        this.outputFilter = FilterRegistry.readFilter((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<PacketConduitFilter, IMessage> {
        public IMessage onMessage(PacketConduitFilter message, MessageContext ctx) {
            Object conduit = message.getConduit(ctx);
            if (conduit != null) {
                IFilter outputFilter;
                IFilter inputFilter = message.inputFilter;
                if (inputFilter != null) {
                    this.applyFilter(message.dir, (IConduit)conduit, inputFilter, true);
                }
                if ((outputFilter = message.outputFilter) != null) {
                    this.applyFilter(message.dir, (IConduit)conduit, outputFilter, false);
                }
                IBlockState bs = message.getWorld(ctx).func_180495_p(message.getPos());
                message.getWorld(ctx).func_184138_a(message.getPos(), bs, bs, 3);
            }
            return null;
        }

        private void applyFilter(@Nonnull EnumFacing dir, @Nonnull IConduit conduit, @Nonnull IFilter filter, boolean isInput) {
            IFilterHolder filterHolder;
            if (conduit.hasInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, dir) && (filterHolder = (IFilterHolder)conduit.getInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, dir)) != null) {
                if (isInput) {
                    filterHolder.setFilter(filterHolder.getInputFilterIndex(), dir.ordinal(), filter);
                } else {
                    filterHolder.setFilter(filterHolder.getOutputFilterIndex(), dir.ordinal(), filter);
                }
            }
        }
    }
}

