/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.network;

import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.base.conduit.IExtractor;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.conduits.network.AbstractConduitPacket;
import crazypants.enderio.util.EnumReader;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketExtractMode
extends AbstractConduitPacket.Sided<IExtractor> {
    @Nonnull
    private RedstoneControlMode mode = RedstoneControlMode.OFF;
    @Nonnull
    private DyeColor color = DyeColor.BLACK;

    public PacketExtractMode() {
    }

    public PacketExtractMode(@Nonnull IExtractor con, @Nonnull EnumFacing dir) {
        super(con, dir);
        this.mode = con.getExtractionRedstoneMode(dir);
        this.color = con.getExtractionSignalColor(dir);
    }

    @Override
    public void write(@Nonnull ByteBuf buf) {
        super.write(buf);
        buf.writeShort(this.mode.ordinal());
        buf.writeShort(this.color.ordinal());
    }

    @Override
    public void read(@Nonnull ByteBuf buf) {
        super.read(buf);
        this.mode = (RedstoneControlMode)EnumReader.get(RedstoneControlMode.class, (int)buf.readShort());
        this.color = (DyeColor)EnumReader.get(DyeColor.class, (int)buf.readShort());
    }

    public static class Handler
    implements IMessageHandler<PacketExtractMode, IMessage> {
        public IMessage onMessage(PacketExtractMode message, MessageContext ctx) {
            IExtractor conduit = (IExtractor)message.getConduit(ctx);
            if (conduit != null) {
                conduit.setExtractionRedstoneMode(message.mode, message.dir);
                conduit.setExtractionSignalColor(message.dir, message.color);
                IBlockState bs = message.getWorld(ctx).func_180495_p(message.getPos());
                message.getWorld(ctx).func_184138_a(message.getPos(), bs, bs, 3);
            }
            return null;
        }
    }
}

