/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.absorbers;

import java.util.Random;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsdim.config.DimletConstructionConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.types.TerrainType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;

public class TerrainAbsorberTileEntity
extends GenericTileEntity
implements ITickable {
    private int absorbing = 0;
    private String terrainName = null;

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.checkStateClient();
        } else {
            this.checkStateServer();
        }
    }

    protected void checkStateClient() {
        if (this.absorbing > 0) {
            Random rand = this.func_145831_w().field_73012_v;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.func_145831_w().func_175688_a(EnumParticleTypes.PORTAL, (double)((float)this.func_174877_v().func_177958_n() + 0.5f) + x * r, (double)((float)this.func_174877_v().func_177956_o() + 0.5f) + y * r, (double)((float)this.func_174877_v().func_177952_p() + 0.5f) + z * r, -x, -y, -z, new int[0]);
        }
    }

    protected void checkStateServer() {
        if (this.absorbing > 0) {
            int dim = this.func_145831_w().field_73011_w.getDimension();
            String terrain = this.getCurrentTerrain(dim);
            if (!terrain.equals(this.terrainName)) {
                return;
            }
            --this.absorbing;
            this.markDirtyClient();
        }
    }

    private String getCurrentTerrain(int dim) {
        DimensionInformation dimensionInformation;
        String terrain = dim == 0 ? TerrainType.TERRAIN_NORMAL.getId() : (dim == -1 ? TerrainType.TERRAIN_CAVERN.getId() : (dim == 1 ? TerrainType.TERRAIN_ISLAND.getId() : ((dimensionInformation = RfToolsDimensionManager.getDimensionManager(this.func_145831_w()).getDimensionInformation(dim)) != null ? dimensionInformation.getTerrainType().getId() : TerrainType.TERRAIN_NORMAL.getId())));
        return terrain;
    }

    public int getAbsorbing() {
        return this.absorbing;
    }

    public String getTerrainName() {
        return this.terrainName;
    }

    public void placeDown() {
        if (this.terrainName == null) {
            int dim = this.func_145831_w().field_73011_w.getDimension();
            String terrain = this.getCurrentTerrain(dim);
            if (terrain == null) {
                this.terrainName = null;
                this.absorbing = 0;
            } else if (!terrain.equals(this.terrainName)) {
                this.terrainName = terrain;
                this.absorbing = DimletConstructionConfiguration.maxTerrainAbsorbtion;
            }
            this.func_70296_d();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("absorbing", this.absorbing);
        if (this.terrainName != null) {
            tagCompound.func_74778_a("terrain", this.terrainName);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.absorbing = tagCompound.func_74762_e("absorbing");
        this.terrainName = tagCompound.func_74764_b("terrain") ? tagCompound.func_74779_i("terrain") : null;
    }
}

