/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world.terrain;

import java.util.Random;
import mcjty.rftoolsdim.config.WorldgenConfiguration;
import mcjty.rftoolsdim.dimensions.world.terrain.BaseTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.NormalTerrainGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.chunk.ChunkPrimer;

public class RoughTerrainGenerator
extends NormalTerrainGenerator {
    private final boolean filled;

    public RoughTerrainGenerator(boolean filled) {
        this.filled = filled;
    }

    @Override
    public void generate(int chunkX, int chunkZ, ChunkPrimer primer) {
        IBlockState baseBlock = this.provider.dimensionInformation.getBaseBlockForTerrain();
        Block baseFluid = this.provider.dimensionInformation.getFluidForTerrain();
        Random random = new Random((long)chunkX * 13L + (long)chunkZ * 577L);
        int index = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height;
                byte waterLevel = (byte)(63.0f + random.nextFloat() * 32.0f - 16.0f);
                for (height = 0; height < WorldgenConfiguration.bedrockLayer; ++height) {
                    BaseTerrainGenerator.setBlockState(primer, index++, Blocks.field_150357_h.func_176223_P());
                }
                while (height < waterLevel) {
                    BaseTerrainGenerator.setBlockState(primer, index++, baseBlock);
                    ++height;
                }
                if (this.filled) {
                    while (height < 63) {
                        BaseTerrainGenerator.setBlockState(primer, index++, baseFluid.func_176223_P());
                        ++height;
                    }
                }
                while (height < 256) {
                    BaseTerrainGenerator.setBlockState(primer, index++, Blocks.field_150350_a.func_176223_P());
                    ++height;
                }
            }
        }
    }
}

