/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags;

import java.util.HashMap;
import java.util.Random;
import mal.lootbags.LootbagsUtil;
import mal.lootbags.blocks.BlockOpener;
import mal.lootbags.blocks.BlockRecycler;
import mal.lootbags.blocks.BlockStorage;
import mal.lootbags.config.BagConfigHandler;
import mal.lootbags.config.GeneralConfigHandler;
import mal.lootbags.handler.BagHandler;
import mal.lootbags.handler.ConfigReloadCommand;
import mal.lootbags.handler.GUIHandler;
import mal.lootbags.handler.InventoryDumpCommand;
import mal.lootbags.handler.ItemDumpCommand;
import mal.lootbags.handler.LootEventHandler;
import mal.lootbags.handler.LootSourceCommand;
import mal.lootbags.handler.MobDropHandler;
import mal.lootbags.handler.NBTPullCommand;
import mal.lootbags.item.LootbagItem;
import mal.lootbags.item.RecyclerItemBlock;
import mal.lootbags.item.StorageItemBlock;
import mal.lootbags.jei.LootRegistry;
import mal.lootbags.loot.LootItem;
import mal.lootbags.loot.LootMap;
import mal.lootbags.network.CommonProxy;
import mal.lootbags.network.LootbagsPacketHandler;
import mal.lootbags.tileentity.TileEntityOpener;
import mal.lootbags.tileentity.TileEntityRecycler;
import mal.lootbags.tileentity.TileEntityStorage;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="lootbags", version="2.5.8.5", dependencies="required:forge@[14.23.4.2703,);after:mystcraft", acceptedMinecraftVersions="[1.12.2]")
public class LootBags {
    public static final String MODID = "lootbags";
    public static final String VERSION = "2.5.8.5";
    public static final String CONFIGVERSION = "CONFIGVER257";
    public static boolean configMismatch = true;
    public static int SPECIALDROPCHANCE = 250;
    public static int DROPRESOLUTION = 1000;
    public static int CHESTQUALITYWEIGHT = 20;
    public static Logger LOOTLOG;
    public static boolean REVERSEQUALITY;
    public static boolean SHOWSECRETBAGS;
    private static boolean HASLOADED;
    public static boolean VERBOSEMODE;
    public static boolean DEBUGMODE;
    public static boolean STOREDCOUNT;
    public static boolean MEKOVERRIDE;
    public static final int MINCHANCE = 0;
    public static final int MAXCHANCE = 1000;
    public static boolean LIMITONEBAGPERDROP;
    public static int BAGFROMPLAYERKILL;
    public static int MINITEMSDROPPED;
    public static int MAXITEMSDROPPED;
    public static int MAXREROLLCOUNT;
    public static int TOTALVALUE;
    public static int RECYCLEDID;
    public static double RECYCLERVALUENUMERATOR;
    public static double RECYCLERVALUENONSTACK;
    public static double RECYCLERVALUESTACK;
    public static int OPENERMAXCOOLDOWN;
    public static boolean PREVENTMERGEDBAGS;
    public static String[] LOOTCATEGORYLIST;
    public static String[] LOOTBAGINDUNGEONLOOT;
    private HashMap<String, Integer> totalvaluemap = new HashMap();
    public static boolean DISABLERECYCLER;
    public static boolean DISABLEOPENER;
    public static boolean DISABLESTORAGE;
    public static boolean DISABLEENCHANTCUT;
    public static LootMap LOOTMAP;
    public static BagConfigHandler bagconfig;
    private static Random random;
    @SidedProxy(clientSide="mal.lootbags.network.ClientProxy", serverSide="mal.lootbags.network.CommonProxy")
    public static CommonProxy prox;
    public static LootbagItem lootbagItem;
    public static BlockRecycler recyclerBlock;
    public static BlockOpener openerBlock;
    public static BlockStorage storageBlock;
    @Mod.Instance(value="lootbags")
    public static LootBags LootBagsInstance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MobDropHandler handler = new MobDropHandler();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)LootBagsInstance, (IGuiHandler)new GUIHandler());
        LOOTLOG = event.getModLog();
        LOOTLOG.log(Level.INFO, "Your current LootBags version is: 2.5.8.5; Your current LootBags Config Version is: CONFIGVER257");
        recyclerBlock = new BlockRecycler();
        openerBlock = new BlockOpener();
        lootbagItem = new LootbagItem();
        storageBlock = new BlockStorage();
        GeneralConfigHandler.loadConfig(event);
        bagconfig = new BagConfigHandler(event);
        bagconfig.initBagConfig();
        LootbagsPacketHandler.init();
        if (CHESTQUALITYWEIGHT <= 0) {
            LootbagsUtil.LogInfo("Chest Weighting < 1, this causes problems for everything and is terrible.  Setting it to 1 instead.");
            CHESTQUALITYWEIGHT = 1;
        }
        if (MAXREROLLCOUNT <= 0) {
            LootbagsUtil.LogInfo("Reroll count has to be at least 1 (fancy error prevention stuff)");
            MAXREROLLCOUNT = 1;
        }
        if (OPENERMAXCOOLDOWN < 0) {
            LootbagsUtil.LogInfo("Negative cooldown is not possible, setting it to 0.");
            OPENERMAXCOOLDOWN = 0;
        }
        if (TOTALVALUE <= 1) {
            LootbagsUtil.LogInfo("Free or negative value required for lootbag creation is not a good thing.  Setting it to 1.");
            TOTALVALUE = 1;
        }
        if (BagHandler.isIDFree(RECYCLEDID)) {
            LootbagsUtil.LogInfo("The requested ID is not actually a bag, using the lowest used ID.");
            RECYCLEDID = BagHandler.getLowestUsedID();
        }
        if (RECYCLERVALUESTACK <= 0.0) {
            LootbagsUtil.LogInfo("Dividing by zero or having a negative loot item value is not good.  Setting it to 1.0.");
            RECYCLERVALUESTACK = 1.0;
        }
        if (RECYCLERVALUENONSTACK <= 0.0) {
            LootbagsUtil.LogInfo("Dividing by zero or having a negative loot item value is not good.  Setting it to 1.0.");
            RECYCLERVALUENONSTACK = 1.0;
        }
        if (RECYCLERVALUENUMERATOR <= 0.0) {
            LootbagsUtil.LogInfo("Free or negative loot item value is not good.  Setting it to 1.0.");
            RECYCLERVALUENUMERATOR = 1.0;
        }
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        prox.registerRenderersInit();
        MinecraftForge.EVENT_BUS.register((Object)new LootEventHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        GameRegistry.registerTileEntity(TileEntityRecycler.class, (ResourceLocation)new ResourceLocation(MODID, "tileentityrecycler"));
        GameRegistry.registerTileEntity(TileEntityOpener.class, (ResourceLocation)new ResourceLocation(MODID, "tileentityopener"));
        GameRegistry.registerTileEntity(TileEntityStorage.class, (ResourceLocation)new ResourceLocation(MODID, "_tileentitystorage"));
        LOOTMAP = new LootMap();
        LOOTMAP.populateGeneralBlacklist(GeneralConfigHandler.getBlacklistConfigData());
        LOOTMAP.populateGeneralWhitelist(GeneralConfigHandler.getWhitelistConfigData());
        LOOTMAP.setLootSources(LOOTCATEGORYLIST);
        LOOTMAP.setContext(null);
        LOOTMAP.populateGeneralMap(null);
        BagHandler.populateBagLists();
        LOOTMAP.setTotalListWeight();
        LOOTMAP.populateRecyclerBlacklist(GeneralConfigHandler.getRecyclerBlacklistConfigData());
        LOOTMAP.populateRecyclerWhitelist(GeneralConfigHandler.getRecyclerWhitelistConfigData());
        LOOTMAP.populateLootValues();
        LOOTMAP.populateRecyclerMap();
        LootbagsUtil.LogInfo("Completed on-load tasks.");
        LootRegistry.getInstance();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new ItemDumpCommand());
        event.registerServerCommand((ICommand)new LootSourceCommand());
        event.registerServerCommand((ICommand)new NBTPullCommand());
        event.registerServerCommand((ICommand)new ConfigReloadCommand());
        event.registerServerCommand((ICommand)new InventoryDumpCommand());
        LOOTMAP.setContext(FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0]);
    }

    public static boolean isItemDroppable(ItemStack item) {
        for (LootItem loot : LootBags.LOOTMAP.recyclerWhitelist) {
            if (!LootBags.areItemStacksEqualItem(loot.getContentItem(), item, true, false)) continue;
            return true;
        }
        for (LootItem loot : LootBags.LOOTMAP.totalList.values()) {
            if (LootBags.areItemStacksEqualItem(loot.getContentItem(), item, true, false)) {
                return true;
            }
            if (!(loot.getContentItem().func_77973_b() instanceof ItemBook) || !(item.func_77973_b() instanceof ItemEnchantedBook)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemRecyleBlacklisted(ItemStack item) {
        for (LootItem loot : LootBags.LOOTMAP.recyclerBlacklist) {
            if (!LootBags.areItemStacksEqualItem(loot.getContentItem(), item, true, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemRecycleWhitelisted(ItemStack item) {
        for (LootItem loot : LootBags.LOOTMAP.recyclerWhitelist) {
            if (!LootBags.areItemStacksEqualItem(loot.getContentItem(), item, true, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemRecyclable(ItemStack item) {
        return (LootBags.isItemDroppable(item) || LootBags.isItemRecycleWhitelisted(item)) && !LootBags.isItemRecyleBlacklisted(item);
    }

    public static int getItemValue(ItemStack item) {
        for (LootItem c : LootBags.LOOTMAP.recyclerWhitelist) {
            if (!LootBags.areItemStacksEqualItem(c.getContentItem(), item, true, false)) continue;
            double value = Math.ceil(RECYCLERVALUENUMERATOR * (double)LOOTMAP.getTotalListWeight() / ((double)c.getItemWeight() * (item.func_77976_d() == 1 ? RECYCLERVALUENONSTACK : RECYCLERVALUESTACK)));
            if (value <= 0.0) {
                value = 1.0;
            }
            return (int)value;
        }
        for (LootItem c : LootBags.LOOTMAP.totalList.values()) {
            if (!LootBags.areItemStacksEqualItem(c.getContentItem(), item, true, false) && (!(c.getContentItem().func_77973_b() instanceof ItemBook) || !(item.func_77973_b() instanceof ItemEnchantedBook))) continue;
            double value = Math.ceil(RECYCLERVALUENUMERATOR * (double)LOOTMAP.getTotalListWeight() / ((double)c.getItemWeight() * (item.func_77976_d() == 1 ? RECYCLERVALUENONSTACK : RECYCLERVALUESTACK)));
            if (value <= 0.0) {
                value = 1.0;
            }
            return (int)value;
        }
        return 0;
    }

    public static boolean areItemStacksEqualItem(ItemStack is1, ItemStack is2, boolean alwaysUseDamage, boolean considerNBT) {
        if (is1 == null || is2 == null) {
            return is1 == is2;
        }
        if (is1.func_190926_b() || is2.func_190926_b()) {
            return is1.func_190926_b() && is2.func_190926_b();
        }
        if (is1.func_77973_b() != is2.func_77973_b()) {
            return false;
        }
        if (alwaysUseDamage && is1.func_77981_g() && is2.func_77981_g() && is1.func_77952_i() != is2.func_77952_i()) {
            return false;
        }
        return !considerNBT || ItemStack.func_77970_a((ItemStack)is1, (ItemStack)is2);
    }

    public static int getDefaultDropWeight() {
        return DROPRESOLUTION / 10;
    }

    public static Random getRandom() {
        return random;
    }

    static {
        REVERSEQUALITY = true;
        SHOWSECRETBAGS = true;
        HASLOADED = false;
        VERBOSEMODE = true;
        DEBUGMODE = false;
        STOREDCOUNT = true;
        MEKOVERRIDE = false;
        LIMITONEBAGPERDROP = false;
        BAGFROMPLAYERKILL = 2;
        MINITEMSDROPPED = 1;
        MAXITEMSDROPPED = 5;
        MAXREROLLCOUNT = 50;
        TOTALVALUE = 1000;
        RECYCLEDID = 0;
        RECYCLERVALUENUMERATOR = 2.0;
        RECYCLERVALUENONSTACK = 1.0;
        RECYCLERVALUESTACK = 8.0;
        OPENERMAXCOOLDOWN = 100;
        PREVENTMERGEDBAGS = false;
        LOOTCATEGORYLIST = null;
        DISABLERECYCLER = false;
        DISABLEOPENER = false;
        DISABLESTORAGE = false;
        DISABLEENCHANTCUT = false;
        random = new Random();
    }

    @Mod.EventBusSubscriber(modid="lootbags")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{openerBlock, recyclerBlock, storageBlock});
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            event.getRegistry().register((IForgeRegistryEntry)lootbagItem);
            prox.registerRenderersItem();
            event.getRegistry().register(new ItemBlock((Block)openerBlock).setRegistryName(openerBlock.getRegistryName()));
            event.getRegistry().register(new RecyclerItemBlock((Block)recyclerBlock).setRegistryName(recyclerBlock.getRegistryName()));
            event.getRegistry().register(new StorageItemBlock((Block)storageBlock).setRegistryName(storageBlock.getRegistryName()));
        }
    }
}

