/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import mal.core.util.FakeWorld;
import mal.lootbags.LootBags;
import mal.lootbags.loot.LootItem;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntryItemAccess;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import org.apache.logging.log4j.Level;

public class LootbagsUtil {
    private static LootTableManager manager;

    public static void LogError(String message) {
        LootBags.LOOTLOG.log(Level.ERROR, message);
    }

    public static void LogError(String message, ICommandSender icommand) {
        LootbagsUtil.LogError(message);
        if (icommand != null) {
            icommand.func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    public static void LogInfo(String message) {
        if (LootBags.VERBOSEMODE) {
            LootBags.LOOTLOG.log(Level.INFO, message);
        }
    }

    public static void LogDebug(String message) {
        if (LootBags.DEBUGMODE) {
            LootBags.LOOTLOG.log(Level.INFO, message);
        }
    }

    public static ArrayList<Integer> constructDamageRange(String word) {
        int i;
        ArrayList<Integer> damages = new ArrayList<Integer>();
        String[] sec = word.split("[#&]");
        if (sec.length == 1) {
            try {
                damages.add(Integer.parseInt(sec[0]));
            }
            catch (Exception e) {
                LootbagsUtil.LogError("Cannot construct a damage range that doesn't follow the correct syntax.");
                return null;
            }
            return damages;
        }
        int wordindex = 0;
        for (i = 0; i < sec.length - 1; ++i) {
            wordindex += sec[i].length();
            try {
                int num1 = Integer.parseInt(sec[i]);
                int num2 = Integer.parseInt(sec[i + 1]);
                if (word.substring(wordindex, wordindex + 1).equalsIgnoreCase("#")) {
                    damages.add(num1);
                    damages.add(num2);
                } else if (word.substring(wordindex, wordindex + 1).equalsIgnoreCase("&")) {
                    if (num2 < num1) {
                        int t = num1;
                        num1 = num2;
                        num2 = t;
                    }
                    for (int j = num1; j <= num2; ++j) {
                        damages.add(j);
                    }
                }
                ++wordindex;
                continue;
            }
            catch (Exception e) {
                LootbagsUtil.LogError("Cannot construct a damage range that doesn't follow the correct syntax.");
                return null;
            }
        }
        for (i = 1; i < damages.size(); ++i) {
            for (int j = i; j > 1 && damages.get(j) < damages.get(j - 1); --j) {
                int temp = damages.get(j);
                damages.set(j, damages.get(j - 1));
                damages.set(j - 1, temp);
            }
        }
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i2 = 0; i2 < damages.size(); ++i2) {
            if (ret.contains(damages.get(i2))) continue;
            ret.add(damages.get(i2));
        }
        return ret;
    }

    public static byte[] parseNBTArray(String array) {
        String[] sec = array.split("\\|");
        byte[] nbt = new byte[sec.length];
        for (int i = 0; i < nbt.length; ++i) {
            nbt[i] = Byte.parseByte(sec[i]);
        }
        return nbt;
    }

    public static ArrayList<String> addLineBreaks(String input) {
        return LootbagsUtil.addLineBreaks(input, "");
    }

    public static ArrayList<String> addLineBreaks(String input, String pretext) {
        int MAXLENGTH = 40;
        String APPEND = "|";
        String SPACE = " ";
        String[] tokens = input.split("\\s+");
        StringBuilder output = new StringBuilder(input.length());
        int len = 0;
        for (int i = 0; i < tokens.length; ++i) {
            String word = tokens[i];
            if (len + (SPACE + word).length() > MAXLENGTH) {
                if (i > 0) {
                    output.append(APPEND);
                }
                len = 0;
            }
            if (i < tokens.length - 1 && len + (word + SPACE).length() + tokens[i + 1].length() <= MAXLENGTH) {
                word = word + SPACE;
            }
            output.append(word);
            len += word.length();
        }
        String[] list = output.toString().split("\\|");
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < list.length; ++i) {
            ret.add(pretext + list[i]);
        }
        return ret;
    }

    public static boolean listContainsItem(ArrayList<LootItem> list, LootItem item) {
        for (LootItem loot : list) {
            if (!LootBags.areItemStacksEqualItem(loot.getContentItem(), item.getContentItem(), true, false)) continue;
            return true;
        }
        return false;
    }

    public static byte[] compress(NBTTagCompound p_74798_0_) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        try (DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(bytearrayoutputstream));){
            CompressedStreamTools.func_74800_a((NBTTagCompound)p_74798_0_, (DataOutput)dataoutputstream);
        }
        return bytearrayoutputstream.toByteArray();
    }

    public static ItemStack[] generateStacks(Random rand, LootItem lootitem, int min, int max) {
        ItemStack[] ret;
        int count = min + rand.nextInt(max - min + 1);
        ItemStack source = lootitem.getContentItem().func_77946_l();
        source = LootEntryItemAccess.applyFunctions(lootitem.getLootItem(), source, LootBags.LOOTMAP.getContext());
        if (source.func_77973_b() == null) {
            ret = new ItemStack[]{};
        } else if (count > source.func_77976_d()) {
            ret = new ItemStack[count];
            for (int x = 0; x < count; ++x) {
                ret[x] = source.func_77946_l();
                ret[x].func_190920_e(1);
            }
        } else {
            ret = new ItemStack[]{source};
            ret[0].func_190920_e(count);
        }
        return ret;
    }

    public static String translateToLocal(String text) {
        return new TextComponentTranslation(text, new Object[0]).func_150254_d();
    }

    public static LootTableManager getLootManager(@Nullable World world) {
        if (world == null || world.func_184146_ak() == null) {
            if (manager == null) {
                FakeWorld.FakeSave saveHandler = FakeWorld.saves;
                manager = new LootTableManager(new File(new File(saveHandler.func_75765_b(), "data"), "loot_tables"));
            }
            return manager;
        }
        return world.func_184146_ak();
    }

    public static LootItem getRandomItem(List<LootItem> list, int totalWeight) {
        if (totalWeight <= 0) {
            LootbagsUtil.LogError("Total Weight less than or equal to zero.");
            return null;
        }
        int weight = LootBags.getRandom().nextInt(totalWeight);
        for (int i = 0; i < list.size(); ++i) {
            LootItem item = list.get(i);
            if ((weight -= item.field_76292_a) >= 0) continue;
            return item;
        }
        return null;
    }

    public static NonNullList<Ingredient> parseShapeless(JsonContext context, JsonObject json) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (JsonElement element : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element, (JsonContext)context));
        }
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No Ingredients.");
        }
        return ingredients;
    }

    public static String formatSciNot(int value) {
        DecimalFormat formatter = new DecimalFormat("0.##E0");
        if (value > 99999) {
            return formatter.format(value);
        }
        return Integer.toString(value);
    }

    public static boolean isPointInRegion(int left, int top, int width, int height, int pointx, int pointy, int guiLeft, int guiTop) {
        return (pointx -= guiLeft) >= left - 1 && pointx < left + width + 1 && (pointy -= guiTop) >= top - 1 && pointy < top + height + 1;
    }

    public static ItemStack[] getItemStackArrayEmpty(int size) {
        ItemStack[] out = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            out[i] = ItemStack.field_190927_a;
        }
        return out;
    }
}

