/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mal.lootbags.LootBags;
import mal.lootbags.jei.LootEntry;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;

public class LootWrapper
implements IRecipeWrapper,
ITooltipCallback<ItemStack> {
    public final LootEntry loot;

    public LootWrapper(LootEntry loot) {
        this.loot = loot;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setOutputs(ItemStack.class, this.loot.getItemStacks(null));
        ingredients.setInput(ItemStack.class, (Object)this.loot.getBag().getBagItem());
    }

    public int amountOfItems(IFocus<ItemStack> focus) {
        return this.loot.getItemStacks(focus).size();
    }

    public List<ItemStack> getItems(IFocus<ItemStack> focus, int slot, int slots) {
        int i;
        List<ItemStack> list = this.loot.getItemStacks(focus).subList(slot, slot + 1);
        list.add(list.get(0));
        for (i = 1; i < this.amountOfItems(focus) / slots + 1; ++i) {
            list.add(this.amountOfItems(focus) <= slot + slots * i ? null : this.loot.getItemStacks(focus).get(slot + slots * i));
            list.add(this.amountOfItems(focus) <= slot + slots * i ? null : this.loot.getItemStacks(focus).get(slot + slots * i));
        }
        for (i = list.size() - 1; i >= 0; --i) {
            if (list.get(i) != null) continue;
            list.remove(i);
        }
        if (this.amountOfItems(focus) < 50) {
            list.removeIf(Objects::isNull);
        }
        return list;
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        if (slotIndex != 0) {
            tooltip.add("Drop Chance: " + String.format("%.2f", this.loot.getItemChance(ingredient)) + "%.");
            if (LootBags.DEBUGMODE) {
                tooltip.add(this.loot.getBagDrop(ingredient).toString());
            }
        }
    }

    public List<ItemStack> getBag() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.loot.getBag().getBagItem());
        return list;
    }
}

