/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.factory;

import info.loenwind.autoconfig.factory.IValueFactory;
import info.loenwind.autoconfig.factory.Network;
import info.loenwind.autoconfig.factory.PacketConfigSync;
import info.loenwind.autoconfig.util.Log;
import info.loenwind.autoconfig.util.NullHelper;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class FactoryManager {
    private static boolean registered = false;
    public static final String SERVER_OVERRIDE = " (synced from server)";
    public static final String SERVER_SYNC = " (must be kept in sync with server)";
    private static final Map<String, IValueFactory> factories = new HashMap<String, IValueFactory>();
    private static int overrides = 0;

    private static void create() {
        if (!registered) {
            MinecraftForge.EVENT_BUS.register(FactoryManager.class);
            Network.create();
            registered = true;
        }
    }

    public static boolean hasOverrides() {
        return overrides > 0;
    }

    static void read(String mod, String section, ByteBuf buf) {
        Log.debug("Read " + factories.get(mod + "." + section).read(buf) + " config values from server packet for " + mod + " (" + section + ")");
        ++overrides;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerFactory(IValueFactory factory) {
        Map<String, IValueFactory> map = factories;
        synchronized (map) {
            FactoryManager.create();
            factories.put(factory.getModid() + "." + factory.getSection(), factory);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggon(PlayerEvent.PlayerLoggedInEvent evt) {
        for (IValueFactory factory : factories.values()) {
            if (!factory.needsSyncing()) continue;
            Network.sendTo(new PacketConfigSync(factory), (EntityPlayerMP)NullHelper.notnullF(evt.player, "PlayerLoggedInEvent without player"));
            Log.debug("Sent config to player " + evt.player.getDisplayNameString() + " for " + factory.getModid() + " (" + factory.getSection() + ")");
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        for (IValueFactory factory : factories.values()) {
            factory.endServerOverride();
            Log.debug("Removed server config override for " + factory.getModid() + " (" + factory.getSection() + ")");
        }
        overrides = 0;
    }
}

