/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.factory;

import info.loenwind.autoconfig.factory.AbstractValue;
import info.loenwind.autoconfig.factory.ByteBufAdapters;
import info.loenwind.autoconfig.factory.IByteBufAdapter;
import info.loenwind.autoconfig.factory.IValueFactory;
import info.loenwind.autoconfig.util.NullHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

class FluidValue
extends AbstractValue<Fluid> {
    private static final Fluid defaultFluidPlaceholder = new Fluid("", null, null);
    private final String defaultValueName;
    @Nullable
    private Fluid defaultFluid = null;

    protected FluidValue(IValueFactory owner, String section, String keyname, String defaultValue, String text) {
        super(owner, section, keyname, defaultFluidPlaceholder, text);
        this.defaultValueName = defaultValue;
    }

    @Override
    @Nonnull
    public Fluid get() {
        String valueInConfig = this.getString();
        if (!Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            return (Fluid)this.defaultValue;
        }
        if (this.defaultFluid == null) {
            this.defaultFluid = FluidRegistry.getFluid((String)this.defaultValueName);
        }
        if (this.value == null || this.valueGeneration != this.owner.getGeneration()) {
            Map<String, Object> serverConfig = this.owner.getServerConfig();
            if (serverConfig != null && serverConfig.containsKey(this.keyname)) {
                this.value = (Fluid)serverConfig.get(this.keyname);
            } else {
                this.value = FluidRegistry.getFluid((String)valueInConfig);
                if (!this.owner.isInInit() && this.owner.getConfig().hasChanged()) {
                    this.owner.getConfig().save();
                }
            }
            this.valueGeneration = this.owner.getGeneration();
        }
        return NullHelper.first((Fluid)this.value, this.defaultFluid, (Fluid)this.defaultValue);
    }

    @Nullable
    private String getString() {
        Property prop = this.owner.getConfig().get(this.section, this.keyname, this.defaultValueName);
        prop.setLanguageKey(this.keyname);
        prop.setValidationPattern(null);
        prop.setComment(this.getText() + " [default: " + this.defaultValueName + "]");
        prop.setRequiresMcRestart(this.isStartup);
        return prop.getString();
    }

    @Override
    @Nullable
    protected Fluid makeValue() {
        this.getString();
        return null;
    }

    @Override
    protected IByteBufAdapter<Fluid> getDataType() {
        return ByteBufAdapters.FLUID;
    }
}

