/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.fx.particle.system.ParticleSystem;
import org.orecruncher.dsurround.client.handlers.EffectHandlerBase;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.lib.BlockPosHelper;

@SideOnly(value=Side.CLIENT)
public class ParticleSystemHandler
extends EffectHandlerBase {
    private static ParticleSystemHandler _instance = null;
    private final Object2ObjectOpenHashMap<BlockPos, ParticleSystem> systems = new Object2ObjectOpenHashMap();

    public ParticleSystemHandler() {
        super("Particle Systems");
    }

    @Override
    public boolean doTick(int tick) {
        return !this.systems.isEmpty();
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        double range = ModOptions.effects.specialEffectRange;
        BlockPos min = EnvironStateHandler.EnvironState.getPlayerPosition().func_177963_a(-range, -range, -range);
        BlockPos max = EnvironStateHandler.EnvironState.getPlayerPosition().func_177963_a(range, range, range);
        this.systems.object2ObjectEntrySet().removeIf(entry -> {
            ParticleSystem system = (ParticleSystem)entry.getValue();
            if (BlockPosHelper.notContains((BlockPos)system.getPos(), (BlockPos)min, (BlockPos)max)) {
                system.setExpired();
            } else {
                system.onUpdate();
            }
            return !system.isAlive();
        });
    }

    @Override
    public void onConnect() {
        _instance = this;
        this.systems.clear();
    }

    @Override
    public void onDisconnect() {
        this.systems.clear();
        _instance = null;
    }

    public static boolean okToSpawn(@Nonnull BlockPos pos) {
        return !ParticleSystemHandler._instance.systems.containsKey((Object)pos);
    }

    public static void addSystem(@Nonnull ParticleSystem system) {
        ParticleSystemHandler._instance.systems.put((Object)system.getPos().func_185334_h(), (Object)system);
    }
}

