/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.acoustics;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.registry.acoustics.EventType;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.dsurround.registry.acoustics.IOptions;
import org.orecruncher.dsurround.registry.acoustics.ISoundPlayer;

@SideOnly(value=Side.CLIENT)
public class ProbabilityWeightsAcoustic
implements IAcoustic {
    protected final IAcoustic[] acoustics;
    protected final int[] weights;
    protected final int totalWeight;

    public ProbabilityWeightsAcoustic(@Nonnull List<IAcoustic> acoustics, @Nonnull List<Integer> weights) {
        this.acoustics = acoustics.toArray(new IAcoustic[acoustics.size()]);
        this.weights = new int[weights.size()];
        int tWeight = 0;
        for (int i = 0; i < weights.size(); ++i) {
            this.weights[i] = weights.get(i);
            tWeight += this.weights[i];
        }
        this.totalWeight = tWeight;
    }

    @Override
    @Nonnull
    public String getName() {
        return "Probability Weights Acoustic";
    }

    @Override
    public void playSound(@Nonnull ISoundPlayer player2, @Nonnull Vec3d location, @Nonnull EventType event, @Nullable IOptions inputOptions) {
        if (this.totalWeight <= 0) {
            return;
        }
        int targetWeight = player2.getRNG().nextInt(this.totalWeight);
        int i = 0;
        i = this.weights.length;
        while ((targetWeight -= this.weights[i - 1]) >= 0) {
            --i;
        }
        this.acoustics[i - 1].playSound(player2, location, event, inputOptions);
    }
}

