/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.opencomputers;

import blusunrize.immersiveengineering.api.tool.AssemblerHandler;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityAssembler;
import blusunrize.immersiveengineering.common.util.compat.opencomputers.ManagedEnvironmentIE;
import java.util.ArrayList;
import java.util.HashMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AssemblerDriver
extends DriverSidedTileEntity {
    public ManagedEnvironment createEnvironment(World w, BlockPos bp, EnumFacing s) {
        TileEntityAssembler assembler;
        TileEntityAssembler master;
        TileEntity te = w.func_175625_s(bp);
        if (te instanceof TileEntityAssembler && (master = (TileEntityAssembler)(assembler = (TileEntityAssembler)te).master()) != null && assembler.isRedstonePos()) {
            return new AssemblerEnvironment(w, master.func_174877_v(), TileEntityAssembler.class);
        }
        return null;
    }

    public Class<?> getTileEntityClass() {
        return TileEntityAssembler.class;
    }

    public class AssemblerEnvironment
    extends ManagedEnvironmentIE.ManagedEnvMultiblock<TileEntityAssembler> {
        public String preferredName() {
            return "ie_assembler";
        }

        public int priority() {
            return 1000;
        }

        public AssemblerEnvironment(World w, BlockPos bp, Class<? extends TileEntityIEBase> teClass) {
            super(w, bp, teClass);
        }

        @Callback(doc="function(recipe:int):boolean -- get whether the ingredients for the specified recipe are available")
        public Object[] hasIngredients(Context context, Arguments args) {
            int recipe = args.checkInteger(0);
            if (recipe > 3 || recipe < 1) {
                throw new IllegalArgumentException("Only recipes 1-3 are available");
            }
            TileEntityAssembler master = (TileEntityAssembler)this.getTileEntity();
            if (((ItemStack)master.patterns[recipe - 1].inv.get(9)).func_190926_b()) {
                throw new IllegalArgumentException("The requested recipe is invalid");
            }
            TileEntityAssembler.CrafterPatternInventory pattern = master.patterns[recipe - 1];
            AssemblerHandler.IRecipeAdapter adapter = AssemblerHandler.findAdapter(pattern.recipe);
            ArrayList<ItemStack> queryList = new ArrayList<ItemStack>();
            for (ItemStack stack : master.inventory) {
                if (stack.func_190926_b()) continue;
                queryList.add(stack.func_77946_l());
            }
            AssemblerHandler.RecipeQuery[] queries = adapter.getQueriedInputs(pattern.recipe, pattern.inv);
            if (queries == null) {
                throw new IllegalArgumentException("The Assembler cannot craft this recipe");
            }
            return new Object[]{master.consumeIngredients(queries, queryList, false, null)};
        }

        @Callback(doc="function(recipe:int):table -- get the recipe in the specified position")
        public Object[] getRecipe(Context context, Arguments args) {
            int recipe = args.checkInteger(0);
            if (recipe > 3 || recipe < 1) {
                throw new IllegalArgumentException("Only recipes 1-3 are available");
            }
            TileEntityAssembler te = (TileEntityAssembler)this.getTileEntity();
            HashMap<String, Object> ret = new HashMap<String, Object>();
            for (int i = 0; i < 9; ++i) {
                ret.put("in" + (i + 1), te.patterns[recipe - 1].inv.get(i));
            }
            ret.put("out", te.patterns[recipe - 1].inv.get(9));
            return new Object[]{ret};
        }

        @Callback(doc="function(recipe:int):boolean -- check whether the recipe in the specified position has an output")
        public Object[] isValidRecipe(Context context, Arguments args) {
            int recipe = args.checkInteger(0);
            if (recipe > 3 || recipe < 1) {
                throw new IllegalArgumentException("Only recipes 1-3 are available");
            }
            return new Object[]{!((ItemStack)((TileEntityAssembler)this.getTileEntity()).patterns[recipe - 1].inv.get(9)).func_190926_b()};
        }

        @Callback(doc="function(tank:int):table -- gets the specified tank")
        public Object[] getTank(Context context, Arguments args) {
            int tank = args.checkInteger(0);
            if (tank > 3 || tank < 1) {
                throw new IllegalArgumentException("Only tanks 1-3 are available");
            }
            return new Object[]{((TileEntityAssembler)this.getTileEntity()).tanks[tank - 1].getInfo()};
        }

        @Callback(doc="function():int -- returns the maximum amount of energy that can be stored")
        public Object[] getMaxEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityAssembler)this.getTileEntity()).energyStorage.getMaxEnergyStored()};
        }

        @Callback(doc="function():int -- returns the amount of energy stored")
        public Object[] getEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityAssembler)this.getTileEntity()).energyStorage.getEnergyStored()};
        }

        @Callback(doc="function(slot:int):table -- returns the stack in the specified slot")
        public Object[] getStackInSlot(Context context, Arguments args) {
            int slot = args.checkInteger(0);
            if (slot < 1 || slot > 18) {
                throw new IllegalArgumentException("Only slots 1-18 are available");
            }
            return new Object[]{((TileEntityAssembler)this.getTileEntity()).inventory.get(slot - 1)};
        }

        @Callback(doc="function(slot:int):table -- returns the stack in the output slot of the specified recipe")
        public Object[] getBufferStack(Context context, Arguments args) {
            int slot = args.checkInteger(0);
            if (slot < 1 || slot > 3) {
                throw new IllegalArgumentException("Only recipes 1-3 are available");
            }
            return new Object[]{((TileEntityAssembler)this.getTileEntity()).inventory.get(17 + slot)};
        }

        @Override
        @Callback(doc="function(enabled:bool):nil -- Enables or disables computer control for the attached machine")
        public Object[] enableComputerControl(Context context, Arguments args) {
            TileEntityAssembler te = (TileEntityAssembler)this.getTileEntity();
            te.isComputerControlled = args.checkBoolean(0);
            for (int i = 0; i < 3; ++i) {
                te.computerOn[i] = true;
            }
            return null;
        }

        @Override
        @Callback(doc="function(recipe:int) -- enables or disables the specified recipe")
        public Object[] setEnabled(Context context, Arguments args) {
            boolean on = args.checkBoolean(1);
            int recipe = args.checkInteger(0);
            if (recipe > 3 || recipe < 1) {
                throw new IllegalArgumentException("Only recipes 1-3 are available");
            }
            ((TileEntityAssembler)this.getTileEntity()).computerOn[recipe - 1] = on;
            return null;
        }
    }
}

