/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.debugtools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.network.PacketDumpBlockInfo;
import mcjty.lib.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.Level;

public class DumpBlockNBT {
    public static String dumpBlockNBT(@Nonnull World world, @Nonnull BlockPos pos, boolean verbose) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        Block block = state.func_177230_c();
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("block", (JsonElement)new JsonPrimitive(block.getRegistryName().toString()));
        jsonObject.add("meta", (JsonElement)new JsonPrimitive((Number)block.func_176201_c(state)));
        if (te != null) {
            jsonObject.add("teClass", (JsonElement)new JsonPrimitive(te.getClass().getCanonicalName()));
            NBTTagCompound tag = new NBTTagCompound();
            te.func_189515_b(tag);
            if (verbose) {
                String nbtJson = tag.toString();
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse(nbtJson);
                jsonObject.add("nbt", element);
            } else {
                JsonArray array = new JsonArray();
                for (String key : tag.func_150296_c()) {
                    array.add((JsonElement)new JsonPrimitive(key));
                }
                jsonObject.add("nbt", (JsonElement)array);
            }
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)jsonObject);
    }

    public static void dumpBlock(@Nullable SimpleNetworkWrapper network, @Nonnull World world, @Nonnull BlockPos pos, boolean verbose) {
        String output = DumpBlockNBT.dumpBlockNBT(world, pos, verbose);
        Logging.getLogger().log(Level.INFO, "### Client side ###");
        Logging.getLogger().log(Level.INFO, output);
        if (network != null) {
            network.sendToServer((IMessage)new PacketDumpBlockInfo(world, pos, verbose));
        }
    }

    public static void dumpFocusedBlock(@Nullable SimpleNetworkWrapper network, @Nonnull EntityPlayer player, boolean liquids, boolean verbose) {
        Vec3d start = player.func_174824_e(1.0f);
        Vec3d vec31 = player.func_70676_i(1.0f);
        float dist = 20.0f;
        Vec3d end = start.func_72441_c(vec31.field_72450_a * (double)dist, vec31.field_72448_b * (double)dist, vec31.field_72449_c * (double)dist);
        RayTraceResult result = player.func_130014_f_().func_72901_a(start, end, liquids);
        if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        String output = DumpBlockNBT.dumpBlockNBT(player.func_130014_f_(), result.func_178782_a(), verbose);
        Logging.getLogger().log(Level.INFO, "### Client side ###");
        Logging.getLogger().log(Level.INFO, output);
        if (network != null) {
            network.sendToServer((IMessage)new PacketDumpBlockInfo(player.func_130014_f_(), result.func_178782_a(), verbose));
        }
    }
}

