/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockVine;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nightkosh.gravestone.ModGraveStone;
import nightkosh.gravestone.api.grave.EnumGraveType;
import nightkosh.gravestone.block.enums.EnumGraves;
import nightkosh.gravestone.config.Config;
import nightkosh.gravestone.core.GSBlock;
import nightkosh.gravestone.core.Tabs;
import nightkosh.gravestone.core.logger.GSLogger;
import nightkosh.gravestone.helper.GraveGenerationHelper;
import nightkosh.gravestone.helper.GraveStoneHelper;
import nightkosh.gravestone.inventory.GraveInventory;
import nightkosh.gravestone.tileentity.TileEntityGraveStone;

public class BlockGraveStone
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final AxisAlignedBB VP_SOUTH_BB = new AxisAlignedBB(0.125, 0.0, 0.0625, 0.875, 0.9375, 0.1875);
    private static final AxisAlignedBB VP_NORTH_BB = new AxisAlignedBB(0.125, 0.0, 0.8125, 0.875, 0.9375, 0.9375);
    private static final AxisAlignedBB VP_EAST_BB = new AxisAlignedBB(0.0625, 0.0, 0.125, 0.1875, 0.9375, 0.875);
    private static final AxisAlignedBB VP_WEST_BB = new AxisAlignedBB(0.8125, 0.0, 0.125, 0.9375, 0.9375, 0.875);
    private static final AxisAlignedBB CROSS_SOUTH_BB = new AxisAlignedBB(0.125, 0.0, 0.0625, 0.875, 1.0, 0.1875);
    private static final AxisAlignedBB CROSS_NORTH_BB = new AxisAlignedBB(0.125, 0.0, 0.8125, 0.875, 1.0, 0.9375);
    private static final AxisAlignedBB CROSS_EAST_BB = new AxisAlignedBB(0.0625, 0.0, 0.125, 0.1875, 1.0, 0.875);
    private static final AxisAlignedBB CROSS_WEST_BB = new AxisAlignedBB(0.8125, 0.0, 0.125, 0.9375, 1.0, 0.875);
    private static final AxisAlignedBB CC_NORTH_SOUTH_BB = new AxisAlignedBB(0.125, 0.0, (double)0.35f, 0.875, (double)1.3f, (double)0.65f);
    private static final AxisAlignedBB CC_EAST_WEST_BB = new AxisAlignedBB((double)0.35f, 0.0, 0.125, (double)0.65f, (double)1.3f, 0.875);
    private static final AxisAlignedBB PL_STATUES_BB = new AxisAlignedBB((double)0.35f, 0.0, (double)0.35f, (double)0.65f, (double)0.92f, (double)0.65f);
    private static final AxisAlignedBB HP_NORTH_SOUTH_BB = new AxisAlignedBB(0.09375, 0.0, 0.0625, 0.90625, 0.0625, 0.9375);
    private static final AxisAlignedBB HP_EAST_WEST_BB = new AxisAlignedBB(0.0625, 0.0, 0.09375, 0.9375, 0.0625, 0.90625);
    private static final AxisAlignedBB DOG_SOUTH_BB = new AxisAlignedBB((double)0.35f, 0.0, (double)0.3f, (double)0.6f, 0.5, (double)0.9f);
    private static final AxisAlignedBB DOG_NORTH_BB = new AxisAlignedBB((double)0.35f, 0.0, (double)0.7f, (double)0.6f, 0.5, (double)0.1f);
    private static final AxisAlignedBB DOG_EAST_BB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.35f, (double)0.9f, 0.5, (double)0.6f);
    private static final AxisAlignedBB DOG_WEST_BB = new AxisAlignedBB((double)0.7f, 0.0, (double)0.35f, (double)0.1f, 0.5, (double)0.6f);
    private static final AxisAlignedBB CAT_SOUTH_BB = new AxisAlignedBB((double)0.43f, 0.0, (double)0.3f, (double)0.57f, 0.5, 0.75);
    private static final AxisAlignedBB CAT_NORTH_BB = new AxisAlignedBB((double)0.43f, 0.0, (double)0.7f, (double)0.57f, 0.5, 0.25);
    private static final AxisAlignedBB CAT_EAST_BB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.43f, 0.75, 0.5, (double)0.57f);
    private static final AxisAlignedBB CAT_WEST_BB = new AxisAlignedBB((double)0.7f, 0.0, (double)0.43f, 0.25, 0.5, (double)0.57f);
    private static final AxisAlignedBB CORPSE_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.3f, 1.0);
    private static final AxisAlignedBB SWORD_SOUTH_NORTH_BB = new AxisAlignedBB(0.375, 0.0, 0.4375, 0.625, (double)0.9f, 0.5625);
    private static final AxisAlignedBB SWORD_EAST_WEST_BB = new AxisAlignedBB(0.4375, 0.0, 0.375, 0.5625, (double)0.9f, 0.625);
    private static final AxisAlignedBB HS_SOUTH_NORTH_BB = new AxisAlignedBB(0.375, 0.0, (double)0.275f, 0.625, (double)0.85f, (double)0.725f);
    private static final AxisAlignedBB HS_EAST_WEST_BB = new AxisAlignedBB((double)0.275f, 0.0, 0.375, (double)0.725f, (double)0.85f, 0.625);

    public BlockGraveStone() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149647_a(Tabs.gravesTab);
        this.func_149675_a(Config.removeEmptyGraves);
        this.setRegistryName("GSGraveStone");
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemStack) {
        NBTTagCompound nbt;
        GraveStoneHelper.replaceGround(world, pos.func_177977_b());
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        world.func_180501_a(pos, state, 2);
        TileEntityGraveStone tileEntity = (TileEntityGraveStone)world.func_175625_s(pos);
        if (tileEntity != null && (nbt = itemStack.func_77978_p()) != null) {
            tileEntity.setGraveType(itemStack.func_77952_i());
            if (nbt.func_74764_b("isLocalized") && nbt.func_74767_n("isLocalized")) {
                tileEntity.getDeathTextComponent().setLocalized();
                if (nbt.func_74764_b("name") && nbt.func_74764_b("KillerName")) {
                    tileEntity.getDeathTextComponent().setName(nbt.func_74779_i("name"));
                    tileEntity.getDeathTextComponent().setKillerName(nbt.func_74779_i("KillerName"));
                }
            }
            tileEntity.getDeathTextComponent().setDeathText(nbt.func_74779_i("DeathText"));
            tileEntity.setAge(nbt.func_74762_e("Age"));
            tileEntity.setEnchanted(nbt.func_74767_n("Enchanted"));
            tileEntity.setMossy(nbt.func_74767_n("Mossy"));
            tileEntity.setPurified(nbt.func_74767_n("Purified"));
            if (nbt.func_74764_b("Sword")) {
                ItemStack sword = new ItemStack(nbt.func_74775_l("Sword"));
                tileEntity.setSword(sword);
                if (sword.func_77948_v()) {
                    tileEntity.setEnchanted(true);
                }
            }
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return GraveStoneHelper.canPlaceBlockAt(world, pos.func_177977_b());
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        if (state.func_177230_c() == GSBlock.GRAVE_STONE) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            TileEntityGraveStone tileEntity = (TileEntityGraveStone)access.func_175625_s(pos);
            EnumGraveType graveType = tileEntity != null ? tileEntity.getGraveType().getGraveType() : EnumGraveType.VERTICAL_PLATE;
            switch (graveType) {
                case VERTICAL_PLATE: {
                    switch (facing) {
                        case SOUTH: {
                            return VP_SOUTH_BB;
                        }
                        case NORTH: {
                            return VP_NORTH_BB;
                        }
                        case EAST: {
                            return VP_EAST_BB;
                        }
                        case WEST: {
                            return VP_WEST_BB;
                        }
                    }
                    break;
                }
                case CROSS: {
                    switch (facing) {
                        case SOUTH: {
                            return CROSS_SOUTH_BB;
                        }
                        case NORTH: {
                            return CROSS_NORTH_BB;
                        }
                        case EAST: {
                            return CROSS_EAST_BB;
                        }
                        case WEST: {
                            return CROSS_WEST_BB;
                        }
                    }
                    break;
                }
                case CELTIC_CROSS: {
                    switch (facing) {
                        case SOUTH: 
                        case NORTH: {
                            return CC_NORTH_SOUTH_BB;
                        }
                        case EAST: 
                        case WEST: {
                            return CC_EAST_WEST_BB;
                        }
                    }
                    break;
                }
                case OBELISK: 
                case CREEPER_STATUE: 
                case VILLAGER_STATUE: {
                    return PL_STATUES_BB;
                }
                case HORIZONTAL_PLATE: {
                    switch (facing) {
                        case SOUTH: 
                        case NORTH: {
                            return HP_NORTH_SOUTH_BB;
                        }
                        case EAST: 
                        case WEST: {
                            return HP_EAST_WEST_BB;
                        }
                    }
                    break;
                }
                case DOG_STATUE: {
                    switch (facing) {
                        case SOUTH: {
                            return DOG_SOUTH_BB;
                        }
                        case NORTH: {
                            return DOG_NORTH_BB;
                        }
                        case EAST: {
                            return DOG_EAST_BB;
                        }
                        case WEST: {
                            return DOG_WEST_BB;
                        }
                    }
                    break;
                }
                case CAT_STATUE: {
                    switch (facing) {
                        case SOUTH: {
                            return CAT_SOUTH_BB;
                        }
                        case NORTH: {
                            return CAT_NORTH_BB;
                        }
                        case EAST: {
                            return CAT_EAST_BB;
                        }
                        case WEST: {
                            return CAT_WEST_BB;
                        }
                    }
                    break;
                }
                case STARVED_CORPSE: 
                case WITHERED_CORPSE: {
                    return CORPSE_BB;
                }
                case SWORD: {
                    switch (facing) {
                        case SOUTH: 
                        case NORTH: {
                            return SWORD_SOUTH_NORTH_BB;
                        }
                        case EAST: 
                        case WEST: {
                            return SWORD_EAST_WEST_BB;
                        }
                    }
                    break;
                }
                case HORSE_STATUE: {
                    switch (facing) {
                        case SOUTH: 
                        case NORTH: {
                            return HS_SOUTH_NORTH_BB;
                        }
                        case EAST: 
                        case WEST: {
                            return HS_EAST_WEST_BB;
                        }
                    }
                }
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityGraveStone tileEntity;
        player.func_71020_j(0.025f);
        if (!world.field_72995_K && !world.restoringBlockSnapshots && (tileEntity = (TileEntityGraveStone)world.func_175625_s(pos)) != null && tileEntity.canBeLooted(player)) {
            GraveStoneHelper.spawnMob(world, pos);
            if (tileEntity.hasFlower()) {
                tileEntity.dropFlower();
            }
            GraveStoneHelper.dropBlock(world, pos, state);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess access, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(GraveStoneHelper.getBlockItemStack(access, pos, state));
        return ret;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess access, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        GraveStoneHelper.spawnMob(world, pos);
    }

    public float func_149638_a(Entity entity) {
        return Float.MAX_VALUE;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityGraveStone te = (TileEntityGraveStone)world.func_175625_s(pos);
        if (te != null) {
            String deathText;
            if (player.field_71071_by.func_70448_g() != null) {
                ItemStack item = player.field_71071_by.func_70448_g();
                if (item.func_77973_b().getToolClasses(item).contains("shovel")) {
                    if (!world.field_72995_K) {
                        if (te.canBeLooted(player)) {
                            player.openGui((Object)ModGraveStone.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                            GSLogger.logInfoGrave(player.func_70005_c_() + " open grave inventory at " + pos.func_177958_n() + "/" + pos.func_177956_o() + "/" + pos.func_177952_p());
                            GraveStoneHelper.replaceGround(world, pos.func_177977_b());
                        } else {
                            player.func_145747_a(new TextComponentTranslation("grave.cant_be_looted", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        }
                    }
                    return false;
                }
                if (te.isMossy()) {
                    if (item.func_77973_b() instanceof ItemShears) {
                        if (!world.field_72995_K) {
                            GraveInventory.dropItem(new ItemStack(Blocks.field_150395_bd, 1), world, pos);
                        }
                        te.setMossy(false);
                        return false;
                    }
                } else if (Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockVine && te.canBeMossy()) {
                    te.setMossy(true);
                    player.field_71071_by.func_70448_g().func_190920_e(player.field_71071_by.func_70448_g().func_190916_E() - 1);
                    return true;
                }
                if (te.hasFlower()) {
                    if (item.func_77973_b() instanceof ItemShears) {
                        if (!world.field_72995_K) {
                            te.dropFlower();
                        }
                        te.setFlower(null);
                        return false;
                    }
                } else if (GraveStoneHelper.FLOWERS.contains(Block.func_149634_a((Item)item.func_77973_b())) && GraveStoneHelper.canFlowerBePlaced(world, pos, item, te)) {
                    te.setFlower(new ItemStack(item.func_77973_b(), 1, item.func_77952_i()));
                    player.field_71071_by.func_70448_g().func_190920_e(player.field_71071_by.func_70448_g().func_190916_E() - 1);
                    return true;
                }
            }
            if (world.field_72995_K && (deathText = te.getDeathTextComponent().getDeathText()).length() != 0) {
                if (te.getDeathTextComponent().isLocalized()) {
                    String name = ModGraveStone.proxy.getLocalizedEntityName(te.getDeathTextComponent().getName());
                    String killerName = ModGraveStone.proxy.getLocalizedEntityName(te.getDeathTextComponent().getKillerName());
                    if (killerName.length() == 0) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation(deathText, new Object[]{name}));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation(deathText, new Object[]{name, killerName}));
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(deathText, new Object[0]));
                }
                if (te.getAge() > 0) {
                    StringBuilder ageStr = new StringBuilder();
                    ageStr.append(ModGraveStone.proxy.getLocalizedString("item.grave.age")).append(" ").append(te.getAge()).append(" ").append(ModGraveStone.proxy.getLocalizedString("item.grave.days"));
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(ageStr.toString(), new Object[0]));
                }
            }
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityGraveStone(world);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        GraveStoneHelper.replaceGround(world, pos.func_177977_b());
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityGraveStone tileEntity = (TileEntityGraveStone)world.func_175625_s(pos);
        if (tileEntity != null) {
            tileEntity.getInventory().dropAllItems();
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntityGraveStone te;
        if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.DOWN, true) && (te = (TileEntityGraveStone)world.func_175625_s(pos)) != null && te.canBeLooted(null)) {
            GraveStoneHelper.dropBlockWithoutInfo(te.func_145831_w(), pos, world.func_180495_p(pos));
            te.func_145831_w().func_175698_g(pos);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntityGraveStone te = (TileEntityGraveStone)world.func_175625_s(pos);
        if (te != null && !te.canBeLooted(player)) {
            player.func_145747_a(new TextComponentTranslation("grave.cant_be_looted", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < EnumGraves.values().length - 1; ++i) {
            ItemStack stack = new ItemStack((Block)this, 1, i);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("Purified", false);
            stack.func_77982_d(nbt);
            list.add((Object)stack);
        }
        for (Item sword : GraveGenerationHelper.swordsList) {
            list.add((Object)GraveStoneHelper.getSwordAsGrave(Item.func_150898_a((Block)this), new ItemStack(sword, 1)));
        }
        for (Item sword : GraveGenerationHelper.swordsList) {
            try {
                ItemStack swordStack = new ItemStack(sword, 1);
                EnchantmentHelper.func_77504_a((Random)new Random(), (ItemStack)swordStack, (int)5, (boolean)true);
                ItemStack graveStoneStack = GraveStoneHelper.getSwordAsGrave(Item.func_150898_a((Block)this), swordStack);
                list.add((Object)graveStoneStack);
            }
            catch (IllegalArgumentException exception) {
                GSLogger.logError("Can't create enchanted sword gravestone");
                exception.printStackTrace();
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)this), 1);
        TileEntityGraveStone tileEntity = (TileEntityGraveStone)world.func_175625_s(pos);
        if (tileEntity != null && itemStack != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            itemStack.func_77964_b(tileEntity.getGraveTypeNum());
            nbt.func_74757_a("Mossy", tileEntity.isMossy());
            itemStack.func_77982_d(nbt);
            if (tileEntity.isSwordGrave()) {
                GraveStoneHelper.addSwordInfo(nbt, tileEntity.getSword());
            }
        }
        return itemStack;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        TileEntityGraveStone tileEntity;
        if (Config.removeEmptyGraves && !world.field_72995_K && (tileEntity = (TileEntityGraveStone)world.func_175625_s(pos)) != null && !tileEntity.isSwordGrave() && tileEntity.isEmpty()) {
            if (Config.showGravesRemovingMessages) {
                GSLogger.logInfoGrave("Remove empty grave at " + pos.func_177958_n() + "/" + pos.func_177956_o() + "/" + pos.func_177952_p());
            }
            world.func_175713_t(pos);
            world.func_175698_g(pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }
}

