/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import nightkosh.gravestone.config.ConfigsHelper;
import nightkosh.gravestone.config.GravesDefaultText;
import nightkosh.gravestone.helper.GraveStoneHelper;

public class Config {
    private static Configuration config;
    private static Config instance;
    private static String path;
    public static final String CATEGORY_COMPATIBILITY = "compatibility";
    public static final String CATEGORY_GRAVES = "graves";
    public static boolean generatePlayerGraves;
    public static boolean generateVillagerGraves;
    public static boolean generatePetGraves;
    public static boolean generateGravesInLava;
    public static int graveItemsCount;
    public static boolean canPlaceGravesEveryWhere;
    public static boolean generateSwordGraves;
    public static boolean removeEmptyGraves;
    public static boolean showGravesRemovingMessages;
    public static boolean onlyOwnerCanLootGrave;
    public static boolean renderGravesFlowers;
    public static boolean vanillaRendererForSwordsGraves;
    public static boolean generateEmptyPlayerGraves;
    public static boolean dropGraveBlockAtDestruction;
    public static List<Integer> playerGravesDimensionalBlackList;
    public static boolean createBackups;
    public static List<GraveStoneHelper.RestrictedArea> restrictGraveGenerationInArea;
    public static boolean storeBattlegearItems;
    public static boolean storeTheCampingModItems;
    public static boolean storeBaublesItems;
    public static boolean storeMaricultureItems;
    public static boolean storeRpgInventoryItems;
    public static boolean storeGalacticraftItems;
    public static boolean storeBackpacksItems;
    public static boolean enableArsMagicaSoulbound;
    public static boolean enableEnderIOSoulbound;
    public static boolean enableTconstructSoulbound;
    public static boolean enableTwilightForestKeeping;
    public static boolean addThaumcraftSwordsAsGravestones;
    public static ArrayList<String> graveNames;
    public static ArrayList<String> graveDogsNames;
    public static ArrayList<String> graveCatsNames;
    public static ArrayList<String> graveDeathMessages;

    private Config(String path, File configFile) {
        config = new Configuration(configFile);
        Config.path = path;
        this.getConfigs();
    }

    public static Config getInstance(String path, String configFile) {
        if (instance == null) {
            return new Config(path, new File(path + configFile));
        }
        return instance;
    }

    public final void getConfigs() {
        config.load();
        Config.gravesConfig();
        Config.compatibilityConfigs();
        config.save();
        this.getGravesText();
    }

    private static void gravesConfig() {
        canPlaceGravesEveryWhere = config.get(CATEGORY_GRAVES, "AllowToPlaceGravesEveryWhere", false).getBoolean(false);
        generatePlayerGraves = config.get(CATEGORY_GRAVES, "GeneratePlayersGraves", true).getBoolean(true);
        generateVillagerGraves = config.get(CATEGORY_GRAVES, "GenerateVillagersGraves", true).getBoolean(true);
        generatePetGraves = config.get(CATEGORY_GRAVES, "GeneratePetsGraves", true).getBoolean(true);
        generateGravesInLava = config.get(CATEGORY_GRAVES, "GenerateGravesInLava", true).getBoolean(true);
        generateSwordGraves = config.get(CATEGORY_GRAVES, "GenerateSwordGraves", true).getBoolean(true);
        generateEmptyPlayerGraves = config.get(CATEGORY_GRAVES, "GenerateEmptyPlayerGraves", true).getBoolean(true);
        onlyOwnerCanLootGrave = config.get(CATEGORY_GRAVES, "OnlyOwnerCanLootGrave", false).getBoolean(false);
        Property graveItemsCountProperty = config.get(CATEGORY_GRAVES, "AmountOfSavedItems", 100);
        graveItemsCountProperty.setComment("This value is amount of items which should be saved in percents. It should be in range of 0 an 100!");
        graveItemsCount = graveItemsCountProperty.getInt();
        if (graveItemsCount > 100 || graveItemsCount < 0) {
            graveItemsCount = 100;
        }
        removeEmptyGraves = config.get(CATEGORY_GRAVES, "RemoveEmptyGraves", false).getBoolean(false);
        showGravesRemovingMessages = config.get(CATEGORY_GRAVES, "ShowGravesRemovingMessages", true).getBoolean(true);
        dropGraveBlockAtDestruction = config.get(CATEGORY_GRAVES, "DropGraveBlockAtDestruction", true).getBoolean(true);
        renderGravesFlowers = config.get(CATEGORY_GRAVES, "RenderGravesFlowers", true).getBoolean(true);
        vanillaRendererForSwordsGraves = config.get(CATEGORY_GRAVES, "VanillaRendererForSwordsGraves", true).getBoolean(true);
        Property restrictGraveGenerationInAreaProperty = config.get(CATEGORY_GRAVES, "RestrictGraveGenerationInArea", "");
        restrictGraveGenerationInAreaProperty.setComment("List of coordinates in which graves generation must be disabled. \"dimension_id,start_x,start_y,start_z,end_x,end_y,end_z;\". Dimension id is optional - it will be set to 0 by default.");
        String ar = restrictGraveGenerationInAreaProperty.getString();
        String[] areas = ar.split(";");
        restrictGraveGenerationInArea = new ArrayList<GraveStoneHelper.RestrictedArea>(areas.length);
        for (String area : areas) {
            GraveStoneHelper.RestrictedArea restrictedArea = GraveStoneHelper.RestrictedArea.getFromString(area);
            if (restrictedArea == null) continue;
            restrictGraveGenerationInArea.add(restrictedArea);
        }
        playerGravesDimensionalBlackList = ConfigsHelper.getDimensionList(config, CATEGORY_GRAVES, "PlayerGravesDimensionalBlackList", "", "List of dimension ids in which player's graves will not be generated at death");
        createBackups = config.get(CATEGORY_GRAVES, "CreateBackups", true).getBoolean();
    }

    private static void compatibilityConfigs() {
        storeTheCampingModItems = config.get(CATEGORY_COMPATIBILITY, "StoreTheCampingModItems", true).getBoolean(true);
        addThaumcraftSwordsAsGravestones = config.get(CATEGORY_COMPATIBILITY, "AddThaumcraftSwordsAsGravestones", true).getBoolean(true);
    }

    private void getGravesText() {
        graveNames = Config.readStringsFromFile(path + "graveNames.txt", GravesDefaultText.NAMES);
        graveDogsNames = Config.readStringsFromFile(path + "graveDogsNames.txt", GravesDefaultText.DOG_NAMES);
        graveCatsNames = Config.readStringsFromFile(path + "graveCatsNames.txt", GravesDefaultText.CAT_NAMES);
        graveDeathMessages = Config.readStringsFromFile(path + "graveDeathMessages.txt", GravesDefaultText.DEATH_TEXT);
    }

    private static ArrayList<String> readStringsFromFile(String fileName, String[] defaultValues) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(defaultValues));
        return list;
    }
}

