/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import nightkosh.gravestone.core.logger.GSLogger;
import org.apache.commons.lang3.StringUtils;

public class ConfigsHelper {
    public static List<Integer> getDimensionList(Configuration config, String category, String ConfigID, String defaultValue, String comment) {
        Property dimensionIdProperty = config.get(category, ConfigID, defaultValue);
        dimensionIdProperty.setComment(comment);
        String ar = dimensionIdProperty.getString();
        String[] ids = ar.split(";");
        ArrayList<Integer> dimensionIds = new ArrayList<Integer>(ids.length);
        for (String id : ids) {
            try {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                dimensionIds.add(Integer.parseInt(id));
            }
            catch (NumberFormatException e) {
                GSLogger.logError("Can't parse Dimension Id list!!!");
                e.printStackTrace();
            }
        }
        if (dimensionIds.isEmpty() && StringUtils.isNotBlank((CharSequence)defaultValue)) {
            try {
                dimensionIds.add(Integer.parseInt(defaultValue));
            }
            catch (NumberFormatException e) {
                GSLogger.logError("Can't parse Dimension Id list!!!");
                e.printStackTrace();
            }
        }
        return dimensionIds;
    }

    public static List<Integer> getDimensionList(Configuration config, String category, String ConfigID, int defaultValue, String comment) {
        return ConfigsHelper.getDimensionList(config, category, ConfigID, Integer.toString(defaultValue), comment);
    }
}

