/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.core;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import nightkosh.gravestone.core.logger.GSLogger;

public class MobHandler {
    public static final String MOBS_SPAWN_TIME_FILE_NAME = "mobsSpawnTime.gs";
    public static final String MOBS_SPAWN_TIME_BACKUP_FILE_NAME = "mobsSpawnTimeBackup.gs";
    private static HashMap<String, Long> mobsSpawnTime = new HashMap();

    public static void clearMobsSpawnTime(Entity entity) {
        mobsSpawnTime.remove(entity.func_110124_au().toString());
        MobHandler.saveMobsSpawnTime(entity.func_130014_f_());
    }

    public static long getAndRemoveSpawnTime(Entity entity) {
        if (mobsSpawnTime.containsKey(entity.func_110124_au().toString())) {
            long time = mobsSpawnTime.get(entity.func_110124_au().toString());
            MobHandler.clearMobsSpawnTime(entity);
            return time;
        }
        return entity.func_130014_f_().func_72820_D();
    }

    public static long getMobSpawnTime(Entity entity) {
        if (!mobsSpawnTime.containsKey(entity.func_110124_au().toString())) {
            mobsSpawnTime.put(entity.func_110124_au().toString(), entity.func_130014_f_().func_72820_D());
            MobHandler.saveMobsSpawnTime(entity.func_130014_f_());
        }
        return mobsSpawnTime.get(entity.func_110124_au().toString());
    }

    public static void setMobSpawnTime(Entity entity) {
        if (!mobsSpawnTime.containsKey(entity.func_110124_au().toString())) {
            mobsSpawnTime.put(entity.func_110124_au().toString(), entity.func_130014_f_().func_72820_D());
            MobHandler.saveMobsSpawnTime(entity.func_130014_f_());
        }
    }

    public static void loadMobsSpawnTime(World world) {
        try {
            File file = new File(world.func_72860_G().func_75765_b(), MOBS_SPAWN_TIME_FILE_NAME);
            File backup = new File(world.func_72860_G().func_75765_b(), MOBS_SPAWN_TIME_BACKUP_FILE_NAME);
            NBTTagCompound data = null;
            boolean save = false;
            if (file != null && file.exists()) {
                data = MobHandler.getDataFromFile(file);
            }
            if (file == null || !file.exists() || data == null || data.func_82582_d()) {
                GSLogger.logError("Data not found. Trying to load backup data.");
                if (backup != null && backup.exists()) {
                    data = MobHandler.getDataFromFile(backup);
                    save = true;
                }
            }
            if (data != null) {
                Set keySet = data.func_150296_c();
                for (String tagName : keySet) {
                    mobsSpawnTime.put(tagName, data.func_74763_f(tagName));
                }
                if (save) {
                    MobHandler.saveMobsSpawnTime(world);
                }
            }
        }
        catch (Exception e) {
            GSLogger.logError("Error loading mobs spawn time");
            e.printStackTrace();
        }
    }

    public static void saveMobsSpawnTime(World world) {
        block12: {
            if (world != null && !world.field_72995_K && mobsSpawnTime != null) {
                try {
                    File file = new File(world.func_72860_G().func_75765_b(), MOBS_SPAWN_TIME_FILE_NAME);
                    File backup = new File(world.func_72860_G().func_75765_b(), MOBS_SPAWN_TIME_BACKUP_FILE_NAME);
                    if (file != null && file.exists()) {
                        try {
                            Files.copy((File)file, (File)backup);
                        }
                        catch (Exception e) {
                            GSLogger.logError("Could not backup old spawn time file");
                        }
                    }
                    try {
                        if (file != null) {
                            NBTTagCompound data = new NBTTagCompound();
                            for (Map.Entry<String, Long> entry : mobsSpawnTime.entrySet()) {
                                if (entry == null) continue;
                                data.func_74772_a(entry.getKey(), entry.getValue().longValue());
                            }
                            FileOutputStream fileoutputstream = new FileOutputStream(file);
                            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)fileoutputstream);
                            fileoutputstream.close();
                        }
                    }
                    catch (Exception e) {
                        GSLogger.logError("Could not save spawn time file");
                        e.printStackTrace();
                        if (!file.exists()) break block12;
                        try {
                            file.delete();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception e) {
                    GSLogger.logError("Error saving mobs spawn time");
                    e.printStackTrace();
                }
            }
        }
    }

    private static NBTTagCompound getDataFromFile(File file) {
        NBTTagCompound data = null;
        try {
            FileInputStream fileinputstream = new FileInputStream(file);
            data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
            fileinputstream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }
}

