/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.core.commands;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import nightkosh.gravestone.core.commands.ISubCommand;
import nightkosh.gravestone.core.commands.SubCommandCommandsList;
import nightkosh.gravestone.core.commands.SubCommandCustomGraveItems;
import nightkosh.gravestone.core.commands.SubCommandGravePosition;
import nightkosh.gravestone.core.commands.SubCommandRestoreItems;

public class Command
extends CommandBase {
    private static final SubCommandCustomGraveItems CUSTOM_GRAVES_ITEMS = new SubCommandCustomGraveItems();
    private static final SubCommandCommandsList COMMANDS_LIST = new SubCommandCommandsList();
    private static final SubCommandGravePosition GRAVE_POS = new SubCommandGravePosition();
    private static final SubCommandRestoreItems GRAVE_ITEMS = new SubCommandRestoreItems();
    public static final String MAIN_COMMAND_NAME = "/GS ";
    public static final String HELP = "Type \"" + COMMANDS_LIST.getCommandUsage() + "\" for commands list";
    public static final List<ISubCommand> ADDITIONAL_COMMANDS_LIST = new ArrayList<ISubCommand>();

    public String func_71517_b() {
        return "GS";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/" + this.func_71517_b() + " <command> <command parameters> (" + HELP + ")";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 1) {
            String command;
            switch (command = args[0]) {
                case "fill_grave": {
                    CUSTOM_GRAVES_ITEMS.execute(server, sender, args);
                    break;
                }
                case "commands_list": {
                    COMMANDS_LIST.execute(server, sender, args);
                    break;
                }
                case "grave_pos": {
                    GRAVE_POS.execute(server, sender, args);
                    break;
                }
                case "restore_items": {
                    GRAVE_ITEMS.execute(server, sender, args);
                    break;
                }
                default: {
                    boolean unknownCommand = true;
                    for (ISubCommand additionalCommand : ADDITIONAL_COMMANDS_LIST) {
                        if (!additionalCommand.getCommandName().equals(command)) continue;
                        additionalCommand.execute(server, sender, args);
                        unknownCommand = false;
                        break;
                    }
                    if (unknownCommand) {
                        sender.func_145747_a(new TextComponentTranslation("Unknown command!", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        sender.func_145747_a(new TextComponentTranslation(HELP, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            sender.func_145747_a(new TextComponentTranslation(HELP, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        }
    }

    public static void addCommand(ISubCommand command) {
        if (command != null) {
            ADDITIONAL_COMMANDS_LIST.add(command);
        }
    }
}

