/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.core.event;

import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nightkosh.gravestone.api.death_handler.ICatDeathHandler;
import nightkosh.gravestone.api.death_handler.ICustomEntityDeathHandler;
import nightkosh.gravestone.api.death_handler.IDogDeathHandler;
import nightkosh.gravestone.api.death_handler.IHorseDeathHandler;
import nightkosh.gravestone.api.death_handler.IPlayerDeathHandler;
import nightkosh.gravestone.api.death_handler.IVillagerDeathHandler;
import nightkosh.gravestone.config.Config;
import nightkosh.gravestone.core.MobHandler;
import nightkosh.gravestone.core.logger.GravesLogger;
import nightkosh.gravestone.helper.GraveGenerationHelper;
import nightkosh.gravestone.helper.api.APIGraveGeneration;

public class EventsHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityLivingDeath(LivingDeathEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (!Config.generateGravesInLava && event.getSource().field_76373_n.equals("lava")) {
                return;
            }
            if (Config.generateVillagerGraves && event.getEntity() instanceof EntityVillager) {
                EntityVillager villager = (EntityVillager)event.getEntity();
                for (IVillagerDeathHandler villagerDeathHandler : APIGraveGeneration.VILLAGER_DEATH_HANDLERS) {
                    if (!villagerDeathHandler.cancelGraveGeneration(villager, event.getSource())) continue;
                    return;
                }
                GraveGenerationHelper.createVillagerGrave(villager, event.getSource());
                return;
            }
            if (Config.generatePetGraves) {
                if (event.getEntity() instanceof EntityTameable) {
                    if (event.getEntity() instanceof EntityWolf) {
                        EntityWolf dog = (EntityWolf)event.getEntity();
                        for (IDogDeathHandler dogDeathHandler : APIGraveGeneration.DOG_DEATH_HANDLERS) {
                            if (!dogDeathHandler.cancelGraveGeneration(dog, event.getSource())) continue;
                            return;
                        }
                        GraveGenerationHelper.createDogGrave(dog, event.getSource());
                        return;
                    }
                    if (event.getEntity() instanceof EntityOcelot) {
                        EntityOcelot cat = (EntityOcelot)event.getEntity();
                        for (ICatDeathHandler catDeathHandler : APIGraveGeneration.CAT_DEATH_HANDLERS) {
                            if (!catDeathHandler.cancelGraveGeneration(cat, event.getSource())) continue;
                            return;
                        }
                        GraveGenerationHelper.createCatGrave(cat, event.getSource());
                        return;
                    }
                } else if (event.getEntity() instanceof AbstractHorse) {
                    AbstractHorse horse = (AbstractHorse)event.getEntity();
                    for (IHorseDeathHandler horseDeathHandler : APIGraveGeneration.HORSE_DEATH_HANDLERS) {
                        if (!horseDeathHandler.cancelGraveGeneration(horse, event.getSource())) continue;
                        return;
                    }
                    GraveGenerationHelper.createHorseGrave(horse, event.getSource());
                    return;
                }
            }
            for (ICustomEntityDeathHandler customEntityDeathHandler : APIGraveGeneration.CUSTOM_ENTITY_DEATH_HANDLERS) {
                if (!event.getEntity().getClass().equals(customEntityDeathHandler.getEntityClass()) || !customEntityDeathHandler.canGenerateGrave(event.getEntity(), event.getSource())) continue;
                GraveGenerationHelper.createCustomGrave(event.getEntity(), event, customEntityDeathHandler);
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDrops(PlayerDropsEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (!Config.generateGravesInLava && event.getSource().field_76373_n.equals("lava")) {
                return;
            }
            if (Config.generatePlayerGraves && event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntity();
                if (!Config.playerGravesDimensionalBlackList.contains(player.field_71093_bK)) {
                    for (IPlayerDeathHandler playerDeathHandler : APIGraveGeneration.PLAYER_DEATH_HANDLERS) {
                        if (!playerDeathHandler.cancelGraveGeneration(player, event.getSource())) continue;
                        return;
                    }
                    GraveGenerationHelper.createPlayerGrave(player, event.getDrops(), event.getSource(), MobHandler.getAndRemoveSpawnTime((Entity)player));
                }
            }
        }
    }

    @SubscribeEvent
    public void entityJoinWorldEvent(EntityJoinWorldEvent event) {
        Entity entity;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && ((entity = event.getEntity()) instanceof EntityVillager || entity instanceof EntityWolf || entity instanceof EntityOcelot || entity instanceof EntityHorse)) {
            MobHandler.setMobSpawnTime(event.getEntity());
        }
    }

    @SubscribeEvent
    public void worldLoading(WorldEvent.Load event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            MobHandler.loadMobsSpawnTime(event.getWorld());
            GravesLogger.setWorldDirectory(event.getWorld().func_72860_G().func_75765_b());
        }
    }
}

