/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import nightkosh.gravestone.api.IGraveStoneHelper;
import nightkosh.gravestone.api.death_handler.ICustomEntityDeathHandler;
import nightkosh.gravestone.api.grave.EnumGraveMaterial;
import nightkosh.gravestone.api.grave.EnumGraveType;
import nightkosh.gravestone.api.grave_items.ICatItems;
import nightkosh.gravestone.api.grave_items.IDogItems;
import nightkosh.gravestone.api.grave_items.IHorseItems;
import nightkosh.gravestone.api.grave_items.IPlayerItems;
import nightkosh.gravestone.api.grave_items.IVillagerItems;
import nightkosh.gravestone.api.grave_position.IGravePositionHandler;
import nightkosh.gravestone.block.BlockGraveStone;
import nightkosh.gravestone.block.enums.EnumGraves;
import nightkosh.gravestone.config.Config;
import nightkosh.gravestone.core.GSBlock;
import nightkosh.gravestone.core.MobHandler;
import nightkosh.gravestone.core.logger.GSLogger;
import nightkosh.gravestone.helper.BackupsHandler;
import nightkosh.gravestone.helper.GraveStoneHelper;
import nightkosh.gravestone.helper.api.APIGraveGeneration;
import nightkosh.gravestone.inventory.GraveInventory;
import nightkosh.gravestone.tileentity.DeathMessageInfo;
import nightkosh.gravestone.tileentity.TileEntityGraveStone;

public class GraveGenerationHelper
implements IGraveStoneHelper {
    public static final IGraveStoneHelper INSTANCE = new GraveGenerationHelper();
    protected static final Random rand = new Random();
    public static ArrayList<Item> swordsList = new ArrayList<Item>(Arrays.asList(Items.field_151041_m, Items.field_151052_q, Items.field_151040_l, Items.field_151010_B, Items.field_151048_u));
    private static final EnumGraveType[] GENERATED_PLAYER_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.VERTICAL_PLATE, EnumGraveType.CROSS, EnumGraveType.OBELISK, EnumGraveType.CELTIC_CROSS, EnumGraveType.HORIZONTAL_PLATE};
    private static final EnumGraveType[] STARVED_PLAYER_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.STARVED_CORPSE};
    private static final EnumGraveType[] WITHERED_PLAYER_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.WITHERED_CORPSE};
    private static final EnumGraveType[] GENERATED_VILLAGERS_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.VILLAGER_STATUE};
    private static final EnumGraveType[] GENERATED_DOGS_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.DOG_STATUE};
    private static final EnumGraveType[] GENERATED_CAT_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.CAT_STATUE};
    private static final EnumGraveType[] GENERATED_HORSE_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.HORSE_STATUE};
    private static final EnumGraveType[] GENERATED_CREEPER_STATUES_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.CREEPER_STATUE};

    @Override
    public void addSwordToSwordsList(Item sword) {
        if (sword != null) {
            swordsList.add(sword);
        }
    }

    private static void addNonEmptyItems(List<ItemStack> items, NonNullList<ItemStack> itemsToAdd) {
        for (ItemStack stack : itemsToAdd) {
            if (stack.func_190926_b()) continue;
            items.add(stack);
        }
    }

    public static void createPlayerGrave(EntityPlayer player, List<EntityItem> entityItems, DamageSource damageSource, long spawnTime) {
        if (player.func_130014_f_() != null && !player.func_130014_f_().func_82736_K().func_82766_b("keepInventory") && Config.graveItemsCount > 0 && !GraveGenerationHelper.isInRestrictedArea(player.func_130014_f_(), player.func_180425_c())) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(41);
            for (EntityItem entityItem : entityItems) {
                items.add(entityItem.func_92059_d());
                entityItem.func_70106_y();
            }
            for (IPlayerItems additionalItems : APIGraveGeneration.PLAYER_ITEMS) {
                try {
                    List<ItemStack> modItems = additionalItems.addItems(player, damageSource);
                    if (modItems == null || modItems.isEmpty() || modItems.size() == 0) continue;
                    items.addAll(modItems);
                }
                catch (Exception e) {
                    GSLogger.logError("Compatibility error occurred in additionalItems.addItems");
                    e.printStackTrace();
                }
            }
            for (IPlayerItems additionalItems : APIGraveGeneration.PLAYER_ITEMS) {
                try {
                    additionalItems.getItems(player, damageSource, items);
                }
                catch (Exception e) {
                    GSLogger.logError("Compatibility error occurred in additionalItems.getItems");
                    e.printStackTrace();
                }
            }
            if (Config.generateEmptyPlayerGraves || items.size() != 0) {
                GraveGenerationHelper.createGrave((Entity)player, damageSource, items, EnumGraveTypeByEntity.PLAYER_GRAVES, false, spawnTime);
            }
        } else if (Config.generateEmptyPlayerGraves) {
            GraveGenerationHelper.createGrave((Entity)player, damageSource, null, EnumGraveTypeByEntity.PLAYER_GRAVES, false, spawnTime);
        }
    }

    public static void createVillagerGrave(EntityVillager villager, DamageSource damageSource) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(5);
        for (IVillagerItems additionalItems : APIGraveGeneration.VILLAGER_ITEMS) {
            items.addAll(additionalItems.addItems(villager, damageSource));
        }
        IItemHandler itemHandler = (IItemHandler)villager.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, villager.func_174811_aO());
        if (villager.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, villager.func_174811_aO())) {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack stack = itemHandler.extractItem(slot, 100500, false);
                if (stack == null || stack.func_190926_b()) continue;
                items.add(stack);
            }
        }
        long spawnTime = MobHandler.getAndRemoveSpawnTime((Entity)villager);
        GraveGenerationHelper.createGrave((Entity)villager, damageSource, items, EnumGraveTypeByEntity.VILLAGERS_GRAVES, true, spawnTime);
    }

    public static void createDogGrave(EntityWolf dog, DamageSource damageSource) {
        if (dog.func_70909_n()) {
            long spawnTime = MobHandler.getAndRemoveSpawnTime((Entity)dog);
            GraveGenerationHelper.createGrave((Entity)dog, damageSource, GraveGenerationHelper.getDogsItems(dog, damageSource), EnumGraveTypeByEntity.DOGS_GRAVES, false, spawnTime);
        }
    }

    public static void createCatGrave(EntityOcelot cat, DamageSource damageSource) {
        if (cat.func_70909_n()) {
            long spawnTime = MobHandler.getAndRemoveSpawnTime((Entity)cat);
            GraveGenerationHelper.createGrave((Entity)cat, damageSource, GraveGenerationHelper.getCatsItems(cat, damageSource), EnumGraveTypeByEntity.CATS_GRAVES, false, spawnTime);
        }
    }

    private static List<ItemStack> getDogsItems(EntityWolf dog, DamageSource damageSource) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(5);
        for (IDogItems additionalItems : APIGraveGeneration.DOG_ITEMS) {
            items.addAll(additionalItems.addItems(dog, damageSource));
        }
        IItemHandler itemHandler = (IItemHandler)dog.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dog.func_174811_aO());
        if (dog.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dog.func_174811_aO())) {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack stack = itemHandler.extractItem(slot, 100500, false);
                if (stack == null || stack.func_190926_b()) continue;
                items.add(stack);
            }
        }
        return items;
    }

    private static List<ItemStack> getCatsItems(EntityOcelot cat, DamageSource damageSource) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(5);
        for (ICatItems additionalItems : APIGraveGeneration.CAT_ITEMS) {
            items.addAll(additionalItems.addItems(cat, damageSource));
        }
        IItemHandler itemHandler = (IItemHandler)cat.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, cat.func_174811_aO());
        if (cat.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, cat.func_174811_aO())) {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack stack = itemHandler.extractItem(slot, 100500, false);
                if (stack == null || stack.func_190926_b()) continue;
                items.add(stack);
            }
        }
        return items;
    }

    public static void createHorseGrave(AbstractHorse horse, DamageSource damageSource) {
        if (horse.func_110248_bS()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.addAll(GraveGenerationHelper.getHorseItems(horse));
            for (IHorseItems additionalItems : APIGraveGeneration.HORSE_ITEMS) {
                items.addAll(additionalItems.addItems(horse, damageSource));
            }
            long spawnTime = MobHandler.getAndRemoveSpawnTime((Entity)horse);
            GraveGenerationHelper.createGrave((Entity)horse, damageSource, items, EnumGraveTypeByEntity.HORSE_GRAVES, false, spawnTime);
        }
    }

    private static List<ItemStack> getHorseItems(AbstractHorse horse) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        IItemHandler itemHandler = (IItemHandler)horse.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, horse.func_174811_aO());
        if (horse.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, horse.func_174811_aO())) {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack stack = itemHandler.extractItem(slot, 100500, false);
                if (stack == null || stack.func_190926_b()) continue;
                items.add(stack);
            }
        }
        return items;
    }

    public static void createGrave(Entity entity, DamageSource damageSource, List<ItemStack> items, EnumGraveTypeByEntity graveTypeByEntity, boolean isVillager, long spawnTime) {
        if (GraveGenerationHelper.isInRestrictedArea(entity.func_130014_f_(), entity.func_180425_c())) {
            GSLogger.logInfo("Can't generate " + entity.func_70005_c_() + "'s grave in restricted area. " + entity.func_180425_c().toString());
            if (items != null) {
                items.stream().filter(item -> item != null).forEach(item -> GraveInventory.dropItem(item, entity.func_130014_f_(), entity.func_180425_c()));
            }
        } else {
            int age = (int)(entity.func_130014_f_().func_72820_D() - spawnTime) / 24000;
            BlockPos pos = new BlockPos(entity.field_70165_t, (double)Math.round(entity.field_70163_u), entity.field_70161_v - 1.0);
            GraveInfoOnDeath graveInfo = GraveGenerationHelper.getGraveOnDeath(entity.func_130014_f_(), pos, entity, graveTypeByEntity, items, age, damageSource);
            DeathMessageInfo messageInfo = GraveGenerationHelper.getDeathMessage((EntityLivingBase)entity, damageSource.field_76373_n, isVillager);
            GraveGenerationHelper.createOnDeath(entity, entity.func_130014_f_(), pos, messageInfo, items, age, graveInfo, damageSource);
        }
    }

    public static void createCustomGrave(Entity entity, LivingDeathEvent event, ICustomEntityDeathHandler customEntityDeathHandler) {
        if (GraveGenerationHelper.isInRestrictedArea(entity.func_130014_f_(), entity.func_180425_c())) {
            GSLogger.logInfo("Can't generate " + entity.func_70005_c_() + "'s grave in restricted area. " + entity.func_180425_c().toString());
            if (customEntityDeathHandler.getItems() != null) {
                customEntityDeathHandler.getItems().stream().filter(item -> item != null).forEach(item -> GraveInventory.dropItem(item, entity.func_130014_f_(), entity.func_180425_c()));
            }
        } else {
            int age = customEntityDeathHandler.getAge();
            GraveInfoOnDeath graveInfo = new GraveInfoOnDeath();
            graveInfo.setGrave(EnumGraves.getByTypeAndMaterial(customEntityDeathHandler.getGraveType(entity, event.getSource()), customEntityDeathHandler.getGraveMaterial(entity, event.getSource())));
            graveInfo.setSword(customEntityDeathHandler.getSword());
            graveInfo.setEnchanted(customEntityDeathHandler.isEnchanted(entity, event.getSource()));
            graveInfo.setMossy(customEntityDeathHandler.isMossy(entity, event.getSource()));
            BlockPos pos = new BlockPos(entity.field_70165_t, (double)Math.round(entity.field_70163_u), entity.field_70161_v - 1.0);
            DeathMessageInfo messageInfo = GraveGenerationHelper.getDeathMessage((EntityLivingBase)entity, event.getSource().field_76373_n, false);
            GraveGenerationHelper.createOnDeath(entity, entity.func_130014_f_(), pos, messageInfo, customEntityDeathHandler.getItems(), age, graveInfo, event.getSource());
        }
    }

    private static GraveInfoOnDeath getGraveOnDeath(World world, BlockPos pos, Entity entity, EnumGraveTypeByEntity graveTypeByEntity, List<ItemStack> items, int age, DamageSource damageSource) {
        GraveInfoOnDeath graveInfo = new GraveInfoOnDeath();
        if (GraveGenerationHelper.chooseGraveTypeByAgeOrLevel(entity, graveTypeByEntity, age)) {
            EnumGraveMaterial material = GraveGenerationHelper.getGraveMaterialByAgeOrLevel(entity, age, graveTypeByEntity);
            EnumGraveType[] type = GraveGenerationHelper.isExplosionDamage(damageSource) ? GENERATED_CREEPER_STATUES_GRAVES_TYPES : GraveGenerationHelper.getDefaultGraveTypes(graveTypeByEntity);
            graveInfo.grave = GraveGenerationHelper.getGraveType(type, material);
        } else {
            graveInfo.grave = GraveGenerationHelper.getGraveByDeath(damageSource, graveTypeByEntity, entity, age);
            if (graveInfo.grave == null) {
                ItemStack sword;
                if (graveTypeByEntity == EnumGraveTypeByEntity.PLAYER_GRAVES && Config.generateSwordGraves && world.field_73012_v.nextInt(4) == 0 && graveTypeByEntity.equals((Object)EnumGraveTypeByEntity.PLAYER_GRAVES) && (sword = GraveGenerationHelper.getSwordFromInventory(items)) != null) {
                    graveInfo.sword = sword;
                    graveInfo.grave = EnumGraves.SWORD;
                }
                if (graveInfo.grave == null) {
                    graveInfo.grave = GraveGenerationHelper.getGraveTypeByBiomes(world, pos, graveTypeByEntity, damageSource);
                }
            }
        }
        graveInfo.setMossy(GraveGenerationHelper.isMossyGrave(world, pos, graveInfo.grave.getMaterial()));
        graveInfo.setEnchanted(INSTANCE.isMagicDamage(damageSource));
        return graveInfo;
    }

    private static void createOnDeath(Entity entity, World world, BlockPos pos, DeathMessageInfo deathInfo, List<ItemStack> items, int age, GraveInfoOnDeath graveInfo, DamageSource damageSource) {
        BlockPos newPos = null;
        EnumFacing direction = null;
        World newWorld = null;
        boolean hasCustomLocation = false;
        try {
            for (IGravePositionHandler position : APIGraveGeneration.GRAVE_POSITION_HANDLERS) {
                if (!position.condition(world, entity, pos, damageSource) || (newPos = position.gravePosition(world, entity, pos, damageSource)) == null) continue;
                hasCustomLocation = true;
                direction = position.graveFacing(world, entity, pos, damageSource);
                newWorld = position.getWorld(world, entity, pos, damageSource);
                break;
            }
        }
        catch (Exception e) {
            GSLogger.logError("Can't get custom position of grave!");
        }
        if (hasCustomLocation) {
            GSLogger.logInfo("Position of grave was changed by other mod");
        } else {
            direction = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3));
            newPos = GraveGenerationHelper.findPlaceForGrave(world, entity, pos, damageSource);
            newWorld = world;
        }
        if (Config.createBackups && entity instanceof EntityPlayer) {
            try {
                BackupsHandler.BACKUPS.put(entity.func_70005_c_(), new BackupsHandler.Backup(newWorld.field_73011_w.getDimension(), newPos, items));
            }
            catch (Exception e) {
                GSLogger.logError("Can't create backup!");
            }
        }
        if (newPos != null) {
            newWorld.func_180501_a(newPos, GSBlock.GRAVE_STONE.func_176223_P().func_177226_a((IProperty)BlockGraveStone.FACING, direction), 2);
            TileEntityGraveStone tileEntity = (TileEntityGraveStone)newWorld.func_175625_s(newPos);
            if (tileEntity != null) {
                if (graveInfo.getSword() != null) {
                    tileEntity.setSword(graveInfo.getSword());
                }
                tileEntity.getDeathTextComponent().setLocalized();
                tileEntity.getDeathTextComponent().setName(deathInfo.getName());
                tileEntity.getDeathTextComponent().setDeathText(deathInfo.getDeathMessage());
                tileEntity.getDeathTextComponent().setKillerName(deathInfo.getKillerName());
                tileEntity.getInventory().setItems(items);
                tileEntity.setGraveType(graveInfo.getGrave().ordinal());
                tileEntity.setAge(age);
                tileEntity.setEnchanted(graveInfo.isEnchanted());
                tileEntity.setMossy(graveInfo.isMossy());
                if (entity instanceof EntityPlayer) {
                    tileEntity.setOwner(entity.func_110124_au().toString());
                } else if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n() && ((EntityTameable)entity).func_70902_q() != null) {
                    tileEntity.setOwner(((EntityTameable)entity).func_70902_q().func_110124_au().toString());
                }
            }
            GSLogger.logInfoGrave("Create " + deathInfo.getName() + "'s grave at " + newPos.func_177958_n() + "x" + newPos.func_177956_o() + "x" + newPos.func_177952_p());
        } else {
            ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)GSBlock.GRAVE_STONE), 1);
            itemStack.func_77964_b(graveInfo.getGrave().ordinal());
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("isLocalized", true);
            nbt.func_74778_a("name", deathInfo.getName());
            nbt.func_74778_a("DeathText", deathInfo.getDeathMessage());
            nbt.func_74778_a("KillerName", deathInfo.getKillerNameForTE());
            nbt.func_74757_a("Enchanted", graveInfo.isEnchanted());
            nbt.func_74757_a("Mossy", graveInfo.isMossy());
            nbt.func_74768_a("Age", age);
            if (graveInfo.getGrave() == EnumGraves.SWORD) {
                GraveStoneHelper.addSwordInfo(nbt, graveInfo.getSword());
            }
            itemStack.func_77982_d(nbt);
            GraveInventory.dropItem(itemStack, world, pos);
            if (items != null) {
                for (ItemStack item : items) {
                    if (item == null) continue;
                    GraveInventory.dropItem(item, world, pos);
                }
            }
            GSLogger.logInfoGrave("Can not create " + deathInfo.getName() + "'s grave at " + pos.func_177958_n() + "x" + pos.func_177956_o() + "x" + pos.func_177952_p());
        }
    }

    private static DeathMessageInfo getDeathMessage(EntityLivingBase entity, String damageType, boolean isVillager) {
        EntityLivingBase killer = entity.func_94060_bK();
        String shortString = "death.attack." + damageType;
        String fullString = shortString + ".player";
        String entityName = entity.func_70005_c_();
        if (entityName == null) {
            entityName = "entity." + EntityList.func_75621_b((Entity)entity) + ".name";
        }
        if (killer != null) {
            String killerName;
            if (killer instanceof EntityPlayer) {
                killerName = killer.func_145748_c_().func_150254_d();
                if (isVillager) {
                    GSLogger.logInfoGrave("Villager was killed by " + killerName);
                }
            } else {
                killerName = EntityList.func_75621_b((Entity)killer);
                killerName = killerName == null ? "entity.generic.name" : "entity." + killerName + ".name";
            }
            if (I18n.func_94522_b((String)fullString)) {
                return new DeathMessageInfo(entityName, fullString, killerName);
            }
            return new DeathMessageInfo(entityName, shortString, killerName);
        }
        return new DeathMessageInfo(entityName, shortString, null);
    }

    private static boolean isInRestrictedArea(World world, BlockPos pos) {
        return Config.restrictGraveGenerationInArea.stream().anyMatch(area -> area.isInArea(world, pos));
    }

    @Override
    public boolean isMagicDamage(DamageSource damageSource) {
        return DamageSource.field_76376_m.equals(damageSource) || damageSource.field_76373_n.toLowerCase().contains("magic");
    }

    @Override
    public boolean isMossyGrave(World world, BlockPos pos, EnumGraveMaterial graveMaterial, EnumGraveType graveType) {
        return GraveGenerationHelper.isMossyGrave(world, pos, EnumGraves.getByTypeAndMaterial(graveType, graveMaterial).getMaterial());
    }

    public static boolean isMossyGrave(World world, BlockPos pos, EnumGraveMaterial graveMaterial) {
        Set biomeTypesList = BiomeDictionary.getTypes((Biome)world.func_180494_b(pos));
        return graveMaterial != EnumGraveMaterial.OTHER && (biomeTypesList.contains(BiomeDictionary.Type.JUNGLE) || biomeTypesList.contains(BiomeDictionary.Type.SWAMP));
    }

    public static boolean chooseGraveTypeByAgeOrLevel(Entity entity, EnumGraveTypeByEntity graveTypeByEntity, int age) {
        if (graveTypeByEntity == EnumGraveTypeByEntity.PLAYER_GRAVES) {
            return ((EntityPlayer)entity).field_71068_ca >= 15;
        }
        return age >= 30;
    }

    public static EnumGraveMaterial getGraveMaterialByAgeOrLevel(Entity entity, int age, EnumGraveTypeByEntity graveTypeByEntity) {
        if (graveTypeByEntity == EnumGraveTypeByEntity.PLAYER_GRAVES) {
            return INSTANCE.getGraveMaterialByLevel(((EntityPlayer)entity).field_71068_ca);
        }
        return INSTANCE.getGraveMaterialByAge(age);
    }

    @Override
    public EnumGraveMaterial getGraveMaterialByLevel(int level) {
        if (level >= 65) {
            return EnumGraveMaterial.EMERALD;
        }
        if (level >= 55) {
            return EnumGraveMaterial.DIAMOND;
        }
        if (level >= 45) {
            return EnumGraveMaterial.REDSTONE;
        }
        if (level >= 35) {
            return EnumGraveMaterial.GOLD;
        }
        if (level >= 25) {
            return EnumGraveMaterial.LAPIS;
        }
        return EnumGraveMaterial.IRON;
    }

    @Override
    public EnumGraveMaterial getGraveMaterialByAge(int age) {
        if (age > 180) {
            return EnumGraveMaterial.EMERALD;
        }
        if (age > 150) {
            return EnumGraveMaterial.DIAMOND;
        }
        if (age > 120) {
            return EnumGraveMaterial.REDSTONE;
        }
        if (age > 90) {
            return EnumGraveMaterial.GOLD;
        }
        if (age > 60) {
            return EnumGraveMaterial.LAPIS;
        }
        return EnumGraveMaterial.IRON;
    }

    protected static EnumGraveType[] getDefaultGraveTypes(EnumGraveTypeByEntity graveTypeByEntity) {
        switch (graveTypeByEntity) {
            case VILLAGERS_GRAVES: {
                return GENERATED_VILLAGERS_GRAVES_TYPES;
            }
            case DOGS_GRAVES: {
                return GENERATED_DOGS_GRAVES_TYPES;
            }
            case CATS_GRAVES: {
                return GENERATED_CAT_GRAVES_TYPES;
            }
            case HORSE_GRAVES: {
                return GENERATED_HORSE_GRAVES_TYPES;
            }
        }
        return GENERATED_PLAYER_GRAVES_TYPES;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EnumGraves getGraveByDeath(DamageSource damageSource, EnumGraveTypeByEntity graveTypeByEntity, Entity entity, int age) {
        EnumGraveMaterial material;
        EnumGraveType[] graveTypes = null;
        if (GraveGenerationHelper.isFireDamage(damageSource, damageSource.field_76373_n) || GraveGenerationHelper.isLavaDamage(damageSource, damageSource.field_76373_n)) {
            material = EnumGraveMaterial.OBSIDIAN;
        } else {
            if (graveTypeByEntity != EnumGraveTypeByEntity.PLAYER_GRAVES) return null;
            if (DamageSource.field_76366_f.equals(damageSource)) {
                graveTypes = STARVED_PLAYER_GRAVES_TYPES;
                material = EnumGraveMaterial.OTHER;
            } else {
                if (!DamageSource.field_82727_n.equals(damageSource)) return null;
                graveTypes = WITHERED_PLAYER_GRAVES_TYPES;
                material = EnumGraveMaterial.OTHER;
            }
        }
        if (graveTypes != null) return GraveGenerationHelper.getGraveType(graveTypes, material);
        graveTypes = GraveGenerationHelper.getDefaultGraveTypes(graveTypeByEntity);
        return GraveGenerationHelper.getGraveType(graveTypes, material);
    }

    public static boolean isFireDamage(DamageSource damageSource, String damageType) {
        return DamageSource.field_76372_a.equals(damageSource) || DamageSource.field_76370_b.equals(damageSource) || GraveGenerationHelper.isFireDamage(damageType);
    }

    public static boolean isFireDamage(String damageType) {
        return damageType.toLowerCase().contains("nfire");
    }

    public static boolean isLavaDamage(DamageSource damageSource, String damageType) {
        return DamageSource.field_76371_c.equals(damageSource) || GraveGenerationHelper.isLavaDamage(damageType);
    }

    public static boolean isLavaDamage(String damageType) {
        return damageType.toLowerCase().contains("lava");
    }

    public static boolean isMagicDamage(String damageText) {
        return damageText.toLowerCase().contains("magic");
    }

    public static boolean isExplosionDamage(DamageSource damageSource) {
        return GraveGenerationHelper.isBlastDamage(damageSource.field_76373_n) || GraveGenerationHelper.isFireballDamage(damageSource.field_76373_n);
    }

    public static boolean isBlastDamage(String damageType) {
        return damageType.toLowerCase().contains("explosion");
    }

    public static boolean isFireballDamage(String damageType) {
        return damageType.toLowerCase().contains("fireball");
    }

    public static EnumGraveMaterial[] getGraveMaterialByBiomes(World world, BlockPos pos) {
        Set biomeTypesList = BiomeDictionary.getTypes((Biome)world.func_180494_b(pos));
        ArrayList<EnumGraveMaterial> materials = new ArrayList<EnumGraveMaterial>();
        if (biomeTypesList.contains(BiomeDictionary.Type.SANDY) || biomeTypesList.contains(BiomeDictionary.Type.BEACH)) {
            materials.add(EnumGraveMaterial.SANDSTONE);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.JUNGLE) || biomeTypesList.contains(BiomeDictionary.Type.SWAMP)) {
            materials.add(EnumGraveMaterial.STONE);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.MOUNTAIN)) {
            materials.add(EnumGraveMaterial.GRANITE);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.HILLS)) {
            materials.add(EnumGraveMaterial.ANDESITE);
            materials.add(EnumGraveMaterial.DIORITE);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.PLAINS) || biomeTypesList.contains(BiomeDictionary.Type.MUSHROOM)) {
            materials.add(EnumGraveMaterial.STONE);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.FOREST)) {
            materials.add(EnumGraveMaterial.WOOD);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.SNOWY)) {
            materials.add(EnumGraveMaterial.ICE);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.NETHER)) {
            materials.add(EnumGraveMaterial.QUARTZ);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.MESA)) {
            materials.add(EnumGraveMaterial.RED_SANDSTONE);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.WATER)) {
            materials.add(EnumGraveMaterial.PRIZMARINE);
        }
        if (materials.isEmpty()) {
            materials.add(EnumGraveMaterial.STONE);
        }
        EnumGraveMaterial[] materialsArray = new EnumGraveMaterial[materials.size()];
        return materials.toArray(materialsArray);
    }

    public static EnumGraves getGraveTypeByBiomes(World world, BlockPos pos, EnumGraveTypeByEntity graveTypeByEntity, DamageSource damageSource) {
        EnumGraveMaterial[] materialsArray = GraveGenerationHelper.getGraveMaterialByBiomes(world, pos);
        EnumGraveType[] type = damageSource != null && GraveGenerationHelper.isExplosionDamage(damageSource) ? GENERATED_CREEPER_STATUES_GRAVES_TYPES : GraveGenerationHelper.getDefaultGraveTypes(graveTypeByEntity);
        return GraveGenerationHelper.getGraveType(type, materialsArray);
    }

    private static BlockPos findPlaceForGrave(World world, Entity entity, BlockPos pos, DamageSource damageSource) {
        int z;
        int y;
        int newY;
        int x;
        if (pos.func_177956_o() <= 0) {
            BlockPos groundPos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
            if (world.func_175623_d(groundPos) && world.func_175623_d(groundPos.func_177984_a())) {
                world.func_175656_a(groundPos, Blocks.field_150349_c.func_176223_P());
                return groundPos.func_177984_a();
            }
            GSLogger.logInfoGrave("Can't find position for grave on death in the void!");
        }
        if (GraveGenerationHelper.canGenerateGraveAtCoordinates(world, new BlockPos(x = pos.func_177958_n(), newY = GraveGenerationHelper.getGround(world, x, y = pos.func_177956_o(), z = pos.func_177952_p()), z))) {
            return new BlockPos(x, newY, z);
        }
        int dx = 1;
        int dz = 1;
        while (Math.abs(dx) < 9 && Math.abs(dz) < 9) {
            int newZ;
            int newX;
            if (dx < 0) {
                for (newX = x - 1; newX >= x + dx; --newX) {
                    newY = GraveGenerationHelper.getGround(world, newX, y, z);
                    if (!GraveGenerationHelper.canGenerateGraveAtCoordinates(world, new BlockPos(newX, newY, z))) continue;
                    return new BlockPos(newX, newY, z);
                }
            } else {
                for (newX = x + 1; newX <= x + dx; ++newX) {
                    newY = GraveGenerationHelper.getGround(world, newX, y, z);
                    if (!GraveGenerationHelper.canGenerateGraveAtCoordinates(world, new BlockPos(newX, newY, z))) continue;
                    return new BlockPos(newX, newY, z);
                }
            }
            x += dx;
            if (dz < 0) {
                for (newZ = z - 1; newZ >= z + dz; --newZ) {
                    newY = GraveGenerationHelper.getGround(world, x, y, newZ);
                    if (!GraveGenerationHelper.canGenerateGraveAtCoordinates(world, new BlockPos(x, newY, newZ))) continue;
                    return new BlockPos(x, newY, newZ);
                }
            } else {
                for (newZ = z + 1; newZ <= z + dz; ++newZ) {
                    newY = GraveGenerationHelper.getGround(world, x, y, newZ);
                    if (!GraveGenerationHelper.canGenerateGraveAtCoordinates(world, new BlockPos(x, newY, newZ))) continue;
                    return new BlockPos(x, newY, newZ);
                }
            }
            z += dz;
            dx = dx < 0 ? Math.abs(dx) + 1 : (dx + 1) * -1;
            if (dz < 0) {
                dz = Math.abs(dz) + 1;
                continue;
            }
            dz = (dz + 1) * -1;
        }
        return null;
    }

    public static int getGround(World world, int x, int y, int z) {
        while (true) {
            BlockPos pos = new BlockPos(x, y - 1, z);
            IBlockState state = world.func_180495_p(pos);
            if (!world.func_175623_d(pos) && !state.func_177230_c().func_149688_o(state).func_76224_d() && !state.func_177230_c().func_149688_o(state).func_76222_j() || y <= 1) break;
            --y;
        }
        return y;
    }

    public static boolean canGenerateGraveAtCoordinates(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
        return stateDown.func_177230_c().func_149688_o(stateDown).func_76220_a() && stateDown.func_177230_c().func_149686_d(stateDown) && (world.func_175623_d(pos) || state.func_177230_c().func_149688_o(state).func_76224_d() || state.func_177230_c().func_149688_o(state).func_76222_j());
    }

    protected static EnumGraves getGraveType(EnumGraveType[] graveTypes, EnumGraveMaterial ... materials) {
        EnumGraveType graveType = graveTypes[rand.nextInt(graveTypes.length)];
        EnumGraveMaterial material = materials[rand.nextInt(materials.length)];
        return EnumGraves.getByTypeAndMaterial(graveType, material);
    }

    private static ItemStack getSwordFromInventory(List<ItemStack> items) {
        if (items != null) {
            for (ItemStack stack : items) {
                if (stack == null || !swordsList.contains(stack.func_77973_b())) continue;
                ItemStack sword = stack.func_77946_l();
                items.remove(stack);
                return sword;
            }
        }
        return null;
    }

    private static class GraveInfoOnDeath {
        private EnumGraves grave;
        private ItemStack sword;
        private boolean enchanted;
        private boolean mossy;

        private GraveInfoOnDeath() {
        }

        public EnumGraves getGrave() {
            return this.grave;
        }

        public ItemStack getSword() {
            return this.sword;
        }

        public boolean isEnchanted() {
            return this.enchanted;
        }

        public boolean isMossy() {
            return this.mossy;
        }

        public void setGrave(EnumGraves grave) {
            this.grave = grave;
        }

        public void setSword(ItemStack sword) {
            this.sword = sword;
        }

        public void setEnchanted(boolean enchanted) {
            this.enchanted = enchanted;
        }

        public void setMossy(boolean mossy) {
            this.mossy = mossy;
        }
    }

    public static enum EnumGraveTypeByEntity {
        ALL_GRAVES,
        PLAYER_GRAVES,
        VILLAGERS_GRAVES,
        HUMAN_GRAVES,
        PETS_GRAVES,
        DOGS_GRAVES,
        CATS_GRAVES,
        HORSE_GRAVES;

    }
}

