/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import nightkosh.gravestone.config.Config;
import nightkosh.gravestone.tileentity.TileEntityGraveStone;

public class GraveInventory
implements IInventory {
    public static final int DEFAULT_INVENTORY_SIZE = 54;
    private TileEntityGraveStone tileEntity;
    protected List<ItemStack> items = new ArrayList<ItemStack>(54);

    public GraveInventory(TileEntityGraveStone tileEntity) {
        this.tileEntity = tileEntity;
    }

    public void readItems(NBTTagCompound nbtTag) {
        NBTTagList ntbItemsList = nbtTag.func_150295_c("Items", 10);
        this.items = new ArrayList<ItemStack>(54);
        for (int i = 0; i < ntbItemsList.func_74745_c(); ++i) {
            this.items.add(new ItemStack(ntbItemsList.func_150305_b(i)));
        }
    }

    public void saveItems(NBTTagCompound nbtTag) {
        NBTTagList ntbList = new NBTTagList();
        for (ItemStack stack : this.items) {
            if (stack == null || stack == ItemStack.field_190927_a) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            stack.func_77955_b(nbt);
            ntbList.func_74742_a((NBTBase)nbt);
        }
        nbtTag.func_74782_a("Items", (NBTBase)ntbList);
    }

    public boolean func_191420_l() {
        return this.items.isEmpty();
    }

    public void addInventoryContent(ItemStack stack) {
        if (stack != null && stack != ItemStack.field_190927_a) {
            this.items.add(stack);
        }
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public int getSizeInventoryForGui() {
        return this.items.size() > 54 ? this.items.size() : 54;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < this.items.size()) {
            return this.items.get(slot);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null && stack != ItemStack.field_190927_a) {
            if (stack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else if ((stack = stack.func_77979_a(amount)).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null && stack != ItemStack.field_190927_a) {
            this.func_70299_a(slot, ItemStack.field_190927_a);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot < this.items.size()) {
            this.items.set(slot, stack);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70300_a(EntityPlayer player) {
        if (player.func_130014_f_().func_175625_s(this.tileEntity.func_174877_v()) != this.tileEntity) return false;
        BlockPos blockPos = new BlockPos((double)this.tileEntity.func_174877_v().func_177958_n() + 0.5, (double)this.tileEntity.func_174877_v().func_177956_o() + 0.5, (double)this.tileEntity.func_174877_v().func_177952_p() + 0.5);
        if (!(player.func_174818_b(blockPos) < 64.0)) return false;
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public String func_70005_c_() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public void setItems(List<ItemStack> items) {
        if (items != null) {
            int savedItems = Config.graveItemsCount == 100 ? items.size() : items.size() * Config.graveItemsCount / 100;
            Collections.shuffle(Arrays.asList(items.size()), new Random());
            for (ItemStack item : items) {
                if (item != null && item != ItemStack.field_190927_a && savedItems > 0) {
                    this.addInventoryContent(item);
                    --savedItems;
                    continue;
                }
                GraveInventory.dropItem(item, this.tileEntity.func_145831_w(), this.tileEntity.func_174877_v());
            }
        }
    }

    public void setAdditionalItems(ItemStack[] items) {
        if (items != null) {
            for (ItemStack item : items) {
                this.addInventoryContent(item);
            }
        }
    }

    public void setAdditionalItems(List<ItemStack> items) {
        if (items != null) {
            for (ItemStack item : items) {
                this.addInventoryContent(item);
            }
        }
    }

    public static void dropItem(ItemStack stack, World world, BlockPos pos) {
        if (stack != null && stack != ItemStack.field_190927_a) {
            Random random = new Random();
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack.func_77946_l());
            entityItem.field_70159_w = random.nextGaussian() * 0.2;
            entityItem.field_70181_x = random.nextGaussian() * 0.2;
            entityItem.field_70179_y = random.nextGaussian() * 0.2;
            if (stack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityItem);
        }
    }

    public void dropItem(int slot) {
        GraveInventory.dropItem(this.items.get(slot), this.tileEntity.func_145831_w(), this.tileEntity.func_174877_v());
    }

    public void dropItem(ItemStack stack) {
        GraveInventory.dropItem(stack, this.tileEntity.func_145831_w(), this.tileEntity.func_174877_v());
    }

    public void dropAllItems() {
        this.items.forEach(this::dropItem);
        this.items.clear();
    }

    public List<ItemStack> getGraveContent() {
        return this.items;
    }
}

