/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.item.itemblock;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nightkosh.gravestone.ModGraveStone;
import nightkosh.gravestone.api.grave.EnumGraveMaterial;
import nightkosh.gravestone.block.enums.EnumGraves;
import nightkosh.gravestone.core.GSBlockOld;
import org.apache.commons.lang3.StringUtils;

public class ItemBlockGraveStoneOld
extends ItemBlock {
    public ItemBlockGraveStoneOld(Block block) {
        super(block);
        this.func_77627_a(true);
        this.setRegistryName(GSBlockOld.GRAVE_STONE.getRegistryName());
    }

    public int func_77647_b(int damageValue) {
        return 0;
    }

    public String func_77667_c(ItemStack itemStack) {
        return EnumGraves.getById(itemStack.func_77952_i()).getUnLocalizedName();
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltipList, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        } else {
            EnumGraveMaterial material;
            NBTTagCompound nbt = stack.func_77978_p();
            String deathText = "";
            if (nbt.func_74764_b("DeathText") && StringUtils.isNotBlank((CharSequence)nbt.func_74779_i("DeathText"))) {
                deathText = nbt.func_74779_i("DeathText");
            }
            if (nbt.func_74764_b("isLocalized") && nbt.func_74767_n("isLocalized")) {
                if (nbt.func_74764_b("name")) {
                    String name = ModGraveStone.proxy.getLocalizedEntityName(nbt.func_74779_i("name"));
                    String killerName = ModGraveStone.proxy.getLocalizedEntityName(nbt.func_74779_i("KillerName"));
                    if (killerName.length() == 0) {
                        tooltipList.add(new TextComponentTranslation(deathText, new Object[]{name}).func_150254_d());
                    } else {
                        tooltipList.add(new TextComponentTranslation(deathText, new Object[]{name, killerName.toLowerCase()}).func_150254_d());
                    }
                }
            } else {
                tooltipList.add(deathText);
            }
            if (nbt.func_74762_e("Age") > 0) {
                tooltipList.add(ModGraveStone.proxy.getLocalizedString("item.grave.age") + " " + nbt.func_74762_e("Age") + " " + ModGraveStone.proxy.getLocalizedString("item.grave.days"));
            }
            if ((material = EnumGraves.getById(stack.func_77952_i()).getMaterial()) != EnumGraveMaterial.OTHER) {
                StringBuilder materialStr = new StringBuilder();
                materialStr.append(ModGraveStone.proxy.getLocalizedString("material.title")).append(" ").append(ModGraveStone.proxy.getLocalizedMaterial(material));
                if (nbt.func_74767_n("Mossy")) {
                    materialStr.append(", ").append(ModGraveStone.proxy.getLocalizedString("material.mossy"));
                }
                tooltipList.add(materialStr.toString());
            }
            if (nbt.func_74764_b("Sword")) {
                NBTTagList enchantments;
                ItemStack sword = new ItemStack(nbt.func_74775_l("Sword"));
                if (StringUtils.isNotBlank((CharSequence)sword.func_82833_r())) {
                    tooltipList.add(ModGraveStone.proxy.getLocalizedString("item.grave.sword_name") + " - " + sword.func_82833_r());
                }
                if (sword.func_77952_i() != 0) {
                    tooltipList.add(ModGraveStone.proxy.getLocalizedString("item.grave.sword_damage") + " - " + sword.func_77952_i());
                }
                if (sword.func_77978_p() != null && sword.func_77978_p().func_74764_b("ench") && (enchantments = sword.func_77978_p().func_150295_c("ench", 10)).func_74745_c() != 0) {
                    for (int i = 0; i < enchantments.func_74745_c(); ++i) {
                        short enchantmentId = enchantments.func_150305_b(i).func_74765_d("id");
                        short enchantmentLvl = enchantments.func_150305_b(i).func_74765_d("lvl");
                        try {
                            if (Enchantment.func_185262_c((int)enchantmentId) == null) continue;
                            tooltipList.add(Enchantment.func_185262_c((int)enchantmentId).func_77316_c((int)enchantmentLvl));
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Enchanted");
    }
}

