/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.models;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.util.ResourceLocation;
import nightkosh.gravestone.core.Resources;
import nightkosh.gravestone.models.IModelBaseAdapter;

public class ModelRendererSkull
extends ModelRenderer {
    private static final String NAME = "skull";
    private ModelRenderer teeth;

    public <T extends ModelBase> ModelRendererSkull(T modelBase) {
        this(modelBase, 0.0f, 0.0f, 0.0f, -4.0f, 16.6f, -4.0f);
    }

    public <T extends ModelBase> ModelRendererSkull(T modelBase, float xPos, float yPos, float zPos, float xRot, float yRot, float zRot) {
        super(modelBase, NAME);
        this.field_78801_a = 32.0f;
        this.field_78799_b = 32.0f;
        ((IModelBaseAdapter)modelBase).setTexturesOffset("skull.skull", 0, 0);
        ((IModelBaseAdapter)modelBase).setTexturesOffset("teeth.teeth", 0, 14);
        this.func_78793_a(xRot, yRot, zRot);
        this.setRotation(this, -0.1745329f, 0.0f, 0.0f);
        this.func_78786_a(NAME, xPos, yPos, zPos, 8, 6, 8);
        this.teeth = new ModelRenderer(modelBase, "teeth");
        this.teeth.func_78793_a(2.0f, 5.4f, 0.1f);
        this.teeth.func_78786_a("teeth", xPos, yPos, zPos, 4, 2, 1);
        this.func_78792_a(this.teeth);
    }

    public void bindTexture(EnumSkullType skullType) {
        ResourceLocation texture;
        switch (skullType) {
            default: {
                texture = Resources.SKELETON_SKULL;
                break;
            }
            case WITHER_SKULL: {
                texture = Resources.WITHER_SKULL;
                break;
            }
            case ZOMBIE_SKULL: {
                texture = Resources.ZOMBIE_SKULL;
                break;
            }
            case STRAY_SKULL: {
                texture = Resources.STRAY_SKULL;
            }
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public void bindTexture(boolean isWither) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(isWither ? Resources.WITHER_SKULL : Resources.SKELETON_SKULL);
    }

    public void renderWithTexture(float p_78785_1_, boolean isWither) {
        this.bindTexture(isWither);
        this.func_78785_a(p_78785_1_);
    }

    public void renderWithTexture(float p_78785_1_, EnumSkullType skullType) {
        this.bindTexture(skullType);
        this.func_78785_a(p_78785_1_);
    }

    public void func_78785_a(float p_78785_1_) {
        super.func_78785_a(p_78785_1_);
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public static enum EnumSkullType {
        SKELETON_SKULL,
        WITHER_SKULL,
        ZOMBIE_SKULL,
        STRAY_SKULL;


        public static EnumSkullType getTypeByClass(Entity entity) {
            if (entity instanceof EntityWitherSkeleton) {
                return WITHER_SKULL;
            }
            return SKELETON_SKULL;
        }
    }
}

