/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.renderer.tileentity;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nightkosh.gravestone.api.grave.EnumGraveType;
import nightkosh.gravestone.block.enums.EnumGraves;
import nightkosh.gravestone.config.Config;
import nightkosh.gravestone.core.Resources;
import nightkosh.gravestone.models.block.ModelGraveStone;
import nightkosh.gravestone.models.block.graves.ModelCatStatueGraveStone;
import nightkosh.gravestone.models.block.graves.ModelCelticCrossGravestone;
import nightkosh.gravestone.models.block.graves.ModelCreeperStatueGravestone;
import nightkosh.gravestone.models.block.graves.ModelCrossGraveStone;
import nightkosh.gravestone.models.block.graves.ModelDogStatueGraveStone;
import nightkosh.gravestone.models.block.graves.ModelHorizontalPlateGraveStone;
import nightkosh.gravestone.models.block.graves.ModelHorseGraveStone;
import nightkosh.gravestone.models.block.graves.ModelObeliskGravestone;
import nightkosh.gravestone.models.block.graves.ModelSkeletonCorpseGravestone;
import nightkosh.gravestone.models.block.graves.ModelSwordGraveStone;
import nightkosh.gravestone.models.block.graves.ModelVerticalPlateGraveStone;
import nightkosh.gravestone.models.block.graves.ModelVillagerStatueGravestone;
import nightkosh.gravestone.renderer.tileentity.TileEntityRenderer;
import nightkosh.gravestone.tileentity.TileEntityGraveStone;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityGraveStoneRenderer
extends TileEntityRenderer {
    protected static final Map<EnumGraves, ResourceLocation> mossyTexturesMap = Maps.newHashMap();
    public static ModelGraveStone verticalPlate = new ModelVerticalPlateGraveStone();
    public static ModelGraveStone cross = new ModelCrossGraveStone();
    public static ModelGraveStone obelisk = new ModelObeliskGravestone();
    public static ModelGraveStone celticCross = new ModelCelticCrossGravestone();
    public static ModelGraveStone horizontalPlate = new ModelHorizontalPlateGraveStone();
    public static ModelGraveStone villagerStatue = new ModelVillagerStatueGravestone();
    public static ModelGraveStone dogStatue = new ModelDogStatueGraveStone();
    public static ModelGraveStone catStatue = new ModelCatStatueGraveStone();
    public static ModelGraveStone horseStatue = new ModelHorseGraveStone();
    public static ModelGraveStone creeperStatue = new ModelCreeperStatueGravestone();
    public static ModelGraveStone skeletonCorpse = new ModelSkeletonCorpseGravestone(false);
    public static ModelGraveStone witheredSkeletonCorpse = new ModelSkeletonCorpseGravestone(true);
    public static ModelGraveStone swordModel = new ModelSwordGraveStone();
    public static TileEntityGraveStoneRenderer instance;
    protected static final TileEntityGraveStone GRAVE_TE;
    protected static final ItemStack SWORD;
    public static final Map<Item, EntityItem> flowersMap;
    public static final Map<Item, EntityItem> swordsMap;
    public static final Map<Item, ResourceLocation> swordsTextureMap;

    public TileEntityGraveStoneRenderer() {
        instance = this;
    }

    @Override
    public void func_192841_a(TileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        ItemStack sword;
        boolean isEnchanted;
        boolean isSwordGrave;
        TileEntityGraveStone tileEntity = (TileEntityGraveStone)te;
        if (tileEntity == null) {
            tileEntity = GRAVE_TE;
            isSwordGrave = this.isSwordGrave();
            isEnchanted = false;
            sword = SWORD;
        } else {
            isSwordGrave = tileEntity.isSwordGrave();
            sword = tileEntity.getSword();
            isEnchanted = tileEntity.isEnchanted();
        }
        EnumGraves graveType = tileEntity.getGraveType();
        int meta = 0;
        if (tileEntity.func_145831_w() != null && (meta = tileEntity.func_145832_p()) > 5) {
            meta = 0;
        }
        EnumFacing facing = EnumFacing.values()[meta];
        this.renderGrave(x, y, z, tileEntity.func_145831_w(), graveType, isEnchanted, tileEntity.isMossy(), tileEntity.hasFlower(), tileEntity.getFlower(), isSwordGrave, sword, facing);
    }

    public void renderGrave(double x, double y, double z, World world, EnumGraves graveType, boolean isEnchanted, boolean isMossy, boolean hasFlower, ItemStack flower, boolean isSwordGrave, ItemStack sword, EnumFacing facing) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        switch (facing) {
            case SOUTH: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        this.renderGrave(world, graveType, isEnchanted, isMossy, hasFlower, flower, isSwordGrave, sword);
        GL11.glPopMatrix();
    }

    public void renderGraveAsItem(EnumGraves graveType, boolean isEnchanted, boolean isMossy, boolean isSwordGrave, ItemStack sword) {
        GL11.glPushMatrix();
        if (isSwordGrave) {
            GL11.glTranslatef((float)0.5f, (float)2.0f, (float)0.5f);
            GL11.glScalef((float)1.5f, (float)-1.5f, (float)-1.5f);
        } else {
            GL11.glTranslatef((float)0.5f, (float)1.5f, (float)0.5f);
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glRotatef((float)35.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.renderGrave(null, graveType, isEnchanted, isMossy, false, ItemStack.field_190927_a, isSwordGrave, sword);
        GL11.glPopMatrix();
    }

    public void renderGrave(World world, EnumGraves graveType, boolean isEnchanted, boolean isMossy, boolean hasFlower, ItemStack flower, boolean isSwordGrave, ItemStack sword) {
        if (isSwordGrave) {
            ResourceLocation swordTexture = swordsTextureMap.get(sword.func_77973_b());
            if (Config.vanillaRendererForSwordsGraves) {
                if (world == null) {
                    GL11.glScalef((float)0.5f, (float)-0.5f, (float)-0.5f);
                    GL11.glTranslatef((float)-0.37f, (float)-1.7f, (float)0.0f);
                } else {
                    GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
                    GL11.glTranslatef((float)-0.27f, (float)-0.83f, (float)0.0f);
                }
                this.renderSword(world, sword);
            } else {
                ModelGraveStone model;
                if (swordTexture != null) {
                    model = this.getModel(graveType.getGraveType());
                    this.bindTextureByName(swordTexture);
                } else {
                    model = this.getModel(EnumGraveType.VERTICAL_PLATE);
                    this.bindTextureByName(graveType.getTexture());
                }
                if (isEnchanted) {
                    model.renderEnchanted();
                } else {
                    model.renderAll();
                }
            }
        } else {
            ModelGraveStone model = this.getModel(graveType.getGraveType());
            this.bindTextureByName(this.getTexture(graveType, graveType.getTexture(), isMossy));
            if (graveType.getGraveType() == EnumGraveType.CREEPER_STATUE) {
                model.customRender(isEnchanted);
            } else if (isEnchanted) {
                model.renderEnchanted();
            } else {
                model.renderAll();
            }
            if (hasFlower) {
                this.renderFlower(world, flower);
            }
        }
    }

    protected ResourceLocation getTexture(EnumGraves graveType, ResourceLocation texture, boolean isMossy) {
        if (isMossy) {
            ResourceLocation mixedMossyTexture = mossyTexturesMap.get(graveType);
            if (mixedMossyTexture == null) {
                ResourceLocation mossyTexture = this.getMossyTexture(graveType.getGraveType());
                mixedMossyTexture = new ResourceLocation(texture.func_110624_b() + ":mossy_" + texture.func_110623_a());
                Minecraft.func_71410_x().func_110434_K().func_110579_a(mixedMossyTexture, (ITextureObject)new LayeredTexture(new String[]{texture.func_110624_b() + ":" + texture.func_110623_a(), mossyTexture.func_110624_b() + ":" + mossyTexture.func_110623_a()}));
                mossyTexturesMap.put(graveType, mixedMossyTexture);
                return mixedMossyTexture;
            }
            return mixedMossyTexture;
        }
        return texture;
    }

    protected ResourceLocation getMossyTexture(EnumGraveType graveType) {
        switch (graveType) {
            default: {
                return Resources.GRAVE_MOSSY_VERTICAL_PLATE;
            }
            case CROSS: {
                return Resources.GRAVE_MOSSY_CROSS;
            }
            case OBELISK: {
                return Resources.MOSSY_OBELISK;
            }
            case CELTIC_CROSS: {
                return Resources.MOSSY_CELTIC_CROSS;
            }
            case HORIZONTAL_PLATE: {
                return Resources.GRAVE_MOSSY_HORISONTAL_PLATE;
            }
            case VILLAGER_STATUE: {
                return Resources.MOSSY_VILLAGER_STATUE;
            }
            case DOG_STATUE: {
                return Resources.MOSSY_DOG_STATUE;
            }
            case CAT_STATUE: {
                return Resources.MOSSY_CAT_STATUE;
            }
            case HORSE_STATUE: {
                return Resources.GRAVE_MOSSY_HORSE_STATUE;
            }
            case CREEPER_STATUE: 
        }
        return Resources.MOSSY_CREEPER_STATUE;
    }

    protected ModelGraveStone getModel(EnumGraveType graveType) {
        switch (graveType) {
            default: {
                return verticalPlate;
            }
            case CROSS: {
                return cross;
            }
            case OBELISK: {
                return obelisk;
            }
            case CELTIC_CROSS: {
                return celticCross;
            }
            case HORIZONTAL_PLATE: {
                return horizontalPlate;
            }
            case VILLAGER_STATUE: {
                return villagerStatue;
            }
            case DOG_STATUE: {
                return dogStatue;
            }
            case CAT_STATUE: {
                return catStatue;
            }
            case HORSE_STATUE: {
                return horseStatue;
            }
            case CREEPER_STATUE: {
                return creeperStatue;
            }
            case STARVED_CORPSE: {
                return skeletonCorpse;
            }
            case WITHERED_CORPSE: {
                return witheredSkeletonCorpse;
            }
            case SWORD: 
        }
        return swordModel;
    }

    protected void renderSword(World world, ItemStack sword) {
        EntityItem entityItem = swordsMap.get(sword.func_77973_b());
        if (entityItem == null) {
            entityItem = new EntityItem(world, 0.0, 0.0, 0.0, sword);
            swordsMap.put(sword.func_77973_b(), entityItem);
        }
        entityItem.field_70290_d = 0.0f;
        GL11.glRotatef((float)225.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderItem(sword, entityItem);
    }

    protected void renderFlower(World world, ItemStack flower) {
        if (Config.renderGravesFlowers) {
            EntityItem entityItem = flowersMap.get(flower.func_77973_b());
            if (entityItem == null) {
                entityItem = new EntityItem(world, 0.0, 0.0, 0.0, flower);
                flowersMap.put(flower.func_77973_b(), entityItem);
            }
            entityItem.field_70290_d = 0.0f;
            GL11.glTranslatef((float)0.0f, (float)1.4f, (float)-0.1f);
            GL11.glScalef((float)0.6f, (float)-0.6f, (float)-0.6f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderItem(flower, entityItem);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderItem(flower, entityItem);
        }
    }

    protected void renderItem(ItemStack itemstack, EntityItem entityItem) {
        Render render = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)entityItem);
        if (render != null && render instanceof RenderEntityItem) {
            GlStateManager.func_179094_E();
            RenderEntityItem renderItem = (RenderEntityItem)render;
            renderItem.func_180548_c((Entity)entityItem);
            GlStateManager.func_179091_B();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            IBakedModel ibakedmodel = renderItem.field_177080_a.func_175037_a().func_178089_a(itemstack);
            GlStateManager.func_179109_b((float)0.0f, (float)0.35f, (float)0.0f);
            if (ibakedmodel.func_177556_c()) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            }
            renderItem.field_177080_a.func_180454_a(itemstack, ibakedmodel);
            GlStateManager.func_179101_C();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    protected boolean isSwordGrave() {
        return false;
    }

    static {
        GRAVE_TE = new TileEntityGraveStone();
        SWORD = new ItemStack(Items.field_151040_l);
        flowersMap = new HashMap<Item, EntityItem>();
        swordsMap = new HashMap<Item, EntityItem>();
        swordsTextureMap = new HashMap<Item, ResourceLocation>();
        swordsTextureMap.put(Items.field_151041_m, Resources.WOODEN_SWORD);
        swordsTextureMap.put(Items.field_151052_q, Resources.STONE_SWORD);
        swordsTextureMap.put(Items.field_151040_l, Resources.IRON_SWORD);
        swordsTextureMap.put(Items.field_151010_B, Resources.GOLDEN_SWORD);
        swordsTextureMap.put(Items.field_151048_u, Resources.DIAMOND_SWORD);
        GRAVE_TE.setGraveType(EnumGraves.STONE_VERTICAL_PLATE.ordinal());
    }
}

