/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.tileentity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import nightkosh.gravestone.block.enums.EnumGraves;
import nightkosh.gravestone.config.Config;
import nightkosh.gravestone.helper.GraveSpawnerHelper;
import nightkosh.gravestone.helper.GroupOfGravesSpawnerHelper;
import nightkosh.gravestone.helper.IFog;
import nightkosh.gravestone.helper.ISpawner;
import nightkosh.gravestone.inventory.GraveInventory;
import nightkosh.gravestone.tileentity.ISpawnerEntity;
import nightkosh.gravestone.tileentity.TileEntityGrave;
import org.apache.commons.lang3.StringUtils;

public class TileEntityGraveStone
extends TileEntityGrave
implements ITickable,
ISpawnerEntity {
    public static GraveSpawnerHelper graveSpawnerHelper = new GraveSpawnerHelper();
    protected ItemStack sword = null;
    protected ItemStack flower = null;
    protected String playerId = "";
    protected boolean isPurified = false;
    protected int spawnerHelperId;
    protected GroupOfGravesSpawnerHelper spawnerHelper;
    protected ISpawner spawner = graveSpawnerHelper.getSpawner(this);
    public static IFog fogHandler = new IFog(){};

    public TileEntityGraveStone() {
        this.inventory = new GraveInventory(this);
    }

    public TileEntityGraveStone(World world) {
        this();
        this.func_145834_a(world);
    }

    public void func_73660_a() {
        Entity entity;
        if (this.spawnerHelperId != 0 && this.spawnerHelper == null && (entity = this.func_145831_w().func_73045_a(this.spawnerHelperId)) instanceof GroupOfGravesSpawnerHelper) {
            this.spawnerHelper = (GroupOfGravesSpawnerHelper)entity;
        }
        this.spawner.update();
        fogHandler.addFog(this.func_145831_w(), this.field_174879_c);
    }

    @Override
    public World getIWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getIPos() {
        return this.func_174877_v();
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1 && this.func_145831_w().field_72995_K) {
            this.spawner.setMinDelay();
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTag) {
        super.func_145839_a(nbtTag);
        this.age = nbtTag.func_74762_e("Age");
        this.inventory.readItems(nbtTag);
        this.deathText.readText(nbtTag);
        this.readSwordInfo(nbtTag);
        this.readFlowerInfo(nbtTag);
        this.playerId = nbtTag.func_74779_i("PlayerId");
        this.isPurified = nbtTag.func_74767_n("Purified");
        if (nbtTag.func_74764_b("SpawnerHelperId")) {
            this.spawnerHelperId = nbtTag.func_74762_e("SpawnerHelperId");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTag) {
        nbtTag = super.func_189515_b(nbtTag);
        nbtTag.func_74768_a("Age", this.age);
        this.inventory.saveItems(nbtTag);
        this.deathText.saveText(nbtTag);
        this.writeSwordInfo(nbtTag);
        this.writeFlowerInfo(nbtTag);
        nbtTag.func_74778_a("PlayerId", this.playerId);
        nbtTag.func_74757_a("Purified", this.isPurified);
        if (this.haveSpawnerHelper()) {
            nbtTag.func_74768_a("SpawnerHelperId", this.spawnerHelper.func_145782_y());
        }
        return nbtTag;
    }

    private void readSwordInfo(NBTTagCompound nbtTag) {
        if (nbtTag.func_74764_b("Sword")) {
            this.sword = new ItemStack(nbtTag.func_74775_l("Sword"));
        }
    }

    private void writeSwordInfo(NBTTagCompound nbtTag) {
        if (this.sword != null) {
            NBTTagCompound swordNBT = new NBTTagCompound();
            this.sword.func_77955_b(swordNBT);
            nbtTag.func_74782_a("Sword", (NBTBase)swordNBT);
        }
    }

    private void readFlowerInfo(NBTTagCompound nbtTag) {
        if (nbtTag.func_74764_b("Flower")) {
            this.flower = new ItemStack(nbtTag.func_74775_l("Flower"));
        }
    }

    private void writeFlowerInfo(NBTTagCompound nbtTag) {
        if (this.flower != null) {
            NBTTagCompound flowerNBT = new NBTTagCompound();
            this.flower.func_77955_b(flowerNBT);
            nbtTag.func_74782_a("Flower", (NBTBase)flowerNBT);
        }
    }

    public ItemStack getSword() {
        return this.sword;
    }

    public void setSword(ItemStack sword) {
        this.sword = sword;
    }

    public void dropSword() {
        if (this.sword != null) {
            GraveInventory.dropItem(this.sword, this.func_145831_w(), this.field_174879_c);
        }
    }

    public boolean isSwordGrave() {
        return this.sword != null;
    }

    public boolean canBeMossy() {
        return !this.isSwordGrave() && this.getGraveType() != EnumGraves.STARVED_CORPSE && this.getGraveType() != EnumGraves.WITHERED_CORPSE;
    }

    public ItemStack getFlower() {
        return this.flower;
    }

    public void setFlower(ItemStack flower) {
        this.flower = flower;
    }

    public void dropFlower() {
        if (this.flower != null) {
            GraveInventory.dropItem(this.flower, this.func_145831_w(), this.field_174879_c);
        }
    }

    public boolean hasFlower() {
        return this.flower != null;
    }

    public EnumGraves getGraveType() {
        return EnumGraves.getById(this.graveType);
    }

    public boolean isEmpty() {
        return this.inventory.func_191420_l();
    }

    public String getOwner() {
        return this.playerId;
    }

    public void setOwner(String playerId) {
        this.playerId = playerId;
    }

    public boolean canBeLooted(EntityPlayer player) {
        if (Config.onlyOwnerCanLootGrave) {
            if (player != null) {
                String playerId = player.func_110124_au().toString();
                return player.func_184812_l_() || StringUtils.isBlank((CharSequence)this.playerId) || playerId.equals(this.playerId) || this.inventory.getGraveContent().isEmpty();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean haveSpawnerHelper() {
        return this.spawnerHelper != null;
    }

    @Override
    public GroupOfGravesSpawnerHelper getSpawnerHelper() {
        return this.spawnerHelper;
    }

    public void setSpawnerHelper(GroupOfGravesSpawnerHelper spawnerHelper) {
        this.spawnerHelper = spawnerHelper;
        if (spawnerHelper != null) {
            this.spawnerHelperId = spawnerHelper.func_145782_y();
        }
    }

    public boolean isPurified() {
        return this.isPurified;
    }

    public void setPurified(boolean isPurified) {
        this.isPurified = isPurified;
    }
}

