/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.impl;

import com.google.common.collect.Lists;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.api.display.ModPopupMenu;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.fullscreen.menu.PopupMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraftforge.client.ForgeHooksClient;

public class ModPopupMenuImpl
implements ModPopupMenu {
    private final List<MenuItem> menuItemList = Lists.newArrayList();
    private final PopupMenu popupMenu;
    private List<ModPopupMenuImpl> childMenus = Lists.newArrayList();
    private ModPopupMenuImpl lastClicked;
    private boolean opened = false;
    private boolean sub = false;
    private boolean clicked = false;

    public ModPopupMenuImpl(PopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public ModPopupMenuImpl(PopupMenu popupMenu, boolean sub) {
        this(popupMenu);
        this.sub = sub;
    }

    @Override
    public ModPopupMenu addMenuItem(String label, ModPopupMenu.Action action) {
        this.menuItemList.add(new MenuItem(label, action));
        return this;
    }

    @Override
    public ModPopupMenu addMenuItemScreen(String label, Screen screen) {
        this.menuItemList.add(new MenuItem(label, blockPos -> ForgeHooksClient.pushGuiLayer((Minecraft)Minecraft.m_91087_(), (Screen)screen)));
        return this;
    }

    @Override
    public ModPopupMenu createSubItemList(String label) {
        PopupMenu menu = new PopupMenu(this.popupMenu);
        ModPopupMenuImpl modPopupMenu = new ModPopupMenuImpl(menu, true);
        this.childMenus.add(modPopupMenu);
        this.menuItemList.add(new MenuItem(label, this.createSubPopup(modPopupMenu, menu), false));
        return modPopupMenu;
    }

    public List<MenuItem> getMenuItemList() {
        return this.menuItemList;
    }

    public boolean isSub() {
        return this.sub;
    }

    private SubMenuAction createSubPopup(final ModPopupMenuImpl modPopupMenu, final PopupMenu menu) {
        return new SubMenuAction(){
            boolean displayed = false;

            @Override
            public void doAction(BlockPos blockPos, Button button) {
                ModPopupMenuImpl.this.clicked = true;
                ModPopupMenuImpl.this.lastClicked = modPopupMenu;
                this.displayed = ModPopupMenuImpl.this.hoverStateChange(modPopupMenu, menu, blockPos, button, true, false);
            }

            @Override
            public void onHoverState(BlockPos blockPos, Button button, boolean isHovered) {
                if (ModPopupMenuImpl.this.lastClicked != modPopupMenu) {
                    ModPopupMenuImpl.this.clicked = false;
                }
                this.displayed = ModPopupMenuImpl.this.hoverStateChange(modPopupMenu, menu, blockPos, button, isHovered, this.displayed);
            }
        };
    }

    private boolean hoverStateChange(ModPopupMenuImpl modPopupMenu, PopupMenu menu, BlockPos blockPos, Button button, boolean isHovered, boolean displayed) {
        if (!(!isHovered || displayed && modPopupMenu.opened)) {
            this.closeChildren(modPopupMenu);
            int x = this.popupMenu.getPaneX() + this.popupMenu.getPaneWidth() - (this.popupMenu.getScrollPane().isScrollVisible() ? 12 : 6);
            int y = button.getY() - 5;
            menu.setClickLoc(x, y);
            menu.displayOptions(blockPos, modPopupMenu);
            modPopupMenu.opened = true;
        } else if (!this.clicked && displayed && !modPopupMenu.popupMenu.isMouseOver()) {
            this.resetChildren(modPopupMenu);
        }
        return modPopupMenu.opened;
    }

    private void resetChildren(ModPopupMenuImpl modPopupMenu) {
        if (this.hasChildren(modPopupMenu)) {
            modPopupMenu.closeChildren(null);
        }
        modPopupMenu.opened = false;
        modPopupMenu.popupMenu.m_7379_();
        modPopupMenu.popupMenu.resetPass();
        modPopupMenu.clicked = false;
    }

    private boolean hasChildren(ModPopupMenuImpl menu) {
        return menu.childMenus != null || !menu.childMenus.isEmpty();
    }

    private void closeChildren(ModPopupMenuImpl modPopupMenu) {
        for (ModPopupMenuImpl child : this.childMenus) {
            if (!child.opened || child.equals(modPopupMenu)) continue;
            this.resetChildren(child);
        }
    }

    public static class MenuItem {
        private final ModPopupMenu.Action action;
        private final String label;
        private boolean autoClose = true;

        public MenuItem(String label, ModPopupMenu.Action action) {
            this.action = action;
            this.label = Constants.getString(label);
        }

        public MenuItem(String label, SubMenuAction subMenu, boolean autoClose) {
            this.autoClose = autoClose;
            this.action = subMenu;
            this.label = Constants.getString(label);
        }

        public ModPopupMenu.Action getAction() {
            return this.action;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isAutoCloseable() {
            return this.autoClose;
        }

        public SubMenuAction getSubMenuAction() {
            return (SubMenuAction)this.action;
        }
    }

    public static interface SubMenuAction
    extends ModPopupMenu.Action {
        @Override
        default public void doAction(BlockPos blockPos) {
        }

        public void doAction(BlockPos var1, Button var2);

        public void onHoverState(BlockPos var1, Button var2, boolean var3);
    }
}

