/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.world;

import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import javax.annotation.Nullable;
import journeymap.client.data.DataCache;
import journeymap.client.model.ChunkMD;
import journeymap.common.helper.DimensionHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
public enum JmBlockAccess implements BlockAndTintGetter
{
    INSTANCE;


    public BlockEntity m_7702_(@NotNull BlockPos pos) {
        return this.getWorld().m_7702_(pos);
    }

    public BlockState m_8055_(@NotNull BlockPos pos) {
        if (!this.isValid(pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        ChunkMD chunkMD = this.getChunkMDFromBlockCoords(pos);
        if (chunkMD != null && chunkMD.hasChunk()) {
            return chunkMD.getChunk().m_8055_(new BlockPos(pos.m_123341_() & 0xF, pos.m_123342_(), pos.m_123343_() & 0xF));
        }
        return Blocks.f_50016_.m_49966_();
    }

    public FluidState m_6425_(@NotNull BlockPos blockPos) {
        return this.getWorld().m_6425_(blockPos);
    }

    public int m_7146_(@NotNull BlockPos p_217298_1_) {
        return this.getWorld().m_7146_(p_217298_1_);
    }

    public int m_7469_() {
        return this.getWorld().m_7469_();
    }

    public int m_141928_() {
        return this.getWorld().m_141928_();
    }

    public int m_141937_() {
        return this.getWorld().m_141937_();
    }

    public int m_151558_() {
        return this.getWorld().m_151558_();
    }

    public BlockHitResult m_45547_(ClipContext context) {
        return this.getWorld().m_45547_(context);
    }

    @Nullable
    public BlockHitResult m_45558_(Vec3 vec3d, Vec3 vec3d_1, BlockPos blockPos, VoxelShape voxelShape, BlockState blockState) {
        return this.getWorld().m_45558_(vec3d, vec3d_1, blockPos, voxelShape, blockState);
    }

    public Biome getBiome(BlockPos pos) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        return this.getBiome(pos, (Biome)world.m_5962_().m_175515_(Registry.f_122885_).m_123013_(Biomes.f_48202_));
    }

    @Nullable
    public Biome getBiome(BlockPos pos, Biome defaultBiome) {
        IntegratedServer server;
        Biome biome;
        ChunkMD chunkMD = this.getChunkMDFromBlockCoords(pos);
        if (chunkMD != null && chunkMD.hasChunk() && (biome = chunkMD.getBiome(pos)) != null) {
            return biome;
        }
        if (Minecraft.m_91087_().m_91091_() && (server = Minecraft.m_91087_().m_91092_()) != null) {
            try {
                return server.m_129880_(DimensionHelper.getDimension((Entity)Minecraft.m_91087_().f_91074_)).m_7158_(pos.m_123341_() >> 2, pos.m_123342_() >> 2, pos.m_123343_() >> 2);
            }
            catch (Exception e) {
                return server.m_129880_(DimensionHelper.getDimension((Entity)Minecraft.m_91087_().f_91074_)).m_46857_(pos);
            }
        }
        return defaultBiome;
    }

    public Level getWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    private boolean isValid(BlockPos pos) {
        return pos.m_123341_() >= -30000000 && pos.m_123343_() >= -30000000 && pos.m_123341_() < 30000000 && pos.m_123343_() < 30000000 && pos.m_123342_() >= 0 && pos.m_123342_() < 256;
    }

    @Nullable
    private ChunkMD getChunkMDFromBlockCoords(BlockPos pos) {
        return DataCache.INSTANCE.getChunkMD(new ChunkPos(pos));
    }

    public float m_7717_(@NotNull Direction p_230487_1_, boolean p_230487_2_) {
        return this.getWorld().m_7717_(p_230487_1_, p_230487_2_);
    }

    public LevelLightEngine m_5518_() {
        return this.getWorld().m_5518_();
    }

    public int m_6171_(@NotNull BlockPos blockPos, ColorResolver colorResolver) {
        return colorResolver.m_130045_(this.getBiome(blockPos), (double)blockPos.m_123341_(), (double)blockPos.m_123343_());
    }

    public int m_45517_(@NotNull LightLayer lightType, @NotNull BlockPos blockPos) {
        return this.getWorld().m_45517_(lightType, blockPos);
    }

    public int m_45524_(@NotNull BlockPos blockPosIn, int amount) {
        return this.getWorld().m_45524_(blockPosIn, amount);
    }

    public boolean m_45527_(@NotNull BlockPos blockPosIn) {
        return this.getWorld().m_45527_(blockPosIn);
    }
}

