/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;

public class PlayerData
extends SavedData {
    private static final String DAT_FILE = "JMPlayerSettings";
    private CompoundTag data = new CompoundTag();
    Map<String, Player> playerMap = new HashMap<String, Player>();

    public PlayerData() {
        ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_).m_8895_().m_164855_(DAT_FILE, (SavedData)this);
        this.m_77762_();
    }

    public static PlayerData getPlayerData() {
        return PlayerData.get();
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128365_(DAT_FILE, (Tag)PlayerData.get().data);
        return compound;
    }

    private static PlayerData get() {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
        return (PlayerData)level.m_8895_().m_164861_(PlayerData::load, PlayerData::new, DAT_FILE);
    }

    private static PlayerData load(CompoundTag nbt) {
        PlayerData playerData = new PlayerData();
        playerData.data = nbt.m_128469_(DAT_FILE);
        return playerData;
    }

    public Player getPlayer(ServerPlayer serverPlayer) {
        String uuid = serverPlayer.m_20149_();
        Player player = this.playerMap.get(uuid);
        if (player == null) {
            CompoundTag playerTag;
            if (this.data.m_128441_(uuid)) {
                playerTag = this.data.m_128469_(uuid);
            } else {
                playerTag = new CompoundTag();
                this.data.m_128365_(uuid, (Tag)playerTag);
            }
            player = new Player(this, uuid, playerTag);
            this.playerMap.put(uuid, player);
        }
        return player;
    }

    public static class Player {
        static final String HIDDEN_UNDERGROUND = "hidden_underground";
        static final String VISIBLE = "radar_visible";
        final String uuid;
        boolean hiddenUnderground;
        boolean visible;
        CompoundTag playerNbt;
        final PlayerData playerData;

        public Player(PlayerData playerData, String uuid, CompoundTag playerNbt) {
            this.playerData = playerData;
            this.uuid = uuid;
            this.playerNbt = playerNbt;
            this.readPlayerNbt();
        }

        public boolean isHiddenUnderground() {
            return this.hiddenUnderground;
        }

        public void setHiddenUnderground(boolean hiddenUnderground) {
            this.playerNbt.m_128379_(HIDDEN_UNDERGROUND, hiddenUnderground);
            this.hiddenUnderground = hiddenUnderground;
            this.playerData.m_77762_();
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.playerNbt.m_128379_(VISIBLE, visible);
            this.visible = visible;
            this.playerData.m_77762_();
        }

        private void readPlayerNbt() {
            if (this.playerNbt.m_128441_(HIDDEN_UNDERGROUND)) {
                this.hiddenUnderground = this.playerNbt.m_128471_(HIDDEN_UNDERGROUND);
            } else {
                this.setHiddenUnderground(false);
            }
            if (this.playerNbt.m_128441_(VISIBLE)) {
                this.visible = this.playerNbt.m_128471_(VISIBLE);
            } else {
                this.setVisible(true);
            }
        }
    }
}

