/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;

public class WorldIdData
extends SavedData {
    private static final String DAT_FILE = "WorldUUID";
    private static final String WORLD_ID_KEY = "world_uuid";
    private CompoundTag data;

    public WorldIdData() {
        String worldID = UUID.randomUUID().toString();
        this.data = new CompoundTag();
        ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_).m_8895_().m_164855_(DAT_FILE, (SavedData)this);
        this.data.m_128359_(WORLD_ID_KEY, worldID);
        this.m_77762_();
    }

    public static String getWorldId() {
        return WorldIdData.get().getNBTWorldID();
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128365_(DAT_FILE, (Tag)WorldIdData.get().data);
        return compound;
    }

    static WorldIdData get() {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
        return (WorldIdData)level.m_8895_().m_164861_(WorldIdData::load, WorldIdData::new, DAT_FILE);
    }

    private static WorldIdData load(CompoundTag nbt) {
        WorldIdData worldIdData = new WorldIdData();
        worldIdData.data = nbt.m_128469_(DAT_FILE);
        return worldIdData;
    }

    private String getNBTWorldID() {
        if (this.data.m_128441_(WORLD_ID_KEY)) {
            return this.data.m_128461_(WORLD_ID_KEY);
        }
        return "noWorldIDFound";
    }
}

