/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity.projectile;

import baguchan.earthmobsmod.registry.ModEntities;
import baguchan.earthmobsmod.registry.ModItems;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class BoneShard
extends ThrowableItemProjectile {
    private Potion potion = Potions.f_43598_;
    private final Set<MobEffectInstance> effects = Sets.newHashSet();
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.m_135353_(BoneShard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BoneShard(EntityType<? extends BoneShard> p_37391_, Level p_37392_) {
        super(p_37391_, p_37392_);
    }

    public BoneShard(Level p_37399_, LivingEntity p_37400_) {
        super(ModEntities.BONE_SHARD, p_37400_, p_37399_);
    }

    public BoneShard(Level p_37394_, double p_37395_, double p_37396_, double p_37397_) {
        super(ModEntities.BONE_SHARD, p_37395_, p_37396_, p_37397_, p_37394_);
    }

    protected Item m_7881_() {
        return ModItems.BONE_SHARD;
    }

    private ParticleOptions getParticle() {
        return new ItemParticleOption(ParticleTypes.f_123752_, ModItems.BONE_SHARD.m_7968_());
    }

    private void makeParticle(int p_36877_) {
        int i = this.getColor();
        if (i != -1 && p_36877_ > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < p_36877_; ++j) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
            }
        }
    }

    public void m_7822_(byte p_37402_) {
        if (p_37402_ == 3) {
            ParticleOptions particleoptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_7106_(particleoptions, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_EFFECT_COLOR, (Object)-1);
    }

    private void updateColor() {
        if (this.potion == Potions.f_43598_ && this.effects.isEmpty()) {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        } else {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
        }
    }

    public void addEffect(MobEffectInstance p_36871_) {
        this.effects.add(p_36871_);
        this.m_20088_().m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && !this.f_19861_) {
            this.makeParticle(2);
        }
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(ID_EFFECT_COLOR);
    }

    public void m_7380_(CompoundTag p_36881_) {
        super.m_7380_(p_36881_);
        if (this.potion != Potions.f_43598_) {
            p_36881_.m_128359_("Potion", Registry.f_122828_.m_7981_((Object)this.potion).toString());
        }
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            p_36881_.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
    }

    public void m_7378_(CompoundTag p_36875_) {
        super.m_7378_(p_36875_);
        if (p_36875_.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)p_36875_);
        }
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43573_((CompoundTag)p_36875_)) {
            this.addEffect(mobeffectinstance);
        }
        this.updateColor();
    }

    protected ItemStack getPickupItem() {
        if (this.effects.isEmpty() && this.potion == Potions.f_43598_) {
            return new ItemStack((ItemLike)Items.f_42412_);
        }
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42738_);
        PotionUtils.m_43549_((ItemStack)itemstack, (Potion)this.potion);
        PotionUtils.m_43552_((ItemStack)itemstack, this.effects);
        return itemstack;
    }

    protected void m_5790_(EntityHitResult p_37404_) {
        super.m_5790_(p_37404_);
        Entity entity = p_37404_.m_82443_();
        entity.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_()), 5.0f);
        if (entity instanceof LivingEntity) {
            for (MobEffectInstance mobeffectinstance : this.potion.m_43488_()) {
                ((LivingEntity)entity).m_147207_(new MobEffectInstance(mobeffectinstance.m_19544_(), Math.max(mobeffectinstance.m_19557_() / 8, 1), mobeffectinstance.m_19564_(), mobeffectinstance.m_19571_(), mobeffectinstance.m_19572_()), entity);
            }
            if (!this.effects.isEmpty()) {
                for (MobEffectInstance mobeffectinstance1 : this.effects) {
                    ((LivingEntity)entity).m_147207_(mobeffectinstance1, entity);
                }
            }
        }
    }

    protected void m_6532_(HitResult p_37488_) {
        super.m_6532_(p_37488_);
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

