/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.render.entity;

import artifacts.client.render.entity.model.MimicChestLayerModel;
import artifacts.client.render.entity.model.MimicModel;
import artifacts.common.config.ModConfig;
import artifacts.common.entity.MimicEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.fml.ModList;

public class MimicChestLayer
extends RenderLayer<MimicEntity, MimicModel> {
    private final MimicChestLayerModel chestModel;
    public final Material vanillaChestMaterial;
    public final List<Material> chestMaterials;

    public MimicChestLayer(RenderLayerParent<MimicEntity, MimicModel> entityRenderer, EntityModelSet modelSet) {
        super(entityRenderer);
        Calendar calendar = Calendar.getInstance();
        boolean isChristmas = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
        this.chestModel = new MimicChestLayerModel(modelSet.m_171103_(MimicChestLayerModel.LAYER_LOCATION));
        this.chestMaterials = new ArrayList<Material>();
        this.vanillaChestMaterial = Sheets.m_110767_(null, (ChestType)ChestType.SINGLE, (boolean)isChristmas);
        if (ModList.get().isLoaded("lootr")) {
            ResourceLocation chestLocation = new ResourceLocation("lootr", "chest");
            this.chestMaterials.add(new Material(TextureAtlas.f_118259_, chestLocation));
        } else {
            if (!isChristmas && ModList.get().isLoaded("quark")) {
                List<String> chestTypes = Arrays.asList("oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "warped", "crimson");
                ResourceLocation atlas = new ResourceLocation("textures/atlas/chest.png");
                for (String chestType : chestTypes) {
                    ResourceLocation chestLocation = new ResourceLocation("quark", String.format("model/chest/%s/normal", chestType));
                    this.chestMaterials.add(new Material(atlas, chestLocation));
                }
            }
            this.chestMaterials.add(this.vanillaChestMaterial);
        }
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, MimicEntity mimic, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!mimic.m_20145_()) {
            matrixStack.m_85836_();
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            matrixStack.m_85837_(-0.5, -1.5, -0.5);
            ((MimicModel)this.m_117386_()).m_102624_(this.chestModel);
            this.chestModel.prepareMobModel(mimic, limbSwing, limbSwingAmount, partialTicks);
            this.chestModel.setupAnim(mimic, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer builder = this.getChestMaterial(mimic).m_119194_(buffer, RenderType::m_110452_);
            this.chestModel.m_7695_(matrixStack, builder, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)mimic, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        }
    }

    private Material getChestMaterial(MimicEntity mimic) {
        if (!((Boolean)ModConfig.client.useModdedMimicTextures.get()).booleanValue()) {
            return this.vanillaChestMaterial;
        }
        if (this.chestMaterials.size() == 1) {
            return this.chestMaterials.get(0);
        }
        return this.chestMaterials.get((int)(Math.abs(mimic.m_142081_().getMostSignificantBits()) % (long)this.chestMaterials.size()));
    }
}

