/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.network;

import artifacts.client.network.ClientPacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class SinkPacket {
    public final boolean shouldSink;

    public SinkPacket(FriendlyByteBuf buffer) {
        this.shouldSink = buffer.readBoolean();
    }

    public SinkPacket(boolean shouldSink) {
        this.shouldSink = shouldSink;
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.shouldSink);
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleSinkPacket(this)));
        context.get().setPacketHandled(true);
    }
}

