/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.world;

import artifacts.common.config.ModConfig;
import artifacts.common.entity.MimicEntity;
import artifacts.common.init.ModEntityTypes;
import artifacts.common.init.ModLootTables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraftforge.common.Tags;

public class CampsiteFeature
extends Feature<NoneFeatureConfiguration> {
    public static final BlockStateProvider CRAFTING_STATION_PROVIDER = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50091_.m_49966_(), 5).m_146271_((Object)((BlockState)Blocks.f_50094_.m_49966_().m_61124_((Property)FurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(false))), 5).m_146271_((Object)((BlockState)Blocks.f_50620_.m_49966_().m_61124_((Property)BlastFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(false))), 5).m_146271_((Object)((BlockState)Blocks.f_50619_.m_49966_().m_61124_((Property)SmokerBlock.f_48684_, (Comparable)Boolean.valueOf(false))), 5).m_146271_((Object)Blocks.f_50625_.m_49966_(), 5).m_146271_((Object)Blocks.f_50622_.m_49966_(), 5).m_146271_((Object)Blocks.f_50621_.m_49966_(), 5).m_146271_((Object)Blocks.f_50322_.m_49966_(), 2).m_146271_((Object)Blocks.f_50323_.m_49966_(), 2).m_146271_((Object)Blocks.f_50324_.m_49966_(), 1));
    public static final BlockStateProvider DECORATION_PROVIDER = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50681_.m_49966_(), 5).m_146271_((Object)Blocks.f_50081_.m_49966_(), 3).m_146271_((Object)Blocks.f_50174_.m_49966_(), 3).m_146271_((Object)Blocks.f_50145_.m_49966_(), 1).m_146271_((Object)Blocks.f_50255_.m_49966_(), 4));
    public static final BlockStateProvider ORE_PROVIDER = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_49996_.m_49966_(), 6).m_146271_((Object)Blocks.f_50173_.m_49966_(), 6).m_146271_((Object)Blocks.f_50059_.m_49966_(), 6).m_146271_((Object)Blocks.f_49995_.m_49966_(), 4).m_146271_((Object)Blocks.f_50089_.m_49966_(), 2).m_146271_((Object)Blocks.f_50264_.m_49966_(), 1));
    public static final BlockStateProvider CAMPFIRE_PROVIDER = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)Blocks.f_50683_.m_49966_().m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false))), 12).m_146271_((Object)((BlockState)Blocks.f_50683_.m_49966_().m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(true))), 3).m_146271_((Object)((BlockState)Blocks.f_50684_.m_49966_().m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(true))), 1));
    public static final BlockStateProvider LANTERN_PROVIDER = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true))), 6).m_146271_((Object)((BlockState)Blocks.f_50682_.m_49966_().m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true))), 2).m_146271_((Object)((BlockState)Blocks.f_50489_.m_49966_().m_61124_((Property)EndRodBlock.f_52588_, (Comparable)Direction.DOWN)), 1).m_146271_((Object)Blocks.f_50701_.m_49966_(), 1).m_146271_((Object)Blocks.f_50141_.m_49966_(), 1));
    public static final BlockStateProvider FLOWER_POT_PROVIDER;

    public CampsiteFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random random = context.m_159776_();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockPos.m_121990_((BlockPos)pos.m_142082_(-3, 0, -3), (BlockPos)pos.m_142082_(3, 0, 3)).forEach(blockPos -> positions.add(blockPos.m_7949_()));
        positions.remove(pos);
        positions.removeIf(currentPos -> !level.m_46859_(currentPos));
        positions.removeIf(currentPos -> !level.m_8055_(currentPos.m_7495_()).m_60767_().m_76334_());
        if (positions.size() < 12) {
            return false;
        }
        Collections.shuffle(positions);
        if ((double)random.nextFloat() < (Double)ModConfig.common.campsiteOreChance.get()) {
            this.generateOreVein(level, pos.m_7495_(), random);
        }
        this.generateLightSource(level, pos, random);
        this.generateContainer(level, (BlockPos)positions.remove(0), random);
        if (random.nextBoolean()) {
            this.generateContainer(level, (BlockPos)positions.remove(0), random);
        }
        this.generateCraftingStation(level, (BlockPos)positions.remove(0), random);
        if (random.nextBoolean()) {
            this.generateCraftingStation(level, (BlockPos)positions.remove(0), random);
        }
        return true;
    }

    public void generateLightSource(WorldGenLevel world, BlockPos pos, Random random) {
        if (random.nextInt(4) != 0) {
            BlockPos currentPos = pos;
            while (currentPos.m_123342_() - pos.m_123342_() < 8 && world.m_46859_(currentPos.m_7494_())) {
                currentPos = currentPos.m_7494_();
            }
            if (currentPos.m_123342_() - pos.m_123342_() > 2 && !world.m_46859_(currentPos.m_7494_())) {
                this.m_5974_((LevelWriter)world, currentPos, LANTERN_PROVIDER.m_7112_(random, currentPos));
                return;
            }
        }
        this.m_5974_((LevelWriter)world, pos, CAMPFIRE_PROVIDER.m_7112_(random, pos));
    }

    public void generateContainer(WorldGenLevel world, BlockPos pos, Random random) {
        if ((double)random.nextFloat() < (Double)ModConfig.common.campsiteMimicChance.get()) {
            MimicEntity mimic = (MimicEntity)ModEntityTypes.MIMIC.m_20615_((Level)world.m_6018_());
            if (mimic != null) {
                mimic.setDormant();
                mimic.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                world.m_7967_((Entity)mimic);
            }
        } else {
            if (random.nextBoolean()) {
                if (random.nextInt(5) == 0) {
                    this.m_5974_((LevelWriter)world, pos, (BlockState)Blocks.f_50325_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.Plane.HORIZONTAL.m_122560_(random)));
                    this.m_5974_((LevelWriter)world, pos.m_7495_(), Blocks.f_50077_.m_49966_());
                } else {
                    Block chestBlock = (Boolean)ModConfig.common.useModdedChests.get() != false ? (Block)Tags.Blocks.CHESTS_WOODEN.m_13288_(random) : Blocks.f_50087_;
                    this.m_5974_((LevelWriter)world, pos, (BlockState)chestBlock.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.Plane.HORIZONTAL.m_122560_(random)));
                }
            } else {
                this.m_5974_((LevelWriter)world, pos, (BlockState)Blocks.f_50618_.m_49966_().m_61124_((Property)BarrelBlock.f_49042_, (Comparable)Direction.m_122404_((Random)random)));
            }
            RandomizableContainerBlockEntity.m_59620_((BlockGetter)world, (Random)random, (BlockPos)pos, (ResourceLocation)ModLootTables.CAMPSITE_CHEST);
        }
    }

    public void generateCraftingStation(WorldGenLevel world, BlockPos pos, Random random) {
        BlockState state = CRAFTING_STATION_PROVIDER.m_7112_(random, pos);
        this.m_5974_((LevelWriter)world, pos, state);
        if (random.nextBoolean() && world.m_46859_(pos.m_7494_())) {
            this.generateDecoration(world, pos.m_7494_(), random);
        }
    }

    public void generateDecoration(WorldGenLevel world, BlockPos pos, Random random) {
        if (random.nextInt(3) == 0) {
            this.m_5974_((LevelWriter)world, pos, DECORATION_PROVIDER.m_7112_(random, pos));
        } else {
            this.m_5974_((LevelWriter)world, pos, FLOWER_POT_PROVIDER.m_7112_(random, pos));
        }
    }

    public void generateOreVein(WorldGenLevel world, BlockPos pos, Random random) {
        BlockState ore = ORE_PROVIDER.m_7112_(random, pos);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        positions.add(pos);
        for (int i = 4 + random.nextInt(12); i > 0; --i) {
            pos = (BlockPos)positions.remove(0);
            this.m_5974_((LevelWriter)world, pos, ore);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!world.m_8055_(pos.m_142300_(direction)).m_60767_().m_76334_() || world.m_8055_(pos.m_142300_(direction).m_7494_()).m_60767_().m_76334_()) continue;
                positions.add(pos.m_142300_(direction));
            }
            if (positions.size() != 0) continue;
            return;
        }
    }

    static {
        List<Block> flowerPots = Arrays.asList(Blocks.f_50277_, Blocks.f_50278_, Blocks.f_50279_, Blocks.f_50280_, Blocks.f_50229_, Blocks.f_50230_, Blocks.f_50231_, Blocks.f_50232_, Blocks.f_50233_, Blocks.f_50234_, Blocks.f_50235_, Blocks.f_50236_, Blocks.f_50237_, Blocks.f_50238_, Blocks.f_50239_, Blocks.f_50240_, Blocks.f_50241_, Blocks.f_50242_, Blocks.f_50243_, Blocks.f_50245_, Blocks.f_50246_, Blocks.f_50247_, Blocks.f_50248_, Blocks.f_50572_, Blocks.f_50725_, Blocks.f_50726_, Blocks.f_50727_, Blocks.f_50728_);
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
        for (Block flowerPot : flowerPots) {
            builder.m_146271_((Object)flowerPot.m_49966_(), 1);
        }
        FLOWER_POT_PROVIDER = new WeightedStateProvider(builder);
    }
}

