/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.render;

import artifacts.client.render.curio.renderer.GloveCurioRenderer;
import artifacts.common.config.ModConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin {
    @Inject(method={"renderLeftHand"}, at={@At(value="TAIL")})
    private void renderLeftGlove(PoseStack matrixStack, MultiBufferSource buffer, int light, AbstractClientPlayer player, CallbackInfo callbackInfo) {
        PlayerRendererMixin.renderArm(matrixStack, buffer, light, player, HumanoidArm.LEFT);
    }

    @Inject(method={"renderRightHand"}, at={@At(value="TAIL")})
    private void renderRightGlove(PoseStack matrixStack, MultiBufferSource buffer, int light, AbstractClientPlayer player, CallbackInfo callbackInfo) {
        PlayerRendererMixin.renderArm(matrixStack, buffer, light, player, HumanoidArm.RIGHT);
    }

    @Unique
    private static void renderArm(PoseStack matrixStack, MultiBufferSource buffer, int light, AbstractClientPlayer player, HumanoidArm handSide) {
        if (!((Boolean)ModConfig.client.showFirstPersonGloves.get()).booleanValue()) {
            return;
        }
        InteractionHand hand = handSide == player.m_5737_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
            ICurioStacksHandler stacksHandler = (ICurioStacksHandler)handler.getCurios().get(SlotTypePreset.HANDS.getIdentifier());
            if (stacksHandler != null) {
                int slot;
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStacks = stacksHandler.getCosmeticStacks();
                int n = slot = hand == InteractionHand.MAIN_HAND ? 0 : 1;
                while (slot < stacks.getSlots()) {
                    GloveCurioRenderer renderer;
                    ItemStack stack = cosmeticStacks.getStackInSlot(slot);
                    if (stack.m_41619_() && ((Boolean)stacksHandler.getRenders().get(slot)).booleanValue()) {
                        stack = stacks.getStackInSlot(slot);
                    }
                    if ((renderer = GloveCurioRenderer.getGloveRenderer(stack)) != null) {
                        renderer.renderFirstPersonArm(matrixStack, buffer, light, player, handSide, stack.m_41790_());
                    }
                    slot += 2;
                }
            }
        });
    }
}

