/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.equipmentcompare.gui;

import com.anthonyhilyard.equipmentcompare.EquipmentCompare;
import com.anthonyhilyard.equipmentcompare.EquipmentCompareConfig;
import com.anthonyhilyard.iceberg.util.Tooltips;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.client.RenderProperties;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fmlclient.gui.GuiUtils;

public class ComparisonTooltips {
    private static void drawTooltip(PoseStack poseStack, ItemStack itemStack, Rect2i rect, List<Component> tooltipLines, Font font, Screen screen, int maxWidth, boolean showBadge) {
        int bgColor = (int)((Long)EquipmentCompareConfig.INSTANCE.badgeBackgroundColor.get()).longValue();
        int borderStartColor = (int)((Long)EquipmentCompareConfig.INSTANCE.badgeBorderStartColor.get()).longValue();
        int borderEndColor = (int)((Long)EquipmentCompareConfig.INSTANCE.badgeBorderEndColor.get()).longValue();
        Style textColor = Style.f_131099_.m_131148_(TextColor.m_131266_((int)((int)((Long)EquipmentCompareConfig.INSTANCE.badgeTextColor.get()).longValue())));
        MutableComponent equippedBadge = new TextComponent((String)EquipmentCompareConfig.INSTANCE.badgeText.get()).m_130948_(textColor);
        GuiUtils.preItemToolTip((ItemStack)itemStack);
        if (showBadge) {
            if (rect.m_110086_() + rect.m_110091_() + 4 > screen.f_96544_) {
                rect = new Rect2i(rect.m_110085_(), screen.f_96544_ - rect.m_110091_() - 4, rect.m_110090_(), rect.m_110091_());
            }
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 401.0);
            MultiBufferSource.BufferSource renderType = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            Matrix4f matrix = poseStack.m_85850_().m_85861_();
            int badgeOffset = 0;
            if (ModList.get().isLoaded("legendarytooltips")) {
                badgeOffset = 6;
                bgColor = -267386864;
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.m_110085_() + 1), (int)(rect.m_110086_() - 15 + badgeOffset), (int)(rect.m_110085_() + rect.m_110090_() - 1), (int)(rect.m_110086_() - 14 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)rect.m_110085_(), (int)(rect.m_110086_() - 14 + badgeOffset), (int)(rect.m_110085_() + 1), (int)(rect.m_110086_() - 2 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.m_110085_() + rect.m_110090_() - 1), (int)(rect.m_110086_() - 14 + badgeOffset), (int)(rect.m_110085_() + rect.m_110090_()), (int)(rect.m_110086_() - 2 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.m_110085_() + 1), (int)(rect.m_110086_() - 14 + badgeOffset), (int)(rect.m_110085_() + rect.m_110090_() - 1), (int)(rect.m_110086_() - 4 + badgeOffset), (int)bgColor, (int)bgColor);
            } else {
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.m_110085_() + 1), (int)(rect.m_110086_() - 15 + badgeOffset), (int)(rect.m_110085_() + rect.m_110090_() - 1), (int)(rect.m_110086_() - 14 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)rect.m_110085_(), (int)(rect.m_110086_() - 14 + badgeOffset), (int)(rect.m_110085_() + 1), (int)(rect.m_110086_() - 2 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.m_110085_() + rect.m_110090_() - 1), (int)(rect.m_110086_() - 14 + badgeOffset), (int)(rect.m_110085_() + rect.m_110090_()), (int)(rect.m_110086_() - 2 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.m_110085_() + 1), (int)(rect.m_110086_() - 2 + badgeOffset), (int)(rect.m_110085_() + rect.m_110090_() - 1), (int)(rect.m_110086_() - 1 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.m_110085_() + 1), (int)(rect.m_110086_() - 14 + badgeOffset), (int)(rect.m_110085_() + rect.m_110090_() - 1), (int)(rect.m_110086_() - 2 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.m_110085_() + 1), (int)(rect.m_110086_() - 13 + badgeOffset), (int)(rect.m_110085_() + 2), (int)(rect.m_110086_() - 3 + badgeOffset), (int)borderStartColor, (int)borderEndColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.m_110085_() + rect.m_110090_() - 2), (int)(rect.m_110086_() - 13 + badgeOffset), (int)(rect.m_110085_() + rect.m_110090_() - 1), (int)(rect.m_110086_() - 3 + badgeOffset), (int)borderStartColor, (int)borderEndColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.m_110085_() + 1), (int)(rect.m_110086_() - 14 + badgeOffset), (int)(rect.m_110085_() + rect.m_110090_() - 1), (int)(rect.m_110086_() - 13 + badgeOffset), (int)borderStartColor, (int)borderStartColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.m_110085_() + 1), (int)(rect.m_110086_() - 3 + badgeOffset), (int)(rect.m_110085_() + rect.m_110090_() - 1), (int)(rect.m_110086_() - 2 + badgeOffset), (int)borderEndColor, (int)borderEndColor);
            }
            font.m_92733_(Language.m_128107_().m_5536_((FormattedText)equippedBadge), (float)rect.m_110085_() + (float)((rect.m_110090_() - font.m_92852_((FormattedText)equippedBadge)) / 2), (float)rect.m_110086_() - 12.0f + (float)badgeOffset, -1, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)renderType, false, 0, 0xF000F0);
            renderType.m_109911_();
            poseStack.m_85849_();
        }
        Tooltips.renderItemTooltip((ItemStack)itemStack, (PoseStack)poseStack, (Tooltips.TooltipInfo)new Tooltips.TooltipInfo(tooltipLines, font), (Rect2i)rect, (int)screen.f_96543_, (int)screen.f_96544_, (int)-267386864, (int)0x505000FF, (int)1344798847, (boolean)showBadge);
    }

    public static boolean render(PoseStack poseStack, int x, int y, Slot hoveredSlot, Minecraft minecraft, Font font, Screen screen) {
        ItemStack itemStack = hoveredSlot != null ? hoveredSlot.m_7993_() : ItemStack.f_41583_;
        return ComparisonTooltips.render(poseStack, x, y, itemStack, minecraft, font, screen);
    }

    public static boolean render(PoseStack poseStack, int x, int y, ItemStack itemStack, Minecraft minecraft, Font font, Screen screen) {
        if (screen == null) {
            return false;
        }
        if (minecraft.f_91074_.f_36096_.m_142621_().m_41619_() && !itemStack.m_41619_() && !((List)EquipmentCompareConfig.INSTANCE.blacklist.get()).contains(itemStack.m_41720_().getRegistryName().toString())) {
            EquipmentSlot slot = Mob.m_147233_((ItemStack)itemStack);
            ArrayList<ItemStack> equippedItems = new ArrayList<ItemStack>();
            ItemStack equippedItem = minecraft.f_91074_.m_6844_(slot);
            boolean checkItem = true;
            if (slot == EquipmentSlot.MAINHAND) {
                if (!(itemStack.m_41720_() instanceof TieredItem) || !(equippedItem.m_41720_() instanceof TieredItem)) {
                    checkItem = false;
                } else if (((Boolean)EquipmentCompareConfig.INSTANCE.strict.get()).booleanValue() && !itemStack.m_41720_().getClass().equals(equippedItem.m_41720_().getClass())) {
                    checkItem = false;
                }
            }
            if (checkItem) {
                equippedItems.add(equippedItem);
                equippedItems.remove(ItemStack.f_41583_);
                equippedItems.remove(itemStack);
            }
            if (ModList.get().isLoaded("curios")) {
                try {
                    equippedItems.addAll((List)Class.forName("com.anthonyhilyard.equipmentcompare.CuriosHandler").getMethod("getCuriosMatchingSlot", LivingEntity.class, ItemStack.class).invoke(null, minecraft.f_91074_, itemStack));
                }
                catch (Exception e) {
                    EquipmentCompare.LOGGER.error((Object)e);
                }
            }
            if (ModList.get().isLoaded("baubles")) {
                try {
                    equippedItems.addAll((List)Class.forName("com.anthonyhilyard.equipmentcompare.BaublesHandler").getMethod("getBaublesMatchingSlot", Player.class, ItemStack.class).invoke(null, minecraft.f_91074_, itemStack));
                }
                catch (Exception e) {
                    EquipmentCompare.LOGGER.error((Object)e);
                }
            }
            equippedItems.removeIf(stack -> ((List)EquipmentCompareConfig.INSTANCE.blacklist.get()).contains(stack.m_41720_().getRegistryName().toString()));
            equippedItems.remove(itemStack);
            if (!equippedItems.isEmpty() && EquipmentCompare.tooltipActive ^ (Boolean)EquipmentCompareConfig.INSTANCE.defaultOn.get()) {
                Rect2i equippedRect;
                List itemStackTooltipLines;
                Rect2i itemStackRect;
                int maxWidth = (screen.f_96543_ - equippedItems.size() * 16) / (equippedItems.size() + 1);
                Font itemFont = RenderProperties.get((ItemStack)itemStack).getFont(itemStack);
                if (itemFont == null) {
                    itemFont = font;
                }
                itemStackRect = x + (itemStackRect = Tooltips.calculateRect((ItemStack)itemStack, (PoseStack)poseStack, (List)(itemStackTooltipLines = screen.m_96555_(itemStack)), (int)x, (int)y, (int)screen.f_96543_, (int)screen.f_96544_, (int)maxWidth, (Font)itemFont)).m_110090_() + 12 > screen.f_96543_ ? new Rect2i(screen.f_96543_ - itemStackRect.m_110090_() - 24, itemStackRect.m_110086_(), itemStackRect.m_110090_(), itemStackRect.m_110091_()) : new Rect2i(itemStackRect.m_110085_() - 2, itemStackRect.m_110086_(), itemStackRect.m_110090_(), itemStackRect.m_110091_());
                HashMap<ItemStack, Rect2i> tooltipRects = new HashMap<ItemStack, Rect2i>();
                HashMap<ItemStack, List> tooltipLines = new HashMap<ItemStack, List>();
                Rect2i previousRect = itemStackRect;
                boolean firstRect = true;
                for (ItemStack thisItem : equippedItems) {
                    if (RenderProperties.get((ItemStack)thisItem).getFont(thisItem) != null) {
                        itemFont = RenderProperties.get((ItemStack)thisItem).getFont(thisItem);
                    }
                    List equippedTooltipLines = screen.m_96555_(thisItem);
                    equippedRect = Tooltips.calculateRect((ItemStack)itemStack, (PoseStack)poseStack, (List)equippedTooltipLines, (int)(x - previousRect.m_110090_() - 14), (int)y, (int)screen.f_96543_, (int)screen.f_96544_, (int)maxWidth, (Font)itemFont);
                    TextComponent equippedBadge = new TextComponent((String)EquipmentCompareConfig.INSTANCE.badgeText.get());
                    int tooltipWidth = equippedRect.m_110090_();
                    equippedRect = new Rect2i(equippedRect.m_110085_(), equippedRect.m_110086_(), Math.max(equippedRect.m_110090_(), itemFont.m_92852_((FormattedText)equippedBadge) + 8), equippedRect.m_110091_());
                    if (firstRect) {
                        equippedRect = new Rect2i(previousRect.m_110085_() - equippedRect.m_110090_() - 16 - (equippedRect.m_110090_() - tooltipWidth) / 2, equippedRect.m_110086_(), equippedRect.m_110090_(), equippedRect.m_110091_());
                        firstRect = false;
                    } else {
                        equippedRect = new Rect2i(previousRect.m_110085_() - equippedRect.m_110090_() - 4 - (equippedRect.m_110090_() - tooltipWidth) / 2, equippedRect.m_110086_(), equippedRect.m_110090_(), equippedRect.m_110091_());
                    }
                    tooltipRects.put(thisItem, equippedRect);
                    tooltipLines.put(thisItem, equippedTooltipLines);
                    previousRect = equippedRect;
                }
                int xOffset = -((Rect2i)tooltipRects.get(equippedItems.get(equippedItems.size() - 1))).m_110085_();
                if (xOffset > 0) {
                    for (ItemStack thisItem : equippedItems) {
                        equippedRect = (Rect2i)tooltipRects.get(thisItem);
                        tooltipRects.replace(thisItem, new Rect2i(equippedRect.m_110085_() + xOffset, equippedRect.m_110086_(), equippedRect.m_110090_(), equippedRect.m_110091_()));
                    }
                    itemStackRect = new Rect2i(itemStackRect.m_110085_() + xOffset, itemStackRect.m_110086_(), itemStackRect.m_110090_(), itemStackRect.m_110091_());
                }
                for (ItemStack thisItem : equippedItems) {
                    ComparisonTooltips.drawTooltip(poseStack, thisItem, (Rect2i)tooltipRects.get(thisItem), (List)tooltipLines.get(thisItem), font, screen, maxWidth, true);
                }
                ComparisonTooltips.drawTooltip(poseStack, itemStack, itemStackRect, itemStackTooltipLines, font, screen, maxWidth, false);
                return true;
            }
            return false;
        }
        return false;
    }
}

