/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.dataserializers.DataSerializerItemList;
import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.corelib.item.ItemUtils;
import de.maxhenkel.corpse.corelib.net.NetUtils;
import de.maxhenkel.corpse.entities.CorpseBoundingBoxBase;
import de.maxhenkel.corpse.gui.Guis;
import de.maxhenkel.corpse.net.MessageSpawnDeathParticles;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class CorpseEntity
extends CorpseBoundingBoxBase {
    private static final EntityDataAccessor<Optional<UUID>> ID = SynchedEntityData.m_135353_(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<String> NAME = SynchedEntityData.m_135353_(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> SKELETON = SynchedEntityData.m_135353_(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> MODEL = SynchedEntityData.m_135353_(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<NonNullList<ItemStack>> EQUIPMENT = SynchedEntityData.m_135353_(CorpseEntity.class, DataSerializerItemList.ITEM_LIST);
    private int age;
    private int emptyAge;
    protected Death death;

    public CorpseEntity(EntityType type, Level world) {
        super(type, world);
        this.f_19850_ = true;
        this.emptyAge = -1;
        this.death = new Death.Builder(new UUID(0L, 0L), new UUID(0L, 0L)).build();
    }

    public CorpseEntity(Level world) {
        this((EntityType)Main.CORPSE_ENTITY_TYPE, world);
    }

    public static CorpseEntity createFromDeath(Player player, Death death) {
        CorpseEntity corpse = new CorpseEntity(player.f_19853_);
        corpse.death = death;
        corpse.setCorpseUUID(death.getPlayerUUID());
        corpse.setCorpseName(death.getPlayerName());
        corpse.setEquipment(death.getEquipment());
        corpse.m_6034_(death.getPosX(), Math.max(death.getPosY(), (double)player.f_19853_.m_141937_()), death.getPosZ());
        corpse.m_146922_(player.m_146908_());
        corpse.setCorpseModel(death.getModel());
        return corpse;
    }

    protected float m_6380_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.35f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        ++this.age;
        this.setIsSkeleton(this.age >= (Integer)Main.SERVER_CONFIG.corpseSkeletonTime.get());
        if (!this.m_20068_()) {
            double yMotion = 0.0;
            Vec3 motion = this.m_20184_();
            if (this.m_19941_((Tag)FluidTags.f_13131_) || this.m_19941_((Tag)FluidTags.f_13132_)) {
                yMotion = motion.f_82480_ < 0.0 ? motion.f_82480_ + (motion.f_82480_ < 0.03 ? 0.01 : 0.0) : motion.f_82480_ + (motion.f_82480_ < 0.03 ? 5.0E-4 : 0.0);
            } else if (((Boolean)Main.SERVER_CONFIG.fallIntoVoid.get()).booleanValue() || this.m_20186_() > (double)this.f_19853_.m_141937_()) {
                yMotion = Math.max(-2.0, motion.f_82480_ - 0.0625);
            }
            this.m_20334_(this.m_20184_().f_82479_ * 0.75, yMotion, this.m_20184_().f_82481_ * 0.75);
            if (!((Boolean)Main.SERVER_CONFIG.fallIntoVoid.get()).booleanValue() && this.m_20186_() < (double)this.f_19853_.m_141937_()) {
                this.m_6021_(this.m_20185_(), this.f_19853_.m_141937_(), this.m_20189_());
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        if (this.f_19853_.f_46443_) {
            return;
        }
        if ((Integer)Main.SERVER_CONFIG.corpseForceDespawnTime.get() > 0 && this.age > (Integer)Main.SERVER_CONFIG.corpseForceDespawnTime.get()) {
            this.m_146870_();
            return;
        }
        boolean empty = this.isEmpty();
        if (empty && this.emptyAge < 0) {
            this.emptyAge = this.age;
        } else if (empty && this.age - this.emptyAge >= (Integer)Main.SERVER_CONFIG.corpseDespawnTime.get()) {
            this.m_146870_();
        }
    }

    public boolean isMainInventoryEmpty() {
        return this.death.getMainInventory().stream().allMatch(ItemStack::m_41619_) && this.death.getArmorInventory().stream().allMatch(ItemStack::m_41619_) && this.death.getOffHandInventory().stream().allMatch(ItemStack::m_41619_);
    }

    public boolean isAdditionalInventoryEmpty() {
        return this.death.getAdditionalItems().stream().allMatch(ItemStack::m_41619_);
    }

    public boolean isEmpty() {
        return this.isMainInventoryEmpty() && this.isAdditionalInventoryEmpty();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (((Boolean)Main.SERVER_CONFIG.lavaDamage.get()).booleanValue() && source.m_19384_() && amount >= 2.0f) {
            this.m_146870_();
        }
        return super.m_6469_(source, amount);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.f_19853_.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer playerMP = (ServerPlayer)player;
            if (((Boolean)Main.SERVER_CONFIG.onlyOwnerAccess.get()).booleanValue()) {
                boolean isOp = playerMP.m_20310_(playerMP.f_8924_.m_7022_());
                if (isOp || !this.getCorpseUUID().isPresent() || playerMP.m_142081_().equals(this.getCorpseUUID().get())) {
                    Guis.openCorpseGUI((ServerPlayer)player, this);
                } else if (((Boolean)Main.SERVER_CONFIG.skeletonAccess.get()).booleanValue() && this.isSkeleton()) {
                    Guis.openCorpseGUI((ServerPlayer)player, this);
                }
            } else {
                Guis.openCorpseGUI((ServerPlayer)player, this);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public Component m_5446_() {
        String name = this.getCorpseName();
        if (name == null || name.trim().isEmpty()) {
            return super.m_5446_();
        }
        return new TranslatableComponent("entity.corpse.corpse_of", new Object[]{this.getCorpseName()});
    }

    public boolean m_6051_() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB m_6921_() {
        return this.m_142469_();
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public Optional<UUID> getCorpseUUID() {
        return (Optional)this.f_19804_.m_135370_(ID);
    }

    public void setCorpseUUID(UUID uuid) {
        if (uuid == null) {
            this.f_19804_.m_135381_(ID, Optional.empty());
        } else {
            this.f_19804_.m_135381_(ID, Optional.of(uuid));
        }
    }

    public Death getDeath() {
        return this.death;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setDeath(Death death) {
        this.death = death;
    }

    public String getCorpseName() {
        return (String)this.f_19804_.m_135370_(NAME);
    }

    public void setCorpseName(String name) {
        this.f_19804_.m_135381_(NAME, (Object)name);
    }

    public boolean isSkeleton() {
        return (Boolean)this.f_19804_.m_135370_(SKELETON);
    }

    public void setIsSkeleton(boolean skeleton) {
        this.f_19804_.m_135381_(SKELETON, (Object)skeleton);
    }

    public byte getCorpseModel() {
        return (Byte)this.f_19804_.m_135370_(MODEL);
    }

    public void setCorpseModel(byte model) {
        this.f_19804_.m_135381_(MODEL, (Object)model);
    }

    public void setEquipment(NonNullList<ItemStack> equipment) {
        this.f_19804_.m_135381_(EQUIPMENT, equipment);
    }

    public NonNullList<ItemStack> getEquipment() {
        return (NonNullList)this.f_19804_.m_135370_(EQUIPMENT);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ID, Optional.empty());
        this.f_19804_.m_135372_(NAME, (Object)"");
        this.f_19804_.m_135372_(SKELETON, (Object)false);
        this.f_19804_.m_135372_(MODEL, (Object)0);
        this.f_19804_.m_135372_(EQUIPMENT, (Object)NonNullList.m_122780_((int)EquipmentSlot.values().length, (Object)ItemStack.f_41583_));
    }

    public void m_142687_(Entity.RemovalReason reason) {
        for (ItemStack item : this.death.getAllItems()) {
            Containers.m_18992_((Level)this.f_19853_, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)item);
        }
        super.m_142687_(reason);
        if (this.f_19853_ instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)this.f_19853_;
            serverWorld.m_8795_(player -> player.m_20275_(this.m_20185_(), this.m_20186_(), this.m_20189_()) <= 4096.0).forEach(playerEntity -> NetUtils.sendTo(Main.SIMPLE_CHANNEL, playerEntity, new MessageSpawnDeathParticles(this.m_142081_())));
        }
    }

    public void spawnDeathParticles() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Vec3 lookVec = this.m_20154_().m_82541_();
        for (int i = 0; i <= 10; ++i) {
            double d = ((double)i / 10.0 - 0.5) * 2.0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x + lookVec.f_82479_ * d + (this.f_19853_.f_46441_.nextDouble() - 0.5), y + 0.25, z + lookVec.f_82481_ * d + (this.f_19853_.f_46441_.nextDouble() - 0.5), 0.0, 0.0, 0.0);
        }
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("Death")) {
            this.death = Death.fromNBT(compound.m_128469_("Death"));
        } else {
            UUID playerUUID = new UUID(compound.m_128454_("IDMost"), compound.m_128454_("IDLeast"));
            UUID deathID = new UUID(compound.m_128454_("DeathIDMost"), compound.m_128454_("DeathIDLeast"));
            Death.Builder builder = new Death.Builder(playerUUID, deathID);
            int size = compound.m_128451_("InventorySize");
            NonNullList additionalItems = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
            ItemUtils.readInventory(compound, "Inventory", (NonNullList<ItemStack>)additionalItems);
            builder.additionalItems((NonNullList<ItemStack>)additionalItems);
            NonNullList equipment = NonNullList.m_122780_((int)EquipmentSlot.values().length, (Object)ItemStack.f_41583_);
            ItemUtils.readItemList(compound, "Equipment", (NonNullList<ItemStack>)equipment);
            builder.equipment((NonNullList<ItemStack>)equipment);
            builder.playerName(compound.m_128461_("Name"));
            this.death = builder.build();
        }
        this.setEquipment(this.death.getEquipment());
        this.setCorpseUUID(this.death.getPlayerUUID());
        this.setCorpseName(this.death.getPlayerName());
        this.setCorpseModel(this.death.getModel());
        this.age = compound.m_128451_("Age");
        if (compound.m_128441_("EmptyAge")) {
            this.emptyAge = compound.m_128451_("EmptyAge");
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("Death", (net.minecraft.nbt.Tag)this.death.toNBT());
        compound.m_128405_("Age", this.age);
        if (this.emptyAge >= 0) {
            compound.m_128405_("EmptyAge", this.emptyAge);
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

